/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarimport.JarImportWizard;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class JarImportWizardAction
extends Action
implements IObjectActionDelegate,
ISelectionChangedListener {
    public static final int SIZING_WIZARD_HEIGHT = 520;
    public static final int SIZING_WIZARD_WIDTH = 470;
    private IStructuredSelection fSelection = null;
    private IWorkbenchPart fWorkbenchPart = null;

    public void run() {
        this.run((IAction)this);
    }

    public void run(IAction action) {
        if (this.fWorkbenchPart == null || this.fSelection == null) {
            return;
        }
        JarImportWizard wizard = new JarImportWizard(false);
        IWorkbenchWindow window = this.fWorkbenchPart.getSite().getWorkbenchWindow();
        wizard.init(window.getWorkbench(), this.fSelection);
        WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(Math.max(470, dialog.getShell().getSize().x), 520);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jdt.ui.jar_import_wizard_page_context");
        dialog.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object element;
        IStructuredSelection structured;
        this.fSelection = null;
        if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() == 1 && (element = structured.getFirstElement()) instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)element;
            try {
                if (JarImportWizard.isValidClassPathEntry(root.getRawClasspathEntry()) && JarImportWizard.isValidJavaProject(root.getJavaProject())) {
                    this.fSelection = structured;
                }
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
        }
        action.setEnabled(this.fSelection != null);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionChanged((IAction)this, event.getSelection());
    }

    public void setActivePart(IAction action, IWorkbenchPart part) {
        this.fWorkbenchPart = part;
    }
}

