/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.ui.fix.ICleanUp;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractCleanUp
implements ICleanUp {
    private static final String SETTINGS_FLAG_NAME = "flag";
    protected static final int MARGIN_SIZE = 0;
    private static final int INDENT_WIDTH = 20;
    private int fFlags;

    protected static IDialogSettings getSection(IDialogSettings settings, String sectionName) {
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    protected AbstractCleanUp(IDialogSettings settings, int defaultFlag) {
        if (settings.get(SETTINGS_FLAG_NAME) == null) {
            settings.put(SETTINGS_FLAG_NAME, defaultFlag);
        }
        this.fFlags = settings.getInt(SETTINGS_FLAG_NAME);
    }

    protected AbstractCleanUp(int flag) {
        this.fFlags = flag;
    }

    public void saveSettings(IDialogSettings settings) {
        settings.put(SETTINGS_FLAG_NAME, this.fFlags);
    }

    protected void setFlag(int flag, boolean b) {
        if (!this.isFlag(flag) && b) {
            this.fFlags |= flag;
        } else if (this.isFlag(flag) && !b) {
            this.fFlags &= ~flag;
        }
    }

    protected boolean isFlag(int flag) {
        return (this.fFlags & flag) != 0;
    }

    protected Button addCheckBox(Composite parent, final int flag, String label) {
        return this.addCheckBox(parent, flag, label, new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCleanUp.this.setFlag(flag, ((Button)e.getSource()).getSelection());
            }
        });
    }

    protected Button addCheckBox(Composite parent, int flag, String label, SelectionAdapter adapter) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        button.setSelection(this.isFlag(flag));
        button.addSelectionListener((SelectionListener)adapter);
        return button;
    }

    protected Button addRadioButton(Composite parent, final int flag, String label) {
        return this.addRadioButton(parent, flag, label, new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCleanUp.this.setFlag(flag, ((Button)e.getSource()).getSelection());
            }
        });
    }

    protected Button addRadioButton(Composite parent, int flag, String label, SelectionAdapter adapter) {
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        button.setSelection(this.isFlag(flag));
        button.addSelectionListener((SelectionListener)adapter);
        return button;
    }

    protected Button[] createSubGroup(Composite parent, Button controlButton, int style, final int[] flags, String[] labels, final int[] uiFlags, boolean isVertical) {
        Composite sub = new Composite(parent, 0);
        sub.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout(isVertical ? 1 : flags.length, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        sub.setLayout((Layout)layout);
        final Button[] buttons = new Button[flags.length];
        int i = 0;
        while (i < buttons.length) {
            buttons[i] = style == 32 ? this.addCheckBox(sub, flags[i], labels[i]) : this.addRadioButton(sub, flags[i], labels[i]);
            if (i == 0 || isVertical) {
                this.indent((Control)buttons[i]);
            }
            final int index = i;
            buttons[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean isSelected = ((Button)e.getSource()).getSelection();
                    AbstractCleanUp.this.setFlag(uiFlags[index], isSelected);
                }
            });
            ++i;
        }
        if (this.hasFlag(flags)) {
            controlButton.setSelection(true);
            i = 0;
            while (i < flags.length) {
                if (this.isFlag(flags[i])) {
                    this.setFlag(uiFlags[i], true);
                } else {
                    this.setFlag(uiFlags[i], false);
                }
                ++i;
            }
        } else {
            controlButton.setSelection(false);
            boolean hasCheck = false;
            int i2 = 0;
            while (i2 < buttons.length) {
                Button b = buttons[i2];
                b.setEnabled(false);
                boolean flag = this.isFlag(uiFlags[i2]);
                if (flag) {
                    if (style == 32) {
                        b.setSelection(true);
                    } else if (!hasCheck) {
                        b.setSelection(true);
                    }
                    hasCheck = true;
                } else {
                    b.setSelection(false);
                }
                ++i2;
            }
            if (style == 16 && !hasCheck) {
                buttons[0].setSelection(true);
                this.setFlag(uiFlags[0], true);
            }
        }
        controlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSelected = ((Button)e.getSource()).getSelection();
                int i = 0;
                while (i < buttons.length) {
                    buttons[i].setEnabled(isSelected);
                    ++i;
                }
                if (!isSelected) {
                    i = 0;
                    while (i < flags.length) {
                        AbstractCleanUp.this.setFlag(flags[i], false);
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < flags.length) {
                        AbstractCleanUp.this.setFlag(flags[i], buttons[i].getSelection());
                        ++i;
                    }
                }
            }
        });
        return buttons;
    }

    private boolean hasFlag(int[] flags) {
        int i = 0;
        while (i < flags.length) {
            if (this.isFlag(flags[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void indent(Control control) {
        GridData data = (GridData)control.getLayoutData();
        data.horizontalIndent = 20;
    }

    protected int getNumberOfProblems(IProblem[] problems, int problemId) {
        int result = 0;
        int i = 0;
        while (i < problems.length) {
            if (problems[i].getID() == problemId) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public void beginCleanUp(IJavaProject project, ICompilationUnit[] compilationUnits, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.done();
        }
    }

    public void endCleanUp() throws CoreException {
    }
}

