/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.CodeStyleFix;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class CodeStyleCleanUp
extends AbstractCleanUp {
    public static final int QUALIFY_FIELD_ACCESS = 1;
    public static final int CHANGE_NON_STATIC_ACCESS_TO_STATIC = 2;
    public static final int QUALIFY_STATIC_FIELD_ACCESS = 4;
    public static final int CHANGE_INDIRECT_STATIC_ACCESS_TO_DIRECT = 8;
    private static final int DEFAULT_FLAG = 10;
    private static final String SECTION_NAME = "CleanUp_CodeStyle";

    public CodeStyleCleanUp(int flag) {
        super(flag);
    }

    public CodeStyleCleanUp(IDialogSettings settings) {
        super(CodeStyleCleanUp.getSection(settings, SECTION_NAME), 10);
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return CodeStyleFix.createCleanUp(compilationUnit, this.isFlag(1), this.isFlag(2), this.isFlag(4), this.isFlag(8));
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return CodeStyleFix.createCleanUp(compilationUnit, problems, this.isFlag(1), this.isFlag(2), this.isFlag(8));
    }

    public Map getRequiredOptions() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        if (this.isFlag(2)) {
            options.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "warning");
        }
        if (this.isFlag(8)) {
            options.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", "warning");
        }
        return options;
    }

    public Control createConfigurationControl(Composite parent, IJavaProject project) {
        this.indent((Control)this.addCheckBox(parent, 1, MultiFixMessages.CodeStyleCleanUp_useThis_checkBoxLabel));
        Button button = new Button(parent, 32);
        button.setText(MultiFixMessages.CodeStyleCleanUp_useDeclaring_checkBoxLabel);
        button.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.indent((Control)button);
        Composite sub = new Composite(parent, 0);
        sub.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        sub.setLayout((Layout)layout);
        this.indent((Control)sub);
        int[] flags = new int[]{2, 8, 4};
        int[] uiFlags = new int[]{0x40000000, 0x20000000, 0x10000000};
        String[] labels = new String[]{MultiFixMessages.CodeStyleCleanUp_changeNonStatic_checkBoxLabel, MultiFixMessages.CodeStyleCleanUp_changeIndirect_checkBoxLabel, MultiFixMessages.CodeStyleCleanUp_addStaticQualifier_checkBoxLabel};
        this.createSubGroup(sub, button, 32, flags, labels, uiFlags, true);
        return parent;
    }

    public void saveSettings(IDialogSettings settings) {
        super.saveSettings(CodeStyleCleanUp.getSection(settings, SECTION_NAME));
    }

    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isFlag(1)) {
            result.add(MultiFixMessages.CodeStyleMultiFix_AddThisQualifier_description);
        }
        if (this.isFlag(4)) {
            result.add(MultiFixMessages.CodeStyleMultiFix_QualifyAccessToStaticField);
        }
        if (this.isFlag(2)) {
            result.add(MultiFixMessages.CodeStyleMultiFix_ChangeNonStaticAccess_description);
        }
        if (this.isFlag(8)) {
            result.add(MultiFixMessages.CodeStyleMultiFix_ChangeIndirectAccessToStaticToDirect);
        }
        return result.toArray(new String[result.size()]);
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        CodeStyleFix[] fixes;
        CodeStyleFix fix;
        if (this.isFlag(1) && (fix = CodeStyleFix.createAddFieldQualifierFix(compilationUnit, problem)) != null) {
            return true;
        }
        if (this.isFlag(8) && (fix = CodeStyleFix.createIndirectAccessToStaticFix(compilationUnit, problem)) != null) {
            return true;
        }
        return this.isFlag(2) && (fixes = CodeStyleFix.createNonStaticAccessFixes(compilationUnit, problem)) != null && fixes.length > 0;
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        int id;
        int i;
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        if (this.isFlag(1)) {
            result += this.getNumberOfProblems(problems, 570425423);
        }
        if (this.isFlag(8)) {
            i = 0;
            while (i < problems.length) {
                id = problems[i].getID();
                if (id == 570425422 || id == 603979895) {
                    ++result;
                }
                ++i;
            }
        }
        if (this.isFlag(2)) {
            i = 0;
            while (i < problems.length) {
                id = problems[i].getID();
                if (id == 570425420 || id == 603979893) {
                    ++result;
                }
                ++i;
            }
        }
        return result;
    }
}

