/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.fix.StringFix;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class StringCleanUp
extends AbstractCleanUp {
    public static final int ADD_MISSING_NLS_TAG = 1;
    public static final int REMOVE_UNNECESSARY_NLS_TAG = 2;
    private static final int DEFAULT_FLAG = 2;
    private static final String SECTION_NAME = "CleanUp_NLSTag";

    public StringCleanUp(int flag) {
        super(flag);
    }

    public StringCleanUp(IDialogSettings settings) {
        super(StringCleanUp.getSection(settings, SECTION_NAME), 2);
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return StringFix.createCleanUp(compilationUnit, this.isFlag(1), this.isFlag(2));
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return StringFix.createCleanUp(compilationUnit, problems, this.isFlag(1), this.isFlag(2));
    }

    public Map getRequiredOptions() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (this.isFlag(1) || this.isFlag(2)) {
            result.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
        }
        return result;
    }

    public Control createConfigurationControl(Composite parent, IJavaProject project) {
        this.indent((Control)this.addCheckBox(parent, 2, MultiFixMessages.StringCleanUp_RemoveNLSTag_label));
        return parent;
    }

    public void saveSettings(IDialogSettings settings) {
        super.saveSettings(StringCleanUp.getSection(settings, SECTION_NAME));
    }

    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isFlag(1)) {
            result.add(MultiFixMessages.StringMultiFix_AddMissingNonNls_description);
        }
        if (this.isFlag(2)) {
            result.add(MultiFixMessages.StringMultiFix_RemoveUnnecessaryNonNls_description);
        }
        return result.toArray(new String[result.size()]);
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        return StringFix.createFix(compilationUnit, problem, this.isFlag(2), this.isFlag(1)) != null;
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        if (this.isFlag(1)) {
            result += this.getNumberOfProblems(problems, 536871173);
        }
        if (this.isFlag(2)) {
            result += this.getNumberOfProblems(problems, 536871177);
        }
        return result;
    }
}

