/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.fix.UnusedCodeFix;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class UnusedCodeCleanUp
extends AbstractCleanUp {
    public static final int REMOVE_UNUSED_IMPORTS = 1;
    public static final int REMOVE_UNUSED_PRIVATE_CONSTRUCTORS = 2;
    public static final int REMOVE_UNUSED_PRIVATE_METHODS = 4;
    public static final int REMOVE_UNUSED_PRIVATE_FIELDS = 8;
    public static final int REMOVE_UNUSED_PRIVATE_TYPES = 16;
    public static final int REMOVE_UNUSED_LOCAL_VARIABLES = 32;
    public static final int REMOVE_UNUSED_CAST = 64;
    private static final int DEFAULT_FLAG = 1;
    private static final String SECTION_NAME = "CleanUp_UnusedCode";

    public UnusedCodeCleanUp(int flag) {
        super(flag);
    }

    public UnusedCodeCleanUp(IDialogSettings settings) {
        super(UnusedCodeCleanUp.getSection(settings, SECTION_NAME), 1);
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return UnusedCodeFix.createCleanUp(compilationUnit, this.isFlag(4), this.isFlag(2), this.isFlag(8), this.isFlag(16), this.isFlag(32), this.isFlag(1), this.isFlag(64));
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return UnusedCodeFix.createCleanUp(compilationUnit, problems, this.isFlag(4), this.isFlag(2), this.isFlag(8), this.isFlag(16), this.isFlag(32), this.isFlag(1), this.isFlag(64));
    }

    public Map getRequiredOptions() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        if (this.isFlag(1)) {
            options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "warning");
        }
        if (this.isFlag(30)) {
            options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "warning");
        }
        if (this.isFlag(32)) {
            options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        }
        if (this.isFlag(64)) {
            options.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "warning");
        }
        return options;
    }

    public Control createConfigurationControl(Composite composite, IJavaProject project) {
        this.indent((Control)this.addCheckBox(composite, 1, MultiFixMessages.UnusedCodeCleanUp_unusedImports_checkBoxLabel));
        Button button = new Button(composite, 32);
        button.setText(MultiFixMessages.UnusedCodeCleanUp_unusedPrivateMembers_checkBoxLabel);
        button.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.indent((Control)button);
        Composite sub = new Composite(composite, 0);
        sub.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        sub.setLayout((Layout)layout);
        this.indent((Control)sub);
        int[] flags = new int[]{16, 2, 4, 8};
        int[] uiFlags = new int[]{0x40000000, 0x20000000, 0x10000000, 0x8000000};
        String[] labels = new String[]{MultiFixMessages.UnusedCodeCleanUp_unusedTypes_checkBoxLabel, MultiFixMessages.UnusedCodeCleanUp_unusedConstructors_checkBoxLabel, MultiFixMessages.UnusedCodeCleanUp_unusedMethods_checkBoxLabel, MultiFixMessages.UnusedCodeCleanUp_unusedFields_checkBoxLabel};
        this.createSubGroup(sub, button, 32, flags, labels, uiFlags, false);
        this.indent((Control)this.addCheckBox(composite, 32, MultiFixMessages.UnusedCodeCleanUp_unusedLocalVariables_checkBoxLabel));
        this.indent((Control)this.addCheckBox(composite, 64, MultiFixMessages.UnusedCodeCleanUp_unnecessaryCasts_checkBoxLabel));
        return composite;
    }

    public void saveSettings(IDialogSettings settings) {
        super.saveSettings(UnusedCodeCleanUp.getSection(settings, SECTION_NAME));
    }

    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isFlag(1)) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedImport_description);
        }
        if (this.isFlag(4)) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedMethod_description);
        }
        if (this.isFlag(2)) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedConstructor_description);
        }
        if (this.isFlag(16)) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedType_description);
        }
        if (this.isFlag(8)) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedField_description);
        }
        if (this.isFlag(32)) {
            result.add(MultiFixMessages.UnusedCodeMultiFix_RemoveUnusedVariable_description);
        }
        if (this.isFlag(64)) {
            result.add(MultiFixMessages.UnusedCodeCleanUp_RemoveUnusedCasts_description);
        }
        return result.toArray(new String[result.size()]);
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        IFix fix;
        if (this.isFlag(1) && (fix = UnusedCodeFix.createRemoveUnusedImportFix(compilationUnit, problem)) != null) {
            return true;
        }
        if ((this.isFlag(4) || this.isFlag(2) || this.isFlag(16) || this.isFlag(8) || this.isFlag(32)) && (fix = UnusedCodeFix.createUnusedMemberFix(compilationUnit, problem)) != null) {
            return true;
        }
        return this.isFlag(64) && (fix = UnusedCodeFix.createRemoveUnusedCastFix(compilationUnit, problem)) != null;
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        if (this.isFlag(1)) {
            int i = 0;
            while (i < problems.length) {
                int id = problems[i].getID();
                if (id == 268435844 || id == 268435842 || id == 0x10000181 || id == 268435843 || id == 268435846) {
                    ++result;
                }
                ++i;
            }
        }
        if (this.isFlag(4)) {
            result += this.getNumberOfProblems(problems, 603979894);
        }
        if (this.isFlag(2)) {
            result += this.getNumberOfProblems(problems, 603979910);
        }
        if (this.isFlag(16)) {
            result += this.getNumberOfProblems(problems, 553648135);
        }
        if (this.isFlag(8)) {
            result += this.getNumberOfProblems(problems, 570425421);
        }
        if (this.isFlag(32)) {
            result += this.getNumberOfProblems(problems, 536870973);
        }
        if (this.isFlag(64)) {
            result += this.getNumberOfProblems(problems, 553648309);
        }
        return result;
    }
}

