/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackager;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryService;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class JarPackagerUtil {
    static final String JAR_EXTENSION = "jar";
    static final String DESCRIPTION_EXTENSION = "jardesc";
    private static final String REFACTORINGS_ENTRY = "META-INF/REFACTORINGS.XML";

    public static boolean askToCreateDirectory(Shell parent, File directory) {
        if (parent == null) {
            return false;
        }
        return JarPackagerUtil.queryDialog(parent, JarPackagerMessages.JarPackage_confirmCreate_title, Messages.format(JarPackagerMessages.JarPackage_confirmCreate_message, directory.toString()));
    }

    public static String getRefactoringsEntryName() {
        return REFACTORINGS_ENTRY;
    }

    public static List asResources(Object[] fSelectedElements) {
        if (fSelectedElements == null) {
            return null;
        }
        ArrayList<Object> selectedResources = new ArrayList<Object>(fSelectedElements.length);
        int i = 0;
        while (i < fSelectedElements.length) {
            Object element = fSelectedElements[i];
            if (element instanceof IJavaElement) {
                selectedResources.add(((IJavaElement)element).getResource());
            } else if (element instanceof IResource) {
                selectedResources.add(element);
            }
            ++i;
        }
        return selectedResources;
    }

    public static boolean askForOverwritePermission(Shell parent, String filePath) {
        if (parent == null) {
            return false;
        }
        return JarPackagerUtil.queryDialog(parent, JarPackagerMessages.JarPackage_confirmReplace_title, Messages.format(JarPackagerMessages.JarPackage_confirmReplace_message, filePath));
    }

    static boolean canOverwrite(Shell parent, IFile file) {
        if (file.isAccessible()) {
            return true;
        }
        return JarPackagerUtil.askForOverwritePermission(parent, file.getFullPath().toString());
    }

    static String getMainClassName(JarPackageData jarPackage) {
        if (jarPackage.getManifestMainClass() == null) {
            return "";
        }
        return jarPackage.getManifestMainClass().getFullyQualifiedName();
    }

    private static boolean queryDialog(final Shell parent, final String title, final String message) {
        Display display = parent.getDisplay();
        if (display == null || display.isDisposed()) {
            return false;
        }
        final boolean[] returnValue = new boolean[1];
        Runnable runnable = new Runnable(){

            public void run() {
                returnValue[0] = MessageDialog.openQuestion((Shell)parent, (String)title, (String)message);
            }
        };
        display.syncExec(runnable);
        return returnValue[0];
    }

    public static CoreException createCoreException(String message, Exception ex) {
        if (message == null) {
            message = "";
        }
        return new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", 10001, message, (Throwable)ex));
    }

    public static boolean isMainClassValid(JarPackageData data, IRunnableContext context) {
        if (data == null) {
            return false;
        }
        IType mainClass = data.getManifestMainClass();
        if (mainClass == null) {
            return true;
        }
        try {
            IFile file = (IFile)mainClass.getResource();
            if (file == null || !JarPackagerUtil.contains(JarPackagerUtil.asResources(data.getElements()), file)) {
                return false;
            }
            return JavaModelUtil.hasMainMethod(mainClass);
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e.getStatus());
            return false;
        }
    }

    static boolean contains(List resources, IFile file) {
        if (resources == null || file == null) {
            return false;
        }
        if (resources.contains(file)) {
            return true;
        }
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            if (resource == null || resource.getType() == 1) continue;
            List<IResource> children = null;
            try {
                children = Arrays.asList(((IContainer)resource).members());
            }
            catch (CoreException coreException) {
                continue;
            }
            if (children == null || !JarPackagerUtil.contains(children, file)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void calculateCrcAndSize(JarEntry entry, InputStream stream, byte[] buffer) throws IOException {
        CRC32 crc;
        int size;
        block7: {
            size = 0;
            crc = new CRC32();
            try {
                int count;
                while ((count = stream.read(buffer, 0, buffer.length)) != -1) {
                    crc.update(buffer, 0, count);
                    size += count;
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (stream == null) break block7;
            }
            try {}
            catch (IOException iOException) {}
            stream.close();
        }
        entry.setSize(size);
        entry.setCrc(crc.getValue());
    }

    public static RefactoringHistory retrieveHistory(IProject[] projects, long start, long end, int filter, IProgressMonitor monitor) {
        Assert.isNotNull((Object)projects);
        if (start >= 0L && end >= start) {
            RefactoringHistory refactoringHistory;
            IRefactoringHistoryService service = RefactoringCore.getRefactoringHistoryService();
            try {
                service.connect();
                refactoringHistory = service.getRefactoringHistory(projects, start, end, 0x10000 | filter, monitor);
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                service.disconnect();
                throw throwable;
            }
            service.disconnect();
            return refactoringHistory;
        }
        return null;
    }
}

