/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.Comparator;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.corext.codemanipulation.AddImportsOperation;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.corext.util.TypeInfoHistory;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.TypeInfoLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.texteditor.IUpdate;

public class AddImportOnSelectionAction
extends Action
implements IUpdate {
    private static final AddImportComparator ADD_IMPORT_COMPARATOR = new AddImportComparator();
    private CompilationUnitEditor fEditor;

    public AddImportOnSelectionAction(CompilationUnitEditor editor) {
        super(JavaEditorMessages.AddImportOnSelection_label);
        this.setToolTipText(JavaEditorMessages.AddImportOnSelection_tooltip);
        this.setDescription(JavaEditorMessages.AddImportOnSelection_description);
        this.fEditor = editor;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.add_imports_on_selection_action_context");
        this.setEnabled(this.getCompilationUnit() != null);
    }

    public void update() {
        this.setEnabled(this.fEditor != null && this.getCompilationUnit() != null);
    }

    private ICompilationUnit getCompilationUnit() {
        if (this.fEditor == null) {
            return null;
        }
        WorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
        return manager.getWorkingCopy(this.fEditor.getEditorInput());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        ICompilationUnit cu = this.getCompilationUnit();
        if (cu == null) return;
        if (this.fEditor == null) {
            return;
        }
        if (!ElementValidator.checkValidateEdit((IJavaElement)cu, this.getShell(), JavaEditorMessages.AddImportOnSelection_error_title)) {
            return;
        }
        if (!ActionUtil.isProcessable(this.getShell(), cu)) {
            return;
        }
        ISelection selection = this.fEditor.getSelectionProvider().getSelection();
        IDocument doc = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
        if (!(selection instanceof ITextSelection)) return;
        if (doc == null) return;
        ITextSelection textSelection = (ITextSelection)selection;
        SelectTypeQuery query = new SelectTypeQuery(this.getShell());
        AddImportsOperation op = new AddImportsOperation(cu, doc, textSelection.getOffset(), textSelection.getLength(), query);
        IEditingSupport helper = this.createViewerHelper(textSelection, query);
        try {
            try {
                IStatusLineManager manager;
                this.registerHelper(helper);
                IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                progressService.runInUI((IRunnableContext)this.fEditor.getSite().getWorkbenchWindow(), (IRunnableWithProgress)new WorkbenchRunnableAdapter(op, op.getScheduleRule()), op.getScheduleRule());
                IStatus status = op.getStatus();
                if (!status.isOK() && (manager = this.getStatusLineManager()) != null) {
                    manager.setMessage(status.getMessage());
                }
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, this.getShell(), JavaEditorMessages.AddImportOnSelection_error_title, null);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this.deregisterHelper(helper);
            throw throwable;
        }
        {
            Object var11_14 = null;
            this.deregisterHelper(helper);
            return;
        }
    }

    private IEditingSupport createViewerHelper(final ITextSelection selection, final SelectTypeQuery query) {
        return new IEditingSupport(){

            public boolean isOriginator(DocumentEvent event, IRegion subjectRegion) {
                return subjectRegion.getOffset() <= selection.getOffset() + selection.getLength() && selection.getOffset() <= subjectRegion.getOffset() + subjectRegion.getLength();
            }

            public boolean ownsFocusShell() {
                return query.isShowing();
            }
        };
    }

    private void registerHelper(IEditingSupport helper) {
        ISourceViewer viewer = this.fEditor.getViewer();
        if (viewer instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry registry = (IEditingSupportRegistry)viewer;
            registry.register(helper);
        }
    }

    private void deregisterHelper(IEditingSupport helper) {
        ISourceViewer viewer = this.fEditor.getViewer();
        if (viewer instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry registry = (IEditingSupportRegistry)viewer;
            registry.unregister(helper);
        }
    }

    private Shell getShell() {
        return this.fEditor.getSite().getShell();
    }

    private IStatusLineManager getStatusLineManager() {
        IEditorActionBarContributor contributor = this.fEditor.getEditorSite().getActionBarContributor();
        if (contributor instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
        }
        return null;
    }

    public ISchedulingRule getScheduleRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    static /* synthetic */ AddImportComparator access$0() {
        return ADD_IMPORT_COMPARATOR;
    }

    private static final class AddImportComparator
    implements Comparator {
        AddImportComparator() {
        }

        public int compare(Object o1, Object o2) {
            int pos2;
            if (((String)o1).equals(o2)) {
                return 0;
            }
            TypeInfoHistory history = TypeInfoHistory.getDefault();
            int pos1 = history.getPosition(o1);
            if (pos1 == (pos2 = history.getPosition(o2))) {
                return Collator.getInstance().compare(o1, o2);
            }
            if (pos1 > pos2) {
                return -1;
            }
            return 1;
        }
    }

    private static class SelectTypeQuery
    implements AddImportsOperation.IChooseImportQuery {
        private final Shell fShell;
        private boolean fIsShowing;

        public SelectTypeQuery(Shell shell) {
            this.fShell = shell;
        }

        public TypeInfo chooseImport(TypeInfo[] results, String containerName) {
            int nResults = results.length;
            if (nResults == 0) {
                return null;
            }
            if (nResults == 1) {
                return results[0];
            }
            if (containerName.length() != 0) {
                int i = 0;
                while (i < nResults) {
                    TypeInfo curr = results[i];
                    if (containerName.equals(curr.getTypeContainerName())) {
                        return curr;
                    }
                    ++i;
                }
            }
            this.fIsShowing = true;
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this, this.fShell, (ILabelProvider)new TypeInfoLabelProvider(1)){
                final /* synthetic */ SelectTypeQuery this$1;
                {
                    this.this$1 = selectTypeQuery;
                }

                protected FilteredList createFilteredList(Composite parent) {
                    FilteredList filteredList = super.createFilteredList(parent);
                    filteredList.setComparator((Comparator)AddImportOnSelectionAction.access$0());
                    return filteredList;
                }
            };
            dialog.setTitle(JavaEditorMessages.AddImportOnSelection_dialog_title);
            dialog.setMessage(JavaEditorMessages.AddImportOnSelection_dialog_message);
            dialog.setElements((Object[])results);
            if (dialog.open() == 0) {
                this.fIsShowing = false;
                TypeInfo result = (TypeInfo)dialog.getFirstResult();
                TypeInfoHistory.remember(result);
                return result;
            }
            this.fIsShowing = false;
            return null;
        }

        boolean isShowing() {
            return this.fIsShowing;
        }
    }
}

