/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import org.eclipse.core.resources.IFolder;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerProblemsDecorator;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jface.util.Assert;

public class PackageExplorerLabelProvider
extends AppearanceAwareLabelProvider {
    private PackageExplorerContentProvider fContentProvider;
    private boolean fIsFlatLayout;
    private PackageExplorerProblemsDecorator fProblemDecorator = new PackageExplorerProblemsDecorator();

    PackageExplorerLabelProvider(long textFlags, int imageFlags, PackageExplorerContentProvider cp) {
        super(textFlags, imageFlags);
        this.addLabelDecorator(this.fProblemDecorator);
        Assert.isNotNull((Object)cp);
        this.fContentProvider = cp;
    }

    public String getText(Object element) {
        if (this.fIsFlatLayout || !(element instanceof IPackageFragment)) {
            return super.getText(element);
        }
        IPackageFragment fragment = (IPackageFragment)element;
        if (fragment.isDefaultPackage()) {
            return super.getText(fragment);
        }
        Object parent = this.fContentProvider.getPackageFragmentProvider().getParent(fragment);
        if (parent instanceof IPackageFragment) {
            return this.getNameDelta((IPackageFragment)parent, fragment);
        }
        if (parent instanceof IFolder) {
            int prefixLength = this.getPrefixLength((IFolder)parent);
            return fragment.getElementName().substring(prefixLength);
        }
        return super.getText(fragment);
    }

    private int getPrefixLength(IFolder folder) {
        Object parent = this.fContentProvider.getParent(folder);
        int folderNameLenght = folder.getName().length() + 1;
        if (parent instanceof IPackageFragment) {
            String fragmentName = ((IPackageFragment)parent).getElementName();
            return fragmentName.length() + 1 + folderNameLenght;
        }
        if (parent instanceof IFolder) {
            return this.getPrefixLength((IFolder)parent) + folderNameLenght;
        }
        return folderNameLenght;
    }

    private String getNameDelta(IPackageFragment topFragment, IPackageFragment bottomFragment) {
        String bottomName;
        String topName = topFragment.getElementName();
        if (topName.equals(bottomName = bottomFragment.getElementName())) {
            return topName;
        }
        String deltaname = bottomName.substring(topName.length() + 1);
        return deltaname;
    }

    public void setIsFlatLayout(boolean state) {
        this.fIsFlatLayout = state;
        this.fProblemDecorator.setIsFlatLayout(state);
    }
}

