/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.binary;

import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.binary.StubCreationOperation;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarimport.JarImportMessages;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryWizard;

public abstract class StubRefactoringHistoryWizard
extends RefactoringHistoryWizard {
    private static final String META_INF_FRAGMENT = "META-INF/MANIFEST.MF".substring(0, "META-INF/MANIFEST.MF".indexOf(47));
    private static final String SOURCE_FOLDER = ".src";
    private static final String STUB_FOLDER = ".stubs";
    private boolean fAutoBuild = true;
    protected boolean fCancelled = false;
    protected IJavaProject fJavaProject = null;
    private final Collection fProcessedFragments = new HashSet();
    protected IFolder fSourceFolder = null;
    static /* synthetic */ Class class$0;

    private static void addExclusionPatterns(List entries, IPath path) {
        int index = 0;
        while (index < entries.size()) {
            IPath[] patterns;
            IClasspathEntry entry = (IClasspathEntry)entries.get(index);
            if (entry.getEntryKind() == 3 && entry.getPath().isPrefixOf(path) && !JavaModelUtil.isExcludedPath(path, patterns = entry.getExclusionPatterns())) {
                IPath[] filters = new IPath[patterns.length + 1];
                System.arraycopy(patterns, 0, filters, 0, patterns.length);
                filters[patterns.length] = path.removeFirstSegments(entry.getPath().segmentCount()).addTrailingSeparator();
                entries.set(index, JavaCore.newSourceEntry((IPath)entry.getPath(), (IPath[])filters, (IPath)entry.getOutputLocation()));
            }
            ++index;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static RefactoringStatus checkPackageFragmentRoots(IPackageFragmentRoot root, IProgressMonitor monitor) {
        RefactoringStatus status = new RefactoringStatus();
        try {
            block15: {
                IJavaModel model;
                monitor.beginTask(JarImportMessages.JarImportWizard_prepare_import, 100);
                IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
                if (workspace != null && (model = JavaCore.create((IWorkspaceRoot)workspace)) != null) {
                    try {
                        URI uri = StubRefactoringHistoryWizard.getLocationURI(root.getRawClasspathEntry());
                        if (uri == null) break block15;
                        IJavaProject[] projects = model.getJavaProjects();
                        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 100, 2);
                        try {
                            subMonitor.beginTask(JarImportMessages.JarImportWizard_prepare_import, projects.length * 100);
                            int index = 0;
                            while (index < projects.length) {
                                Object var15_16;
                                IPackageFragmentRoot[] roots = projects[index].getPackageFragmentRoots();
                                SubProgressMonitor subsubMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 100, 2);
                                try {
                                    subsubMonitor.beginTask(JarImportMessages.JarImportWizard_prepare_import, roots.length);
                                    int offset = 0;
                                    while (offset < roots.length) {
                                        URI location;
                                        IClasspathEntry entry;
                                        IPackageFragmentRoot current = roots[offset];
                                        if (!current.equals(root) && current.getKind() == 2 && (entry = current.getRawClasspathEntry()).getEntryKind() == 1 && uri.equals(location = StubRefactoringHistoryWizard.getLocationURI(entry))) {
                                            status.addFatalError(MessageFormat.format(JarImportMessages.JarImportWizard_error_shared_jar, current.getJavaProject().getElementName()));
                                        }
                                        subsubMonitor.worked(1);
                                        ++offset;
                                    }
                                    var15_16 = null;
                                }
                                catch (Throwable throwable) {
                                    var15_16 = null;
                                    subsubMonitor.done();
                                    throw throwable;
                                }
                                subsubMonitor.done();
                                ++index;
                            }
                            Object var17_20 = null;
                        }
                        catch (Throwable throwable) {
                            Object var17_19 = null;
                            subMonitor.done();
                            throw throwable;
                        }
                        subMonitor.done();
                    }
                    catch (CoreException exception) {
                        status.addError(exception.getLocalizedMessage());
                    }
                }
            }
            Object var19_23 = null;
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return status;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void configureClasspath(IJavaProject project, IPackageFragmentRoot root, IFolder folder, IProgressMonitor monitor) throws IllegalStateException, CoreException {
        try {
            monitor.beginTask(JarImportMessages.JarImportWizard_prepare_import, 200);
            IClasspathEntry entry = root.getRawClasspathEntry();
            IClasspathEntry[] entries = project.getRawClasspath();
            ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
            list.addAll(Arrays.asList(entries));
            IFileStore store = EFS.getLocalFileSystem().getStore(JavaPlugin.getDefault().getStateLocation().append(STUB_FOLDER).append(project.getElementName()));
            if (store.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 25, 2)).exists()) {
                store.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 25, 2));
            }
            store.mkdir(0, (IProgressMonitor)new SubProgressMonitor(monitor, 25, 2));
            folder.createLink(store.toURI(), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 25, 2));
            StubRefactoringHistoryWizard.addExclusionPatterns(list, folder.getFullPath());
            int index = 0;
            while (true) {
                block6: {
                    if (index < entries.length) break block6;
                    project.setRawClasspath(list.toArray(new IClasspathEntry[list.size()]), false, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                    break;
                }
                if (entries[index].equals(entry)) {
                    list.add(index, JavaCore.newSourceEntry((IPath)folder.getFullPath()));
                }
                ++index;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        monitor.done();
    }

    protected static URI getLocationURI(IClasspathEntry entry) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath path = entry.getPath();
        URI location = null;
        location = root.exists(path) ? root.getFile(path).getRawLocationURI() : URIUtil.toURI((IPath)path);
        return location;
    }

    protected StubRefactoringHistoryWizard(String caption, String title, String description) {
        super(caption, title, description);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected RefactoringStatus aboutToPerformHistory(IProgressMonitor monitor) {
        RefactoringStatus status = new RefactoringStatus();
        try {
            this.fJavaProject = null;
            this.fSourceFolder = null;
            this.fProcessedFragments.clear();
            monitor.beginTask(JarImportMessages.JarImportWizard_prepare_import, 500);
            IPackageFragmentRoot root = this.getPackageFragmentRoot();
            if (root != null) {
                status.merge(StubRefactoringHistoryWizard.checkPackageFragmentRoots(root, (IProgressMonitor)new SubProgressMonitor(monitor, 90, 2)));
                if (!status.hasFatalError()) {
                    IJavaProject project;
                    status.merge(super.aboutToPerformHistory((IProgressMonitor)new SubProgressMonitor(monitor, 10, 2)));
                    if (!status.hasFatalError() && (project = root.getJavaProject()) != null) {
                        IFolder folder = project.getProject().getFolder(SOURCE_FOLDER + String.valueOf(System.currentTimeMillis()));
                        try {
                            try {
                                this.fAutoBuild = CoreUtility.enableAutoBuild(false);
                                if (this.getRefactoringHistory() != null) {
                                    StubRefactoringHistoryWizard.configureClasspath(project, root, folder, (IProgressMonitor)new SubProgressMonitor(monitor, 300, 2));
                                }
                            }
                            catch (CoreException exception) {
                                status.merge(RefactoringStatus.createFatalErrorStatus((String)exception.getLocalizedMessage()));
                                try {
                                    project.setRawClasspath(project.readRawClasspath(), false, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                                }
                                catch (CoreException throwable) {
                                    JavaPlugin.log(throwable);
                                }
                            }
                            Object var8_10 = null;
                        }
                        catch (Throwable throwable) {
                            Object var8_9 = null;
                            if (status.hasFatalError()) throw throwable;
                            this.fJavaProject = project;
                            this.fSourceFolder = folder;
                            throw throwable;
                        }
                        if (!status.hasFatalError()) {
                            this.fJavaProject = project;
                            this.fSourceFolder = folder;
                        }
                    }
                }
            }
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return status;
    }

    protected abstract RefactoringStatus aboutToPerformRefactoring(Refactoring var1, RefactoringDescriptor var2);

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final RefactoringStatus aboutToPerformRefactoring(Refactoring refactoring, RefactoringDescriptor descriptor, IProgressMonitor monitor) {
        monitor.beginTask(JarImportMessages.JarImportWizard_prepare_import, 120);
        RefactoringStatus status = super.aboutToPerformRefactoring(refactoring, descriptor, (IProgressMonitor)new SubProgressMonitor(monitor, 20, 2));
        try {
            if (!status.hasFatalError()) {
                status.merge(this.createTypeStubs(refactoring, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2)));
                if (!status.hasFatalError()) {
                    status.merge(this.aboutToPerformRefactoring(refactoring, descriptor));
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
        return status;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus createTypeStubs(Refactoring refactoring, IProgressMonitor monitor) {
        RefactoringStatus status = new RefactoringStatus();
        try {
            block14: {
                monitor.beginTask(JarImportMessages.JarImportWizard_prepare_import, 240);
                IPackageFragmentRoot root = this.getPackageFragmentRoot();
                if (root != null && this.fSourceFolder != null) {
                    try {
                        URI uri;
                        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 40, 2);
                        IJavaElement[] elements = root.getChildren();
                        ArrayList<IJavaElement> list = new ArrayList<IJavaElement>(elements.length);
                        try {
                            subMonitor.beginTask(JarImportMessages.JarImportWizard_prepare_import, elements.length);
                            int index = 0;
                            while (index < elements.length) {
                                if (!this.fProcessedFragments.contains(elements[index]) && !elements[index].getElementName().equals(META_INF_FRAGMENT)) {
                                    list.add(elements[index]);
                                }
                                subMonitor.worked(1);
                                ++index;
                            }
                            Object var9_15 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_14 = null;
                            subMonitor.done();
                            throw throwable;
                        }
                        subMonitor.done();
                        if (list.isEmpty() || (uri = this.fSourceFolder.getRawLocationURI()) == null) break block14;
                        StubCreationOperation operation = new StubCreationOperation(uri, list, true);
                        try {
                            operation.run((IProgressMonitor)new SubProgressMonitor(monitor, 150, 2));
                            Object var10_13 = null;
                        }
                        catch (Throwable throwable) {
                            Object var10_12 = null;
                            this.fSourceFolder.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 50, 2));
                            throw throwable;
                        }
                        this.fSourceFolder.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 50, 2));
                    }
                    catch (CoreException exception) {
                        status.addFatalError(exception.getLocalizedMessage());
                    }
                }
            }
            Object var12_19 = null;
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return status;
    }

    protected boolean deconfigureClasspath(IClasspathEntry[] entries, IProgressMonitor monitor) throws CoreException {
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deconfigureClasspath(IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(JarImportMessages.JarImportWizard_cleanup_import, 200);
            if (this.fJavaProject != null) {
                IClasspathEntry[] entries = this.fJavaProject.readRawClasspath();
                boolean changed = this.deconfigureClasspath(entries, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                RefactoringHistory history = this.getRefactoringHistory();
                if (history != null) {
                    RefactoringCore.getUndoManager().flush();
                }
                if (history != null || changed) {
                    this.fJavaProject.setRawClasspath(entries, changed, (IProgressMonitor)new SubProgressMonitor(monitor, 60, 2));
                }
                this.fJavaProject = null;
            }
            if (this.fSourceFolder != null) {
                IFileStore store = EFS.getStore((URI)this.fSourceFolder.getRawLocationURI());
                if (store.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 10, 2)).exists()) {
                    store.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 10, 2));
                }
                this.fSourceFolder.delete(true, false, (IProgressMonitor)new SubProgressMonitor(monitor, 10, 2));
                this.fSourceFolder.clearHistory((IProgressMonitor)new SubProgressMonitor(monitor, 10, 2));
                this.fSourceFolder = null;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
    }

    protected abstract IPackageFragmentRoot getPackageFragmentRoot();

    protected abstract RefactoringHistory getRefactoringHistory();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected RefactoringStatus historyPerformed(IProgressMonitor monitor) {
        try {
            block11: {
                monitor.beginTask(JarImportMessages.JarImportWizard_cleanup_import, 100);
                status = super.historyPerformed((IProgressMonitor)new SubProgressMonitor(monitor, 10, 2));
                if (!status.hasFatalError()) {
                    try {
                        try {
                            this.deconfigureClasspath((IProgressMonitor)new SubProgressMonitor(monitor, 90, 2));
                        }
                        catch (CoreException exception) {
                            status.addError(exception.getLocalizedMessage());
                        }
                    }
                    catch (Throwable var5_4) {
                        var4_5 = null;
                        try {
                            CoreUtility.enableAutoBuild(this.fAutoBuild);
                            throw var5_4;
                        }
                        catch (CoreException exception) {
                            JavaPlugin.log(exception);
                        }
                        throw var5_4;
                    }
                    {
                        var4_6 = null;
                    }
                    ** try [egrp 3[TRYBLOCK] [3 : 74->85)] { 
lbl24:
                    // 1 sources

                    CoreUtility.enableAutoBuild(this.fAutoBuild);
                    break block11;
lbl27:
                    // 1 sources

                    catch (CoreException exception) {
                        JavaPlugin.log(exception);
                    }
                }
            }
            var9_9 = status;
            var7_10 = null;
        }
        catch (Throwable var8_12) {
            var7_11 = null;
            monitor.done();
            throw var8_12;
        }
        monitor.done();
        return var9_9;
    }

    public boolean performCancel() {
        this.fCancelled = true;
        return super.performCancel();
    }

    protected RefactoringStatus refactoringPerformed(Refactoring refactoring, IProgressMonitor monitor) {
        RefactoringStatus refactoringStatus;
        try {
            monitor.beginTask("", 120);
            RefactoringStatus status = super.refactoringPerformed(refactoring, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
            if (!status.hasFatalError() && this.fSourceFolder != null) {
                try {
                    this.fSourceFolder.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                }
                catch (CoreException exception) {
                    JavaPlugin.log(exception);
                }
            }
            refactoringStatus = status;
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return refactoringStatus;
    }

    protected boolean selectPreviewChange(Change change) {
        if (this.fSourceFolder != null) {
            IPath source = this.fSourceFolder.getFullPath();
            Object element = change.getModifiedElement();
            if (element instanceof IAdaptable) {
                IResource resource;
                IAdaptable adaptable = (IAdaptable)element;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = (IResource)adaptable.getAdapter((Class)clazz)) != null && source.isPrefixOf(resource.getFullPath())) {
                    return false;
                }
            }
        }
        return super.selectPreviewChange(change);
    }

    protected boolean selectStatusEntry(RefactoringStatusEntry entry) {
        if (this.fSourceFolder != null) {
            IResource resource;
            JavaStatusContext extended;
            ICompilationUnit unit;
            IPath source = this.fSourceFolder.getFullPath();
            RefactoringStatusContext context = entry.getContext();
            if (context instanceof JavaStatusContext && (unit = (extended = (JavaStatusContext)context).getCompilationUnit()) != null && (resource = unit.getResource()) != null && source.isPrefixOf(resource.getFullPath())) {
                return false;
            }
        }
        return super.selectStatusEntry(entry);
    }
}

