/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.corext.util.TypeInfoHistory;
import org.eclipse.jdt.internal.corext.util.TypeInfoUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.TypeProposalInfo;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class LazyJavaTypeCompletionProposal
extends LazyJavaCompletionProposal {
    protected static final char[] TYPE_TRIGGERS = new char[]{'.', '\t', '[', '(', ' '};
    protected static final char[] JDOC_TYPE_TRIGGERS = new char[]{'#', '}', ' ', '.'};
    protected final ICompilationUnit fCompilationUnit;
    private String fQualifiedName;
    private String fSimpleName;
    private ImportRewrite fImportRewrite;
    private ContextSensitiveImportRewriteContext fImportContext;

    public LazyJavaTypeCompletionProposal(CompletionProposal proposal, JavaContentAssistInvocationContext context) {
        super(proposal, context);
        this.fCompilationUnit = context.getCompilationUnit();
        this.fQualifiedName = null;
    }

    public final String getQualifiedTypeName() {
        if (this.fQualifiedName == null) {
            this.fQualifiedName = String.valueOf(Signature.toCharArray((char[])Signature.getTypeErasure((char[])this.fProposal.getSignature())));
        }
        return this.fQualifiedName;
    }

    protected final String getSimpleTypeName() {
        if (this.fSimpleName == null) {
            this.fSimpleName = Signature.getSimpleName((String)this.getQualifiedTypeName());
        }
        return this.fSimpleName;
    }

    protected String computeReplacementString() {
        if (this.isImportCompletion()) {
            return super.computeReplacementString();
        }
        if (this.fProposal.getKind() == 9 && this.fInvocationContext.getCoreContext().isInJavadocText()) {
            return this.getSimpleTypeName();
        }
        this.fImportRewrite = this.createImportRewrite();
        if (this.fImportRewrite != null) {
            return this.fImportRewrite.addImport(this.getQualifiedTypeName(), (ImportRewrite.ImportRewriteContext)this.fImportContext);
        }
        if (this.fCompilationUnit != null) {
            if (JavaModelUtil.isImplicitImport(Signature.getQualifier((String)this.getQualifiedTypeName()), this.fCompilationUnit)) {
                return this.getSimpleTypeName();
            }
            return this.getQualifiedTypeName();
        }
        return this.getQualifiedTypeName();
    }

    protected final boolean isImportCompletion() {
        char[] completion = this.fProposal.getCompletion();
        return completion.length > 0 && completion[completion.length - 1] == ';';
    }

    private ImportRewrite createImportRewrite() {
        if (this.fCompilationUnit != null && this.allowAddingImports()) {
            try {
                CompilationUnit cu = this.createASTRoot(this.fCompilationUnit);
                if (cu == null) {
                    ImportRewrite rewrite = StubUtility.createImportRewrite(this.fCompilationUnit, true);
                    this.fImportContext = null;
                    return rewrite;
                }
                ImportRewrite rewrite = StubUtility.createImportRewrite(cu, true);
                this.fImportContext = new ContextSensitiveImportRewriteContext(cu, this.fInvocationContext.getInvocationOffset(), rewrite);
                return rewrite;
            }
            catch (CoreException x) {
                JavaPlugin.log(x);
            }
        }
        return null;
    }

    private CompilationUnit createASTRoot(ICompilationUnit compilationUnit) {
        return JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)compilationUnit, ASTProvider.WAIT_NO, (IProgressMonitor)new NullProgressMonitor());
    }

    public void apply(IDocument document, char trigger, int offset) {
        try {
            boolean insertClosingParenthesis;
            boolean bl = insertClosingParenthesis = trigger == '(' && this.autocloseBrackets();
            if (insertClosingParenthesis) {
                this.updateReplacementWithParentheses();
                trigger = '\u0000';
            }
            super.apply(document, trigger, offset);
            if (this.fImportRewrite != null && this.fImportRewrite.hasRecordedChanges()) {
                int oldLen = document.getLength();
                this.fImportRewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor()).apply(document, 2);
                this.setReplacementOffset(this.getReplacementOffset() + document.getLength() - oldLen);
            }
            if (insertClosingParenthesis) {
                this.setUpLinkedMode(document, ')');
            }
            this.rememberSelection();
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
    }

    private void updateReplacementWithParentheses() {
        StringBuffer replacement = new StringBuffer(this.getReplacementString());
        LazyJavaCompletionProposal.FormatterPrefs prefs = this.getFormatterPrefs();
        if (prefs.beforeOpeningParen) {
            replacement.append(" ");
        }
        replacement.append("(");
        if (prefs.afterOpeningParen) {
            replacement.append(" ");
        }
        this.setCursorPosition(replacement.length());
        if (prefs.afterOpeningParen) {
            replacement.append(" ");
        }
        replacement.append(")");
        this.setReplacementString(replacement.toString());
    }

    protected final void rememberSelection() throws JavaModelException {
        TypeInfo info;
        IType lhs = this.fInvocationContext.getExpectedType();
        IType rhs = (IType)this.getJavaElement();
        if (lhs != null && rhs != null) {
            JavaPlugin.getDefault().getContentAssistHistory().remember(lhs, rhs);
        }
        if ((info = TypeInfoUtil.searchTypeInfo(this.fCompilationUnit.getJavaProject(), null, this.getQualifiedTypeName())) != null) {
            TypeInfoHistory.remember(info);
        }
    }

    protected boolean allowAddingImports() {
        if (this.isInJavadoc()) {
            if (this.fProposal.getKind() == 9 && this.fInvocationContext.getCoreContext().isInJavadocText()) {
                return false;
            }
            if (!this.isJavadocProcessingEnabled()) {
                return false;
            }
        }
        IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        return preferenceStore.getBoolean("content_assist_add_import");
    }

    private boolean isJavadocProcessingEnabled() {
        IJavaProject project = this.fCompilationUnit.getJavaProject();
        boolean processJavadoc = project == null ? "enabled".equals(JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.doc.comment.support")) : "enabled".equals(project.getOption("org.eclipse.jdt.core.compiler.doc.comment.support", true));
        return processJavadoc;
    }

    protected boolean isValidPrefix(String prefix) {
        return this.isPrefix(prefix, this.getSimpleTypeName()) || this.isPrefix(prefix, this.getQualifiedTypeName());
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.getSimpleTypeName();
    }

    protected char[] computeTriggerCharacters() {
        return this.isInJavadoc() ? JDOC_TYPE_TRIGGERS : TYPE_TRIGGERS;
    }

    protected ProposalInfo computeProposalInfo() {
        IJavaProject project;
        if (this.fCompilationUnit != null && (project = this.fCompilationUnit.getJavaProject()) != null) {
            return new TypeProposalInfo(project, this.fProposal);
        }
        return super.computeProposalInfo();
    }

    protected String computeSortString() {
        return String.valueOf(this.getSimpleTypeName()) + '\u0000' + this.getQualifiedTypeName();
    }

    protected int computeRelevance() {
        float rhsHistoryRank = this.fInvocationContext.getHistoryRelevance(this.getQualifiedTypeName());
        float typeHistoryRank = TypeInfoHistory.getDefault().getNormalizedPosition(this.getQualifiedTypeName());
        int recencyBoost = Math.round((rhsHistoryRank + typeHistoryRank) * 5.0f);
        int rhsBoost = rhsHistoryRank > 0.0f ? 50 : 0;
        int baseRelevance = super.computeRelevance();
        return baseRelevance + rhsBoost + recencyBoost;
    }
}

