/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.code.ExtractConstantRefactoring;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.ExtractConstantWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class ExtractConstantAction
extends SelectionDispatchAction {
    private static final String DIALOG_MESSAGE_TITLE = RefactoringMessages.ExtractConstantAction_extract_constant;
    private final CompilationUnitEditor fEditor;

    public ExtractConstantAction(CompilationUnitEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.setText(RefactoringMessages.ExtractConstantAction_label);
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.extract_constant_action");
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(this.fEditor != null && SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
    }

    public void selectionChanged(JavaTextSelection selection) {
        this.setEnabled(RefactoringAvailabilityTester.isExtractConstantAvailable(selection));
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        try {
            ExtractConstantRefactoring refactoring = new ExtractConstantRefactoring(SelectionConverter.getInputAsCompilationUnit(this.fEditor), selection.getOffset(), selection.getLength());
            if (refactoring == null) {
                return;
            }
            new RefactoringStarter().activate(refactoring, new ExtractConstantWizard(refactoring), this.getShell(), DIALOG_MESSAGE_TITLE, false);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), DIALOG_MESSAGE_TITLE, RefactoringMessages.NewTextRefactoringAction_exception);
        }
    }
}

