/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.logview;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.pde.internal.runtime.PDERuntimeMessages;
import org.eclipse.pde.internal.runtime.logview.LogSession;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class LogEntry
extends PlatformObject
implements IWorkbenchAdapter {
    private ArrayList children;
    private LogEntry parent;
    private String pluginId;
    private int severity;
    private int code;
    private String date;
    private String message;
    private String stack;
    private LogSession session;

    public LogEntry() {
    }

    public LogSession getSession() {
        return this.session;
    }

    void setSession(LogSession session) {
        this.session = session;
    }

    public LogEntry(IStatus status) {
        this.processStatus(status);
    }

    public int getSeverity() {
        return this.severity;
    }

    public boolean isOK() {
        return this.severity == 0;
    }

    public int getCode() {
        return this.code;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStack() {
        return this.stack;
    }

    public String getDate() {
        return this.date;
    }

    public String getSeverityText() {
        return this.getSeverityText(this.severity);
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public String toString() {
        return this.getSeverityText();
    }

    public Object[] getChildren(Object parent) {
        if (this.children == null) {
            return new Object[0];
        }
        return this.children.toArray();
    }

    public ImageDescriptor getImageDescriptor(Object arg0) {
        return null;
    }

    public String getLabel(Object obj) {
        return this.getSeverityText();
    }

    public Object getParent(Object obj) {
        return this.parent;
    }

    void setParent(LogEntry parent) {
        this.parent = parent;
    }

    private String getSeverityText(int severity) {
        switch (severity) {
            case 4: {
                return PDERuntimeMessages.LogView_severity_error;
            }
            case 2: {
                return PDERuntimeMessages.LogView_severity_warning;
            }
            case 1: {
                return PDERuntimeMessages.LogView_severity_info;
            }
            case 0: {
                return PDERuntimeMessages.LogView_severity_ok;
            }
        }
        return "?";
    }

    void processEntry(String line) {
        boolean byFrameWork;
        StringTokenizer stok = new StringTokenizer(line, " ");
        int tokenCount = stok.countTokens();
        boolean bl = byFrameWork = stok.countTokens() < 5;
        if (byFrameWork) {
            this.severity = 4;
            this.code = 0;
        }
        StringBuffer dateBuffer = new StringBuffer();
        int i = 0;
        while (i < tokenCount) {
            String token = stok.nextToken();
            switch (i) {
                case 0: {
                    break;
                }
                case 1: {
                    this.pluginId = token;
                    break;
                }
                case 2: {
                    if (byFrameWork) {
                        if (dateBuffer.length() > 0) {
                            dateBuffer.append(" ");
                        }
                        dateBuffer.append(token);
                        break;
                    }
                    this.severity = this.parseInteger(token);
                    break;
                }
                case 3: {
                    if (byFrameWork) {
                        if (dateBuffer.length() > 0) {
                            dateBuffer.append(" ");
                        }
                        dateBuffer.append(token);
                        break;
                    }
                    this.code = this.parseInteger(token);
                    break;
                }
                default: {
                    if (dateBuffer.length() > 0) {
                        dateBuffer.append(" ");
                    }
                    dateBuffer.append(token);
                }
            }
            ++i;
        }
        this.date = dateBuffer.toString();
    }

    int processSubEntry(String line) {
        StringTokenizer stok = new StringTokenizer(line, " ");
        int tokenCount = stok.countTokens();
        boolean byFrameWork = stok.countTokens() < 5;
        StringBuffer dateBuffer = new StringBuffer();
        int depth = 0;
        int i = 0;
        while (i < tokenCount) {
            String token = stok.nextToken();
            switch (i) {
                case 0: {
                    break;
                }
                case 1: {
                    depth = this.parseInteger(token);
                    break;
                }
                case 2: {
                    this.pluginId = token;
                    break;
                }
                case 3: {
                    if (byFrameWork) {
                        if (dateBuffer.length() > 0) {
                            dateBuffer.append(" ");
                        }
                        dateBuffer.append(token);
                        break;
                    }
                    this.severity = this.parseInteger(token);
                    break;
                }
                case 4: {
                    if (byFrameWork) {
                        if (dateBuffer.length() > 0) {
                            dateBuffer.append(" ");
                        }
                        dateBuffer.append(token);
                        break;
                    }
                    this.code = this.parseInteger(token);
                    break;
                }
                default: {
                    if (dateBuffer.length() > 0) {
                        dateBuffer.append(" ");
                    }
                    dateBuffer.append(token);
                }
            }
            ++i;
        }
        this.date = dateBuffer.toString();
        return depth;
    }

    private int parseInteger(String token) {
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    void setStack(String stack) {
        this.stack = stack;
    }

    void setMessage(String message) {
        this.message = message;
    }

    private void processStatus(IStatus status) {
        IStatus[] schildren;
        this.pluginId = status.getPlugin();
        this.severity = status.getSeverity();
        this.code = status.getCode();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SS");
        this.date = formatter.format(new Date());
        this.message = status.getMessage();
        Throwable throwable = status.getException();
        if (throwable != null) {
            StringWriter swriter = new StringWriter();
            PrintWriter pwriter = new PrintWriter(swriter);
            throwable.printStackTrace(pwriter);
            pwriter.flush();
            pwriter.close();
            this.stack = swriter.toString();
        }
        if ((schildren = status.getChildren()).length > 0) {
            this.children = new ArrayList();
            int i = 0;
            while (i < schildren.length) {
                LogEntry child = new LogEntry(schildren[i]);
                this.addChild(child);
                ++i;
            }
        }
    }

    void addChild(LogEntry child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
        child.setParent(this);
    }

    public void write(PrintWriter writer) {
        if (this.session != null) {
            writer.println(this.session.getSessionData());
        }
        writer.println(this.getSeverityText());
        if (this.date != null) {
            writer.println(this.getDate());
        }
        if (this.message != null) {
            writer.println(this.getMessage());
        }
        if (this.stack != null) {
            writer.println();
            writer.println(this.stack);
        }
    }
}

