/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.actions.TeamAction;
import org.eclipse.team.internal.ui.history.CompareFileRevisionEditorInput;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class CompareRevisionAction
extends TeamAction {
    public void run(IAction action) {
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IStructuredSelection structSel = CompareRevisionAction.this.getSelection();
                    if (structSel.size() != 2) {
                        return;
                    }
                    Object[] objArray = structSel.toArray();
                    IFileRevision file1 = (IFileRevision)objArray[0];
                    IFileRevision file2 = (IFileRevision)objArray[1];
                    FileRevisionTypedElement left = new FileRevisionTypedElement(file1);
                    FileRevisionTypedElement right = new FileRevisionTypedElement(file2);
                    CompareFileRevisionEditorInput input = new CompareFileRevisionEditorInput(left, right);
                    IWorkbenchPage page = CompareRevisionAction.this.getTargetPage();
                    IEditorPart editor = CompareRevisionAction.findReusableCompareEditor(CompareRevisionAction.this.getTargetPage());
                    if (editor != null) {
                        IEditorInput otherInput = editor.getEditorInput();
                        if (otherInput.equals(input)) {
                            page.activate((IWorkbenchPart)editor);
                        } else {
                            CompareUI.reuseCompareEditor((CompareEditorInput)input, (IReusableEditor)((IReusableEditor)editor));
                            page.activate((IWorkbenchPart)editor);
                        }
                    } else {
                        CompareUI.openCompareEditor((CompareEditorInput)input);
                    }
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        }, TeamUIMessages.ConfigureProjectAction_configureProject, 2);
    }

    protected boolean isEnabled() throws TeamException {
        int sizeofSelection = this.getSelection().size();
        return sizeofSelection == 2;
    }

    public static IEditorPart findReusableCompareEditor(IWorkbenchPage page) {
        IEditorReference[] editorRefs = page.getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            IEditorPart part = editorRefs[i].getEditor(false);
            if (part != null && part.getEditorInput() instanceof CompareFileRevisionEditorInput && part instanceof IReusableEditor && !part.isDirty()) {
                return part;
            }
            ++i;
        }
        return null;
    }
}

