/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSHistoryPage;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.team.internal.ui.history.DialogHistoryPageSite;
import org.eclipse.team.ui.ISaveableWorkbenchPart;
import org.eclipse.team.ui.SaveablePartDialog;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.history.HistoryPageSaveablePart;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryPageSite;
import org.eclipse.team.ui.history.IHistoryPageSource;
import org.eclipse.ui.part.Page;

public class CompareWithRevisionAction
extends WorkspaceAction {
    static /* synthetic */ Class class$0;

    protected ICVSRemoteFile getSelectedRemoteFile() {
        IResource[] resources = this.getSelectedResources();
        if (resources.length != 1) {
            return null;
        }
        if (!(resources[0] instanceof IFile)) {
            return null;
        }
        IFile file = (IFile)resources[0];
        try {
            return (ICVSRemoteFile)CVSWorkspaceRoot.getRemoteResourceFor((IResource)file);
        }
        catch (TeamException e) {
            this.handle((Exception)((Object)e), null, null);
            return null;
        }
    }

    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        final ICVSRemoteFile[] file = new ICVSRemoteFile[1];
        final ILogEntry[][] entries = new ILogEntry[1][];
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                file[0] = CompareWithRevisionAction.this.getSelectedRemoteFile();
            }
        }, false, 2);
        if (file[0] == null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)CVSUIMessages.CompareWithRevisionAction_noRevisions, (String)CVSUIMessages.CompareWithRevisionAction_noRevisionsLong);
            return;
        }
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    monitor.beginTask(CVSUIMessages.CompareWithRevisionAction_fetching, 100);
                    entries[0] = file[0].getLogEntries(Policy.subMonitorFor(monitor, 100));
                    monitor.done();
                }
                catch (TeamException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }, true, 1);
        if (entries[0] == null) {
            return;
        }
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                IFile tempFile = (IFile)CompareWithRevisionAction.this.getSelectedResources()[0];
                IFileHistoryProvider fileHistoryProvider = RepositoryProvider.getProvider((IProject)tempFile.getProject()).getFileHistoryProvider();
                IAdapterManager iAdapterManager = Platform.getAdapterManager();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.team.ui.history.IHistoryPageSource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Object tempPageSource = iAdapterManager.getAdapter((Object)fileHistoryProvider, (Class)clazz);
                if (CVSUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_show_compare_revision_in_dialog")) {
                    HistoryPageSaveablePart input = null;
                    if (tempPageSource instanceof IHistoryPageSource) {
                        IHistoryPageSource pageSource = (IHistoryPageSource)tempPageSource;
                        Page histPage = pageSource.createPage((Object)tempFile);
                        DialogHistoryPageSite dialogHistorySite = new DialogHistoryPageSite(CompareWithRevisionAction.this.getTargetPart().getSite(), true);
                        ((IHistoryPage)histPage).setSite((IHistoryPageSite)dialogHistorySite);
                        ((IHistoryPage)histPage).showHistory((Object)tempFile, true);
                        CompareConfiguration cc = new CompareConfiguration();
                        cc.setLeftEditable(false);
                        cc.setRightEditable(false);
                        input = new HistoryPageSaveablePart(CompareWithRevisionAction.this.getShell(), cc, (IHistoryPage)histPage);
                    }
                    SaveablePartDialog cd = CompareWithRevisionAction.this.createCompareDialog(CompareWithRevisionAction.this.getShell(), input);
                    cd.setBlockOnOpen(true);
                    cd.open();
                } else {
                    IHistoryPage page = TeamUI.getHistoryView().showHistoryFor((Object)((IFile)CompareWithRevisionAction.this.getSelectedResources()[0]));
                    if (page instanceof CVSHistoryPage) {
                        CVSHistoryPage cvsHistoryPage = (CVSHistoryPage)page;
                        cvsHistoryPage.setClickAction(0);
                    }
                }
            }
        }, false, 2);
    }

    protected SaveablePartDialog createCompareDialog(Shell shell, HistoryPageSaveablePart input) {
        return new SaveablePartDialog(shell, (ISaveableWorkbenchPart)input);
    }

    protected String getActionTitle() {
        return CVSUIMessages.CompareWithRevisionAction_4;
    }

    protected String getErrorTitle() {
        return CVSUIMessages.CompareWithRevisionAction_compare;
    }

    protected boolean isEnabledForCVSResource(ICVSResource cvsResource) throws CVSException {
        return !cvsResource.isFolder() && super.isEnabledForCVSResource(cvsResource);
    }

    protected boolean isEnabledForMultipleResources() {
        return false;
    }

    protected boolean isEnabledForAddedResources() {
        return false;
    }
}

