/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.IFileContentManager;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.provider.SynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberResourceMappingContext;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.operations.AddOperation;
import org.eclipse.team.internal.ccvs.ui.operations.CVSOperation;
import org.eclipse.team.internal.ccvs.ui.operations.CommitOperation;
import org.eclipse.team.internal.ccvs.ui.operations.RepositoryProviderOperation;
import org.eclipse.team.internal.ccvs.ui.wizards.CommitWizardCommitPage;
import org.eclipse.team.internal.ccvs.ui.wizards.CommitWizardFileTypePage;
import org.eclipse.team.internal.ccvs.ui.wizards.CommitWizardParticipant;
import org.eclipse.team.internal.ccvs.ui.wizards.ResizableWizard;
import org.eclipse.team.internal.core.subscribers.SubscriberSyncInfoCollector;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.ResourceScope;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class CommitWizard
extends ResizableWizard {
    private final IResource[] fResources;
    private final SyncInfoSet fOutOfSyncInfos;
    private final SyncInfoSet fUnaddedInfos;
    private final CommitWizardParticipant fParticipant;
    private CommitWizardFileTypePage fFileTypePage;
    private CommitWizardCommitPage fCommitPage;
    private IJobChangeListener jobListener;
    private IWorkbenchPart part;

    public CommitWizard(SyncInfoSet infos) throws CVSException {
        this(infos.getResources());
    }

    public CommitWizard(IResource[] resources) throws CVSException {
        super(CVSUIMessages.CommitWizard_3, CVSUIPlugin.getPlugin().getDialogSettings());
        this.setWindowTitle(CVSUIMessages.CommitWizard_2);
        this.setDefaultPageImageDescriptor(CVSUIPlugin.getPlugin().getImageDescriptor("wizban/newlocation_wizban.gif"));
        this.fResources = resources;
        this.fParticipant = new CommitWizardParticipant((ISynchronizeScope)new ResourceScope(this.fResources), this);
        SyncInfoSet infos = this.getAllOutOfSync();
        this.fOutOfSyncInfos = new SyncInfoSet(infos.getNodes((FastSyncInfoFilter)new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{4, 12})));
        this.fUnaddedInfos = CommitWizard.getUnaddedInfos(this.fOutOfSyncInfos);
    }

    public CommitWizard(SyncInfoSet infos, IJobChangeListener jobListener) throws CVSException {
        this(infos);
        this.jobListener = jobListener;
    }

    public CommitWizard(Shell shell, IWorkbenchPart part, ISynchronizationScope scope) throws CVSException {
        this(scope.getRoots());
        this.part = part;
    }

    private SyncInfoSet getAllOutOfSync() throws CVSException {
        final SubscriberSyncInfoCollector syncInfoCollector = this.fParticipant.getSubscriberSyncInfoCollector();
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(CVSUIMessages.CommitWizard_4, -1);
                    syncInfoCollector.waitForCollector(monitor);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            throw CVSException.wrapException((Exception)e);
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
        return this.fParticipant.getSyncInfoSet();
    }

    public boolean hasOutgoingChanges() {
        return this.fOutOfSyncInfos.size() > 0;
    }

    public CommitWizardFileTypePage getFileTypePage() {
        return this.fFileTypePage;
    }

    public CommitWizardCommitPage getCommitPage() {
        return this.fCommitPage;
    }

    public CommitWizardParticipant getParticipant() {
        return this.fParticipant;
    }

    public boolean canFinish() {
        IWizardPage current = this.getContainer().getCurrentPage();
        if (current == this.fFileTypePage && this.fCommitPage != null) {
            return false;
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        SyncInfoSet unadded;
        String comment = this.fCommitPage.getComment(this.getShell());
        if (comment == null) {
            return false;
        }
        SyncInfoSet infos = this.fCommitPage.getInfosToCommit();
        if (infos.size() == 0) {
            return true;
        }
        try {
            unadded = CommitWizard.getUnaddedInfos(infos);
        }
        catch (CVSException cVSException) {
            return false;
        }
        AddAndCommitOperation operation = new AddAndCommitOperation(this.getPart(), infos.getResources(), comment);
        if (this.jobListener != null) {
            operation.setJobChangeListener(this.jobListener);
        }
        if (this.fFileTypePage != null) {
            HashMap extensionsToSave = new HashMap();
            HashMap extensionsNotToSave = new HashMap();
            this.fFileTypePage.getModesForExtensions(extensionsToSave, extensionsNotToSave);
            CommitWizardFileTypePage.saveExtensionMappings(extensionsToSave);
            operation.setModesForExtensionsForOneTime(extensionsNotToSave);
            HashMap namesToSave = new HashMap();
            HashMap namesNotToSave = new HashMap();
            this.fFileTypePage.getModesForNames(namesToSave, namesNotToSave);
            CommitWizardFileTypePage.saveNameMappings(namesToSave);
            operation.setModesForNamesForOneTime(namesNotToSave);
        }
        if (unadded.size() > 0) {
            operation.setNewResources(unadded.getResources());
        }
        try {
            operation.run();
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return super.performFinish();
    }

    public void addPages() {
        HashSet names = new HashSet();
        HashSet extensions = new HashSet();
        CommitWizard.getUnknownNamesAndExtension(this.fUnaddedInfos, names, extensions);
        if (names.size() + extensions.size() > 0) {
            this.fFileTypePage = new CommitWizardFileTypePage(extensions, names);
            this.addPage((IWizardPage)this.fFileTypePage);
        }
        this.fCommitPage = new CommitWizardCommitPage(this.fResources, this);
        this.addPage((IWizardPage)this.fCommitPage);
        super.addPages();
    }

    public void dispose() {
        this.fParticipant.dispose();
        super.dispose();
    }

    public static void run(Shell shell, IResource[] resources) throws CVSException {
        try {
            CommitWizard.run(shell, new CommitWizard(resources));
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    public static void run(Shell shell, SyncInfoSet infos, IJobChangeListener jobListener) throws CVSException {
        try {
            CommitWizard.run(shell, new CommitWizard(infos, jobListener));
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    public static void run(IWorkbenchPart part, Shell shell, ResourceMapping[] mappings) throws CVSException {
        try {
            ISynchronizationScope scope = CommitWizard.buildScope(part, mappings);
            CommitWizard commitWizard = new CommitWizard(shell, part, scope);
            CommitWizard.run(shell, commitWizard);
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InvocationTargetException e) {
            throw CVSException.wrapException((Exception)e);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static ISynchronizationScope buildScope(final IWorkbenchPart part, final ResourceMapping[] mappings) throws InvocationTargetException, InterruptedException {
        final ISynchronizationScope[] scope = new ISynchronizationScope[1];
        PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    scope[0] = CommitWizard.buildScope(part, mappings, monitor);
                }
                catch (CVSException e) {
                    throw new InvocationTargetException(e);
                }
            }
        });
        return scope[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ISynchronizationScope buildScope(IWorkbenchPart part, ResourceMapping[] mappings, IProgressMonitor monitor) throws InterruptedException, CVSException {
        ISynchronizationScope iSynchronizationScope;
        SynchronizationScopeManager manager = new SynchronizationScopeManager(mappings, (ResourceMappingContext)SubscriberResourceMappingContext.createContext((Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber()), true);
        try {
            try {
                manager.initialize(monitor);
                iSynchronizationScope = manager.getScope();
                Object var5_5 = null;
                if (manager == null) return iSynchronizationScope;
            }
            catch (CoreException e) {
                throw CVSException.wrapException((CoreException)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (manager == null) throw throwable;
            manager.dispose();
            throw throwable;
        }
        manager.dispose();
        return iSynchronizationScope;
    }

    private IWorkbenchPart getPart() {
        if (this.part != null) {
            return this.part;
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().getActivePart();
    }

    private static void run(Shell shell, CommitWizard wizard) {
        if (!wizard.hasOutgoingChanges()) {
            MessageDialog.openInformation((Shell)shell, (String)CVSUIMessages.CommitWizard_6, (String)CVSUIMessages.CommitWizard_7);
        } else {
            CommitWizard.open(shell, wizard);
        }
    }

    private static void getUnknownNamesAndExtension(SyncInfoSet infos, Collection names, Collection extensions) {
        IFileContentManager manager = Team.getFileContentManager();
        Iterator iter = infos.iterator();
        while (iter.hasNext()) {
            SyncInfo info = (SyncInfo)iter.next();
            IResource local = info.getLocal();
            if (!(local instanceof IFile) || manager.getType((IStorage)((IFile)local)) != 0) continue;
            String extension = local.getFileExtension();
            if (extension != null && !manager.isKnownExtension(extension)) {
                extensions.add(extension);
            }
            String name = local.getName();
            if (extension != null || name == null || manager.isKnownFilename(name)) continue;
            names.add(name);
        }
    }

    private static SyncInfoSet getUnaddedInfos(SyncInfoSet infos) throws CVSException {
        SyncInfoSet unadded = new SyncInfoSet();
        Iterator iter = infos.iterator();
        while (iter.hasNext()) {
            SyncInfo info = (SyncInfo)iter.next();
            IResource file = info.getLocal();
            if (CommitWizard.isAdded(file)) continue;
            unadded.add(info);
        }
        return unadded;
    }

    private static boolean isAdded(IResource resource) throws CVSException {
        ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
        if (cvsResource.isFolder()) {
            return ((ICVSFolder)cvsResource).isCVSFolder();
        }
        return cvsResource.isManaged();
    }

    private static class AddAndCommitOperation
    extends CVSOperation {
        private final IResource[] fAllResources;
        private final String fComment;
        private Map fModesForExtensionsForOneTime;
        private Map fModesForNamesForOneTime;
        private IResource[] fNewResources = new IResource[0];
        private IJobChangeListener jobListener;

        AddAndCommitOperation(IWorkbenchPart part, IResource[] allResources, String comment) {
            super(part);
            this.fModesForExtensionsForOneTime = Collections.EMPTY_MAP;
            this.fModesForNamesForOneTime = Collections.EMPTY_MAP;
            this.fAllResources = allResources;
            this.fComment = comment;
        }

        public void setModesForExtensionsForOneTime(Map modes) {
            this.fModesForExtensionsForOneTime = modes;
        }

        public void setModesForNamesForOneTime(Map modes) {
            this.fModesForNamesForOneTime = modes;
        }

        public void setNewResources(IResource[] newResources) {
            this.fNewResources = newResources;
        }

        protected void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
            try {
                AddOperation op = new AddOperation(this.getPart(), RepositoryProviderOperation.asResourceMappers(this.fNewResources));
                op.addModesForExtensions(this.fModesForExtensionsForOneTime);
                op.addModesForNames(this.fModesForNamesForOneTime);
                op.run(monitor);
                new CommitOperation(this.getPart(), RepositoryProviderOperation.asResourceMappers(this.fAllResources), new Command.LocalOption[0], this.fComment).run(monitor);
            }
            catch (InvocationTargetException e) {
                throw CVSException.wrapException((Exception)e);
            }
        }

        protected String getJobName() {
            return CVSUIMessages.CommitWizard_0;
        }

        protected String getTaskName() {
            return CVSUIMessages.CommitWizard_1;
        }

        protected void setJobChangeListener(IJobChangeListener jobListener) {
            this.jobListener = jobListener;
        }

        public void done(IJobChangeEvent event) {
            super.done(event);
            if (this.jobListener != null) {
                this.jobListener.done(event);
            }
        }

        public void scheduled(IJobChangeEvent event) {
            super.scheduled(event);
            if (this.jobListener != null) {
                this.jobListener.scheduled(event);
            }
        }
    }
}

