/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.internal.core.refactoring.TextChanges;
import org.eclipse.ltk.internal.core.refactoring.UndoDocumentChange;
import org.eclipse.text.edits.UndoEdit;

public class DocumentChange
extends TextChange {
    private IDocument fDocument;
    private int fLength;

    public DocumentChange(String name, IDocument document) {
        super(name);
        Assert.isNotNull((Object)document);
        this.fDocument = document;
    }

    public Object getModifiedElement() {
        return this.fDocument;
    }

    public void initializeValidationData(IProgressMonitor pm) {
        this.fLength = this.fDocument.getLength();
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        RefactoringStatus result = TextChanges.isValid(this.fDocument, this.fLength);
        pm.worked(1);
        return result;
    }

    protected IDocument acquireDocument(IProgressMonitor pm) throws CoreException {
        return this.fDocument;
    }

    protected void commit(IDocument document, IProgressMonitor pm) throws CoreException {
    }

    protected void releaseDocument(IDocument document, IProgressMonitor pm) throws CoreException {
    }

    protected Change createUndoChange(UndoEdit edit) {
        return new UndoDocumentChange(this.getName(), this.fDocument, edit);
    }
}

