/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.IInitializableRefactoringComponent;
import org.eclipse.ltk.core.refactoring.PerformRefactoringOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryService;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringInstanceFactory;

public class PerformRefactoringHistoryOperation
implements IWorkspaceRunnable {
    private RefactoringStatus fExecutionStatus = new RefactoringStatus();
    private final RefactoringHistory fRefactoringHistory;

    public PerformRefactoringHistoryOperation(RefactoringHistory history) {
        Assert.isNotNull((Object)((Object)history));
        this.fRefactoringHistory = history;
    }

    protected RefactoringStatus aboutToPerformRefactoring(Refactoring refactoring, RefactoringDescriptor descriptor, IProgressMonitor monitor) {
        Assert.isNotNull((Object)((Object)refactoring));
        Assert.isNotNull((Object)descriptor);
        RefactoringStatus status = new RefactoringStatus();
        if (refactoring instanceof IInitializableRefactoringComponent) {
            IInitializableRefactoringComponent component = (IInitializableRefactoringComponent)((Object)refactoring);
            RefactoringArguments arguments = RefactoringInstanceFactory.getInstance().createArguments(descriptor);
            if (arguments != null) {
                status.merge(component.initialize(arguments));
            } else {
                status.addFatalError(Messages.format(RefactoringCoreMessages.PerformRefactoringHistoryOperation_init_error, new String[]{descriptor.getDescription()}));
            }
        } else {
            status.addFatalError(Messages.format(RefactoringCoreMessages.PerformRefactoringHistoryOperation_init_error, new String[]{descriptor.getDescription()}));
        }
        return status;
    }

    public RefactoringStatus getExecutionStatus() {
        return this.fExecutionStatus;
    }

    protected void refactoringPerformed(Refactoring refactoring, IProgressMonitor monitor) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws CoreException {
        this.fExecutionStatus = new RefactoringStatus();
        RefactoringDescriptorProxy[] proxies = this.fRefactoringHistory.getDescriptors();
        monitor.beginTask(RefactoringCoreMessages.PerformRefactoringHistoryOperation_perform_refactorings, 160 * proxies.length);
        RefactoringInstanceFactory factory = RefactoringInstanceFactory.getInstance();
        IRefactoringHistoryService service = RefactoringCore.getRefactoringHistoryService();
        try {
            service.connect();
            int index = 0;
            while (index < proxies.length && !this.fExecutionStatus.hasFatalError()) {
                block9: {
                    Object var10_10;
                    Refactoring refactoring;
                    RefactoringDescriptor descriptor = proxies[index].requestDescriptor((IProgressMonitor)new SubProgressMonitor(monitor, 10, 2));
                    if (descriptor == null || descriptor.isUnknown() || (refactoring = factory.createRefactoring(descriptor)) == null) break block9;
                    PerformRefactoringOperation operation = new PerformRefactoringOperation(refactoring, 6);
                    try {
                        RefactoringStatus status = this.aboutToPerformRefactoring(refactoring, descriptor, (IProgressMonitor)new SubProgressMonitor(monitor, 50, 2));
                        if (!status.hasFatalError()) {
                            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)operation, (IProgressMonitor)new SubProgressMonitor(monitor, 90, 2));
                        } else {
                            this.fExecutionStatus.merge(status);
                        }
                    }
                    catch (Throwable throwable) {
                        var10_10 = null;
                        this.refactoringPerformed(refactoring, (IProgressMonitor)new SubProgressMonitor(monitor, 10, 2));
                        throw throwable;
                    }
                    {
                        var10_10 = null;
                        this.refactoringPerformed(refactoring, (IProgressMonitor)new SubProgressMonitor(monitor, 10, 2));
                        this.fExecutionStatus.merge(operation.getConditionStatus());
                        if (this.fExecutionStatus.hasFatalError()) break block9;
                        this.fExecutionStatus.merge(operation.getValidationStatus());
                    }
                }
                ++index;
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            service.disconnect();
            monitor.done();
            throw throwable;
        }
        {
            Object var12_14 = null;
            service.disconnect();
        }
        monitor.done();
    }
}

