/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.history;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;

public final class RefactoringHistoryImplementation
extends RefactoringHistory {
    private final RefactoringDescriptorProxy[] fDescriptorProxies;
    private boolean fSorted = false;

    public RefactoringHistoryImplementation(RefactoringDescriptorProxy[] proxies) {
        Assert.isNotNull((Object)proxies);
        this.fDescriptorProxies = new RefactoringDescriptorProxy[proxies.length];
        System.arraycopy(proxies, 0, this.fDescriptorProxies, 0, proxies.length);
    }

    RefactoringDescriptorProxy[] getDescriptorProxies() {
        return this.fDescriptorProxies;
    }

    public RefactoringDescriptorProxy[] getDescriptors() {
        if (!this.fSorted && this.fDescriptorProxies.length > 1) {
            Arrays.sort(this.fDescriptorProxies, new Comparator(){

                public final int compare(Object first, Object second) {
                    RefactoringDescriptorProxy predecessor = (RefactoringDescriptorProxy)first;
                    RefactoringDescriptorProxy successor = (RefactoringDescriptorProxy)second;
                    return (int)(successor.getTimeStamp() - predecessor.getTimeStamp());
                }
            });
        }
        this.fSorted = true;
        RefactoringDescriptorProxy[] proxies = new RefactoringDescriptorProxy[this.fDescriptorProxies.length];
        System.arraycopy(this.fDescriptorProxies, 0, proxies, 0, this.fDescriptorProxies.length);
        return proxies;
    }

    public boolean isEmpty() {
        return this.fDescriptorProxies.length == 0;
    }

    public RefactoringHistory removeAll(RefactoringHistory history) {
        LinkedHashSet<RefactoringDescriptorProxy> existing = new LinkedHashSet<RefactoringDescriptorProxy>(Arrays.asList(this.fDescriptorProxies));
        HashSet<RefactoringDescriptorProxy> other = new HashSet<RefactoringDescriptorProxy>(Arrays.asList(history.getDescriptors()));
        existing.removeAll(other);
        RefactoringDescriptorProxy[] proxies = new RefactoringDescriptorProxy[existing.size()];
        existing.toArray(proxies);
        return new RefactoringHistoryImplementation(proxies);
    }
}

