/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.Date;
import java.util.ResourceBundle;
import org.eclipse.core.internal.runtime.Activator;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.localization.BundleLocalization;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class CommonOSGiUtils {
    private ServiceTracker logTracker = null;
    private ServiceTracker bundleTracker = null;
    private ServiceTracker instanceLocationTracker = null;
    private ServiceTracker localizationTracker = null;
    public static final String PROP_INSTANCE_AREA = "osgi.instance.area";
    private static final CommonOSGiUtils singleton = new CommonOSGiUtils();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static CommonOSGiUtils getDefault() {
        return singleton;
    }

    private CommonOSGiUtils() {
        this.initServices();
    }

    public static void message(String message) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(new Date(System.currentTimeMillis()));
        buffer.append(" - [");
        buffer.append(Thread.currentThread().getName());
        buffer.append("] ");
        buffer.append(message);
        System.out.println(buffer.toString());
    }

    private void initServices() {
        BundleContext context = Activator.getContext();
        if (context == null) {
            CommonOSGiUtils.message("CommonOSGiUtils called before plugin started");
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.log.FrameworkLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logTracker = new ServiceTracker(context, clazz.getName(), null);
        this.logTracker.open();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.bundleTracker = new ServiceTracker(context, clazz2.getName(), null);
        this.bundleTracker.open();
        Filter filter = null;
        try {
            filter = context.createFilter("(&(objectClass=org.eclipse.osgi.service.datalocation.Location)(type=osgi.instance.area))");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.instanceLocationTracker = new ServiceTracker(context, filter, null);
        this.instanceLocationTracker.open();
    }

    void closeServices() {
        if (this.localizationTracker != null) {
            this.localizationTracker.close();
            this.localizationTracker = null;
        }
        if (this.logTracker != null) {
            this.logTracker.close();
            this.logTracker = null;
        }
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
            this.bundleTracker = null;
        }
        if (this.instanceLocationTracker != null) {
            this.instanceLocationTracker.close();
            this.instanceLocationTracker = null;
        }
    }

    public FrameworkLog getFrameworkLog() {
        if (this.logTracker != null) {
            return (FrameworkLog)this.logTracker.getService();
        }
        CommonOSGiUtils.message("Log tracker is not set");
        return null;
    }

    public Bundle[] getFragments(Bundle bundle) {
        if (this.bundleTracker == null) {
            CommonOSGiUtils.message("Bundle tracker is not set");
            return null;
        }
        PackageAdmin packageAdmin = (PackageAdmin)this.bundleTracker.getService();
        if (packageAdmin == null) {
            return null;
        }
        return packageAdmin.getFragments(bundle);
    }

    public Location getInstanceLocation() {
        if (this.instanceLocationTracker != null) {
            return (Location)this.instanceLocationTracker.getService();
        }
        return null;
    }

    public ResourceBundle getLocalization(Bundle bundle, String locale) {
        BundleLocalization location;
        if (this.localizationTracker == null) {
            BundleContext context = Activator.getContext();
            if (context == null) {
                CommonOSGiUtils.message("ResourceTranslator called before plugin is started");
                return null;
            }
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.osgi.service.localization.BundleLocalization");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.localizationTracker = new ServiceTracker(context, clazz.getName(), null);
            this.localizationTracker.open();
        }
        if ((location = (BundleLocalization)this.localizationTracker.getService()) != null) {
            return location.getLocalization(bundle, locale);
        }
        return null;
    }

    public String getBundleId(Object object) {
        if (object == null) {
            return null;
        }
        if (this.bundleTracker == null) {
            CommonOSGiUtils.message("Bundle tracker is not set");
            return null;
        }
        PackageAdmin packageAdmin = (PackageAdmin)this.bundleTracker.getService();
        if (packageAdmin == null) {
            return null;
        }
        Bundle source = packageAdmin.getBundle(object.getClass());
        if (source != null && source.getSymbolicName() != null) {
            return source.getSymbolicName();
        }
        return null;
    }
}

