/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.SerializationException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheetCommand;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetManager;

public class CommandRunner {
    static /* synthetic */ Class class$0;

    private ICommandService getCommandService() {
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb != null) {
            Object serviceObject;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.commands.ICommandService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((serviceObject = wb.getAdapter((Class)clazz)) != null) {
                ICommandService service = (ICommandService)serviceObject;
                return service;
            }
        }
        return null;
    }

    public IStatus executeCommand(CheatSheetCommand command, ICheatSheetManager csm) {
        Object result;
        ICommandService service = this.getCommandService();
        if (service == null) {
            return new Status(4, "org.eclipse.ui.cheatsheets", 0, Messages.ERROR_COMMAND_SERVICE_UNAVAILABLE, null);
        }
        String rawSerialization = command.getSerialization();
        try {
            String substitutedSerialization = CheatSheetManager.performVariableSubstitution(rawSerialization, csm);
            ParameterizedCommand selectedCommand = service.deserialize(substitutedSerialization);
            result = selectedCommand.executeWithChecks(null, null);
        }
        catch (NotDefinedException e) {
            String message = NLS.bind((String)Messages.ERROR_COMMAND_ID_NOT_FOUND, (Object[])new Object[]{rawSerialization});
            return new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
        }
        catch (SerializationException e) {
            return this.commandFailureStatus((Exception)((Object)e));
        }
        catch (ExecutionException e) {
            return this.commandFailureStatus((Exception)((Object)e));
        }
        catch (NotEnabledException e) {
            return this.commandFailureStatus((Exception)((Object)e));
        }
        catch (NotHandledException e) {
            return this.commandFailureStatus((Exception)((Object)e));
        }
        catch (Exception e) {
            return this.commandFailureStatus(e);
        }
        if (command.getReturns() != null) {
            String returnValue = result == null ? "" : result.toString();
            csm.setData(command.getReturns(), returnValue);
        }
        return Status.OK_STATUS;
    }

    private IStatus commandFailureStatus(Exception exception) {
        return new Status(4, "org.eclipse.ui.cheatsheets", 0, Messages.ERROR_COMMAND_ERROR_STATUS, (Throwable)exception);
    }
}

