/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.model;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.cheatsheets.ICompositeCheatSheetTask;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.composite.model.CheatSheetTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetModel;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheetSaveHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CompositeCheatSheetSaveHelper
extends CheatSheetSaveHelper {
    public IStatus loadCompositeState(CompositeCheatSheetModel model, IPath savePath) {
        this.savePath = savePath != null ? savePath : Platform.getPluginStateLocation((Plugin)CheatSheetPlugin.getPlugin());
        Path filePath = this.getStateFile(model.getId());
        Document doc = null;
        URL readURL = null;
        try {
            readURL = filePath.toFile().toURL();
            doc = this.readXMLFile(readURL);
        }
        catch (MalformedURLException mue) {
            String message = NLS.bind((String)Messages.ERROR_CREATING_STATEFILE_URL, (Object[])new Object[]{readURL});
            Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)mue);
            return status;
        }
        if (doc == null) {
            return Status.OK_STATUS;
        }
        Element rootnode = doc.getDocumentElement();
        NamedNodeMap rootatts = rootnode.getAttributes();
        if (this.isReference(doc)) {
            String path = this.getAttributeWithName(rootatts, "path");
            return this.loadCompositeState(model, (IPath)new Path(path));
        }
        if (rootnode.getNodeName() != "compositeCheatSheetState") {
            String message = NLS.bind((String)Messages.ERROR_PARSING_ROOT_NODE_TYPE, (Object[])new Object[]{"compositeCheatSheetState"});
            Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, null);
            return status;
        }
        NodeList children = rootnode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            String nodeName = children.item(i).getNodeName();
            if ("task".equals(nodeName)) {
                return this.loadTaskState((CheatSheetTask)model.getRootTask(), children.item(i));
            }
            ++i;
        }
        return new Status(4, "org.eclipse.ui.cheatsheets", 0, Messages.ERROR_PARSING_NO_ROOT, null);
    }

    private IStatus loadTaskState(CheatSheetTask task, Node taskNode) {
        NamedNodeMap attributes = taskNode.getAttributes();
        Node state = attributes.getNamedItem("state");
        Node percentage = attributes.getNamedItem("percentageComplete");
        if (state != null) {
            task.setState(Integer.parseInt(state.getNodeValue()));
        }
        if (percentage != null) {
            task.setPercentageComplete(Integer.parseInt(percentage.getNodeValue()));
        }
        NodeList children = taskNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (i < task.getSubtasks().length) {
                this.loadTaskState((CheatSheetTask)task.getSubtasks()[i], children.item(i));
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    public IStatus saveCompositeState(CompositeCheatSheetModel model) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = documentBuilder.newDocument();
            Element root = doc.createElement("compositeCheatSheetState");
            Path filePath = this.getStateFile(model.getId());
            root.setAttribute("id", model.getId());
            doc.appendChild(root);
            this.saveTaskState(doc, root, (CheatSheetTask)model.getRootTask());
            StreamResult streamResult = new StreamResult(filePath.toFile());
            DOMSource domSource = new DOMSource(doc);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.transform(domSource, streamResult);
        }
        catch (Exception e) {
            String message = NLS.bind((String)Messages.ERROR_SAVING_STATEFILE_URL, (Object[])new Object[]{model.getId()});
            Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
            return status;
        }
        return Status.OK_STATUS;
    }

    private void saveTaskState(Document doc, Element parent, CheatSheetTask task) {
        Element taskElement = doc.createElement("task");
        taskElement.setAttribute("state", Integer.toString(task.getState()));
        taskElement.setAttribute("percentageComplete", Integer.toString(task.getPercentageComplete()));
        if (task.getId() != null) {
            taskElement.setAttribute("id", task.getId());
        }
        ICompositeCheatSheetTask[] subtasks = task.getSubtasks();
        parent.appendChild(taskElement);
        int i = 0;
        while (i < subtasks.length) {
            this.saveTaskState(doc, taskElement, (CheatSheetTask)subtasks[i]);
            ++i;
        }
    }
}

