/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.parser;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.composite.model.CheatSheetTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetModel;
import org.eclipse.ui.internal.cheatsheets.composite.parser.IStatusContainer;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheetParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CompositeCheatSheetParser
implements IStatusContainer {
    private DocumentBuilder documentBuilder;
    private IStatus status;
    private int nextTaskId = 0;
    private final int PARSER_ERROR = 1001;

    public IStatus getStatus() {
        return this.status;
    }

    public DocumentBuilder getDocumentBuilder() {
        if (this.documentBuilder == null) {
            try {
                this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (Exception e) {
                this.addStatus(4, Messages.ERROR_CREATING_DOCUMENT_BUILDER, e);
            }
        }
        return this.documentBuilder;
    }

    public void addStatus(int severity, String message, Throwable exception) {
        Status newStatus = new Status(severity, "org.eclipse.ui.cheatsheets", 1001, message, exception);
        if (this.status.isOK()) {
            this.status = newStatus;
        } else if (this.status instanceof MultiStatus) {
            ((MultiStatus)this.status).add((IStatus)newStatus);
        } else {
            MultiStatus multiStatus = new MultiStatus("org.eclipse.ui.cheatsheets", 0, Messages.ERROR_MULTIPLE_ERRORS, exception);
            multiStatus.add(this.status);
            multiStatus.add((IStatus)newStatus);
            this.status = multiStatus;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompositeCheatSheetModel parseGuide(URL url) {
        Document document;
        this.status = Status.OK_STATUS;
        if (url == null) {
            String message = NLS.bind((String)Messages.ERROR_OPENING_FILE, (Object[])new Object[]{""});
            this.addStatus(4, message, null);
            return null;
        }
        InputStream is = null;
        try {
            is = url.openStream();
            if (is == null) {
                String message = NLS.bind((String)Messages.ERROR_OPENING_FILE, (Object[])new Object[]{url.getFile()});
                this.addStatus(4, message, null);
                return null;
            }
        }
        catch (Exception e) {
            String message = NLS.bind((String)Messages.ERROR_OPENING_FILE, (Object[])new Object[]{url.getFile()});
            this.addStatus(4, message, e);
            return null;
        }
        String filename = url.getFile();
        try {
            try {
                InputSource inputSource = new InputSource(is);
                document = this.getDocumentBuilder().parse(inputSource);
            }
            catch (IOException e) {
                String message = NLS.bind((String)Messages.ERROR_OPENING_FILE_IN_PARSER, (Object[])new Object[]{filename});
                this.addStatus(4, message, e);
                CompositeCheatSheetModel compositeCheatSheetModel = null;
                Object var7_19 = null;
                try {
                    is.close();
                    return compositeCheatSheetModel;
                }
                catch (Exception exception) {}
                return compositeCheatSheetModel;
            }
            catch (SAXParseException spe) {
                String message = NLS.bind((String)Messages.ERROR_SAX_PARSING_WITH_LOCATION, (Object[])new Object[]{filename, new Integer(spe.getLineNumber()), new Integer(spe.getColumnNumber())});
                this.addStatus(4, message, spe);
                CompositeCheatSheetModel compositeCheatSheetModel = null;
                Object var7_20 = null;
                try {}
                catch (Exception exception) {}
                is.close();
                return compositeCheatSheetModel;
            }
            catch (SAXException se) {
                String message = NLS.bind((String)Messages.ERROR_SAX_PARSING, (Object[])new Object[]{filename});
                this.addStatus(4, message, se);
                CompositeCheatSheetModel compositeCheatSheetModel = null;
                Object var7_21 = null;
                try {}
                catch (Exception exception) {}
                is.close();
                return compositeCheatSheetModel;
            }
        }
        catch (Throwable throwable) {
            Object var7_22 = null;
            try {}
            catch (Exception exception) {}
            is.close();
            throw throwable;
            throw throwable;
        }
        {
            Object var7_23 = null;
        }
        try {}
        catch (Exception exception) {}
        is.close();
        return this.parseCompositeCheatSheet(document, url);
    }

    public CompositeCheatSheetModel parseCompositeCheatSheet(Document document, URL url) {
        this.status = Status.OK_STATUS;
        try {
            if (document != null) {
                Element rootnode = document.getDocumentElement();
                if (!rootnode.getNodeName().equals("compositeCheatsheet")) {
                    String message = NLS.bind((String)Messages.ERROR_PARSING_ROOT_NODE_TYPE, (Object[])new Object[]{"compositeCheatsheet"});
                    throw new CheatSheetParserException(message);
                }
                String title = "";
                String explorerId = "tree";
                NamedNodeMap attributes = rootnode.getAttributes();
                if (attributes != null) {
                    int x = 0;
                    while (x < attributes.getLength()) {
                        Node attribute = attributes.item(x);
                        String attributeName = attribute.getNodeName();
                        if (attributeName != null && attributeName.equals("title")) {
                            title = attribute.getNodeValue();
                        }
                        if (attributeName.equals("explorer")) {
                            explorerId = attribute.getNodeValue();
                        }
                        ++x;
                    }
                }
                CompositeCheatSheetModel compositeCS = new CompositeCheatSheetModel(title, title, explorerId);
                this.parseCompositeCheatSheetChildren(rootnode, compositeCS);
                compositeCS.getDependencies().resolveDependencies(this);
                if (compositeCS.getRootTask() == null) {
                    this.addStatus(4, Messages.ERROR_PARSING_NO_ROOT, null);
                } else if (this.status.getSeverity() != 4) {
                    compositeCS.setContentUrl(url);
                    return compositeCS;
                }
            }
            return null;
        }
        catch (CheatSheetParserException e) {
            this.addStatus(4, e.getMessage(), null);
            return null;
        }
    }

    private void parseCompositeCheatSheetChildren(Node compositeCSNode, CompositeCheatSheetModel model) {
        this.nextTaskId = 0;
        NodeList childNodes = compositeCSNode.getChildNodes();
        int index = 0;
        while (index < childNodes.getLength()) {
            Node nextNode = childNodes.item(index);
            if (nextNode.getNodeName() == "task") {
                CheatSheetTask task = this.parseTask(nextNode, model);
                if (model.getRootTask() == null) {
                    model.setRootTask(task);
                    this.parseTaskChildren(nextNode, task, model);
                } else {
                    this.addStatus(4, Messages.ERROR_PARSING_MULTIPLE_ROOT, null);
                }
            }
            ++index;
        }
    }

    private void parseTaskChildren(Node parentNode, CheatSheetTask parentTask, CompositeCheatSheetModel model) {
        NodeList childNodes = parentNode.getChildNodes();
        int index = 0;
        while (index < childNodes.getLength()) {
            Node childNode = childNodes.item(index);
            String nodeName = childNode.getNodeName();
            if (nodeName == "task") {
                CheatSheetTask task = this.parseTask(childNode, model);
                parentTask.addSubtask(task);
                this.parseTaskChildren(childNode, task, model);
            } else if (nodeName == "param") {
                this.addParameter(parentTask, childNode.getAttributes());
            } else if (nodeName == "intro") {
                parentTask.setDescription(this.parseTextMarkup(childNode, parentTask));
            } else if (nodeName == "onCompletion") {
                parentTask.setCompletionMessage(this.parseTextMarkup(childNode, parentTask));
            } else if (nodeName == "dependsOn") {
                this.parseDependency(childNode, parentTask, model);
            }
            ++index;
        }
    }

    private void parseDependency(Node taskNode, CheatSheetTask task, CompositeCheatSheetModel model) {
        NamedNodeMap attributes = taskNode.getAttributes();
        if (attributes != null) {
            Node taskAttribute = attributes.getNamedItem("task");
            if (taskAttribute != null) {
                String requiredTaskId = taskAttribute.getNodeValue();
                model.getDependencies().addDependency(task, requiredTaskId);
            } else {
                this.addStatus(4, Messages.ERROR_PARSING_NO_ID, null);
            }
        }
    }

    private void addParameter(CheatSheetTask parentTask, NamedNodeMap attributes) {
        String name = null;
        String value = null;
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("name")) {
                        name = attribute.getNodeValue();
                    }
                    if (attributeName.equals("value")) {
                        value = attribute.getNodeValue();
                    }
                }
                ++x;
            }
        }
        if (name == null) {
            this.addStatus(2, Messages.ERROR_PARSING_NO_NAME, null);
            return;
        }
        if (value == null) {
            this.addStatus(2, Messages.ERROR_PARSING_NO_VALUE, null);
            return;
        }
        parentTask.getParameters().put(name, value);
    }

    private CheatSheetTask parseTask(Node taskNode, CompositeCheatSheetModel model) {
        NamedNodeMap attributes = taskNode.getAttributes();
        String kind = null;
        String title = null;
        String id = null;
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("kind")) {
                        kind = attribute.getNodeValue();
                    }
                    if (attributeName.equals("title")) {
                        title = attribute.getNodeValue();
                    }
                    if (attributeName.equals("id")) {
                        id = attribute.getNodeValue();
                    }
                }
                ++x;
            }
        }
        Hashtable params = new Hashtable();
        if (id == null) {
            id = this.autoGenerateId();
        }
        CheatSheetTask task = new CheatSheetTask(model, id, title, kind, params, title);
        if (model.getDependencies().getTask(id) != null) {
            String message = NLS.bind((String)Messages.ERROR_PARSING_DUPLICATE_TASK_ID, (Object[])new Object[]{id});
            this.addStatus(4, message, null);
        } else {
            model.getDependencies().saveId(task);
        }
        String completionMessage = NLS.bind((String)Messages.COMPLETED_TASK, (Object[])new Object[]{title});
        task.setCompletionMessage(completionMessage);
        return task;
    }

    private String autoGenerateId() {
        return "AutogenID" + this.nextTaskId++;
    }

    public String parseTextMarkup(Node descriptionNode, CheatSheetTask parentTask) {
        NodeList nodes = descriptionNode.getChildNodes();
        StringBuffer text = new StringBuffer();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 3) {
                text.append(node.getNodeValue());
            } else if (node.getNodeType() == 1) {
                if (node.getNodeName().equals("b")) {
                    text.append("<b>");
                    text.append(node.getFirstChild().getNodeValue());
                    text.append("</b>");
                } else if (node.getNodeName().equals("br")) {
                    text.append("<br/>");
                } else {
                    String message = NLS.bind((String)Messages.WARNING_PARSING_DESCRIPTION_UNKNOWN_ELEMENT, (Object[])new Object[]{parentTask.getName(), node.getNodeName()});
                    this.addStatus(2, message, null);
                }
            }
            ++i;
        }
        return text.toString().trim();
    }
}

