/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.views;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.cheatsheets.CheatSheetListener;
import org.eclipse.ui.cheatsheets.CheatSheetViewerFactory;
import org.eclipse.ui.cheatsheets.ICheatSheetEvent;
import org.eclipse.ui.cheatsheets.ICheatSheetViewer;
import org.eclipse.ui.cheatsheets.ICompositeCheatSheetTask;
import org.eclipse.ui.cheatsheets.ITaskEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetViewer;

public class CheatsheetTaskEditor
implements ITaskEditor {
    private ICheatSheetViewer viewer;
    private ICompositeCheatSheetTask task;

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.viewer = CheatSheetViewerFactory.createCheatSheetView();
        this.viewer.createPartControl(parent);
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public void start(ICompositeCheatSheetTask task) {
        this.task = task;
        Dictionary params = task.getParameters();
        String id = (String)params.get("id");
        String path = (String)params.get("path");
        ((CheatSheetViewer)this.viewer).setNextSavePath(task.getStateLocation());
        if (path != null) {
            try {
                URL url = task.getInputUrl(path);
                this.viewer.setInput(id, task.getName(), url);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } else {
            this.viewer.setInput(id);
        }
        ((CheatSheetViewer)this.viewer).addListener(new TaskListener());
    }

    private class TaskListener
    extends CheatSheetListener {
        TaskListener() {
        }

        public void cheatSheetEvent(ICheatSheetEvent event) {
            if (event.getEventType() == 4) {
                CheatsheetTaskEditor.this.task.advanceState();
            }
        }
    }
}

