/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.views;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.cheatsheets.ITaskExplorer;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetRegistryReader;
import org.osgi.framework.Bundle;

public class TaskExplorerManager {
    private static TaskExplorerManager instance;

    private TaskExplorerManager() {
    }

    public static TaskExplorerManager getInstance() {
        if (instance == null) {
            instance = new TaskExplorerManager();
        }
        return instance;
    }

    public ITaskExplorer getExplorer(String explorerKind) {
        CheatSheetRegistryReader.TaskExplorerNode explorerInfo = CheatSheetRegistryReader.getInstance().findTaskExplorer(explorerKind);
        if (explorerInfo != null) {
            Status status;
            String message;
            ITaskExplorer explorerInstance = null;
            Class extClass = null;
            String className = explorerInfo.getClassName();
            try {
                Bundle bundle = Platform.getBundle((String)explorerInfo.getPluginId());
                extClass = bundle.loadClass(className);
            }
            catch (Exception e) {
                message = NLS.bind((String)Messages.ERROR_LOADING_CLASS, (Object[])new Object[]{className});
                status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
            }
            try {
                if (extClass != null) {
                    Constructor c = extClass.getConstructor(new Class[0]);
                    Object[] parameters = new Object[]{};
                    explorerInstance = (ITaskExplorer)c.newInstance(parameters);
                }
            }
            catch (Exception e) {
                message = NLS.bind((String)Messages.ERROR_CREATING_CLASS, (Object[])new Object[]{className});
                status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
            }
            return explorerInstance;
        }
        return null;
    }

    public ImageDescriptor getImageDescriptor(String explorerKind) {
        CheatSheetRegistryReader.TaskExplorerNode explorerInfo = CheatSheetRegistryReader.getInstance().findTaskExplorer(explorerKind);
        if (explorerInfo != null) {
            Bundle bundle = Platform.getBundle((String)explorerInfo.getPluginId());
            URL url = Platform.find((Bundle)bundle, (IPath)new Path(explorerInfo.getIconPath()));
            try {
                url = Platform.resolve((URL)url);
                return ImageDescriptor.createFromURL((URL)url);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    public String getName(String explorerKind) {
        CheatSheetRegistryReader.TaskExplorerNode explorerInfo = CheatSheetRegistryReader.getInstance().findTaskExplorer(explorerKind);
        if (explorerInfo != null) {
            return explorerInfo.getName();
        }
        return null;
    }
}

