/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.data;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.AbstractItemExtensionElement;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetModel;
import org.eclipse.ui.internal.cheatsheets.composite.parser.CompositeCheatSheetParser;
import org.eclipse.ui.internal.cheatsheets.data.AbstractExecutable;
import org.eclipse.ui.internal.cheatsheets.data.Action;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheet;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheetCommand;
import org.eclipse.ui.internal.cheatsheets.data.CheatSheetParserException;
import org.eclipse.ui.internal.cheatsheets.data.ConditionalSubItem;
import org.eclipse.ui.internal.cheatsheets.data.ICheatSheet;
import org.eclipse.ui.internal.cheatsheets.data.IExecutableItem;
import org.eclipse.ui.internal.cheatsheets.data.IPerformWhenItem;
import org.eclipse.ui.internal.cheatsheets.data.ISubItemItem;
import org.eclipse.ui.internal.cheatsheets.data.Item;
import org.eclipse.ui.internal.cheatsheets.data.PerformWhen;
import org.eclipse.ui.internal.cheatsheets.data.RepeatedSubItem;
import org.eclipse.ui.internal.cheatsheets.data.SubItem;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetItemExtensionElement;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetRegistryReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CheatSheetParser {
    private static final String TRUE_STRING = "true";
    private DocumentBuilder documentBuilder = CheatSheetPlugin.getPlugin().getDocumentBuilder();
    private ArrayList itemExtensionContainerList;

    private StringBuffer escapeXMLCharacters(StringBuffer text) {
        int length = text.length();
        StringBuffer result = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    String tmp = "";
                    tmp = i + 5 < length ? text.substring(i, i + 5).toLowerCase() : text.substring(i, length).toLowerCase();
                    if (tmp.startsWith("<b>") || tmp.startsWith("</b>") || tmp.startsWith("<br/>")) {
                        result.append(c);
                        break;
                    }
                    result.append("&lt;");
                    break;
                }
                case '>': {
                    String tmp = "";
                    tmp = i >= 5 ? text.substring(i - 5, i + 1).toLowerCase() : text.substring(0, i + 1).toLowerCase();
                    if (tmp.endsWith("<b>") || tmp.endsWith("</b>") || tmp.endsWith("<br/>")) {
                        result.append(c);
                        break;
                    }
                    result.append("&gt;");
                    break;
                }
                case '&': {
                    result.append("&amp;");
                    break;
                }
                case '\'': {
                    result.append("&apos;");
                    break;
                }
                case '\"': {
                    result.append("&quot;");
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            ++i;
        }
        return result;
    }

    private Node findNode(Node startNode, String nodeName) {
        if (startNode == null) {
            return null;
        }
        if (startNode.getNodeName().equals(nodeName)) {
            return startNode;
        }
        NodeList nodes = startNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals(nodeName)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    private void handleExecutable(IExecutableItem item, Node executableNode, AbstractExecutable executable) throws CheatSheetParserException {
        Assert.isNotNull((Object)item);
        Assert.isNotNull((Object)executableNode);
        String[] params = null;
        NamedNodeMap attributes = executableNode.getAttributes();
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                block14: {
                    Node attribute = attributes.item(x);
                    String attributeName = attribute.getNodeName();
                    if (attribute != null && attributeName != null) {
                        if (attributeName.equals("confirm")) {
                            executable.setConfirm(attribute.getNodeValue().equals(TRUE_STRING));
                        } else if (attributeName.equals("when")) {
                            executable.setWhen(attribute.getNodeValue());
                        } else {
                            if (executable.hasParams() && attributeName.startsWith("param")) {
                                try {
                                    String paramNum;
                                    int num;
                                    if (params == null) {
                                        params = new String[9];
                                    }
                                    if ((num = Integer.parseInt(paramNum = attributeName.substring("param".length())) - 1) > -1 && num < 9) {
                                        params[num] = attribute.getNodeValue();
                                        break block14;
                                    }
                                    String message = NLS.bind((String)Messages.ERROR_PARSING_PARAM_INVALIDRANGE, (Object[])new Object[]{attributeName, paramNum});
                                    throw new NumberFormatException(message);
                                }
                                catch (NumberFormatException e) {
                                    String message = Messages.ERROR_PARSING_PARAM_INVALIDNUMBER;
                                    this.logMessage(4, false, message, null, e);
                                    throw new CheatSheetParserException(message);
                                }
                            }
                            if (!executable.handleAttribute(attribute)) {
                                String message = NLS.bind((String)Messages.WARNING_PARSING_UNKNOWN_ATTRIBUTE, (Object[])new Object[]{attributeName, executableNode.getNodeName()});
                                this.logMessage(2, false, message, null, null);
                            }
                        }
                    }
                }
                ++x;
            }
            String errorMessage = executable.checkAttributes(executableNode);
            if (errorMessage != null) {
                throw new CheatSheetParserException(errorMessage);
            }
        }
        executable.setParams(params);
        item.setExecutable(executable);
    }

    private void handleCheatSheet(CheatSheet cheatSheet, Node cheatSheetNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)cheatSheet);
        Assert.isNotNull((Object)cheatSheetNode);
        Assert.isTrue((boolean)cheatSheetNode.getNodeName().equals("cheatsheet"));
        boolean title = false;
        NamedNodeMap attributes = cheatSheetNode.getAttributes();
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("title")) {
                        title = true;
                        cheatSheet.setTitle(attribute.getNodeValue());
                    } else {
                        String message = NLS.bind((String)Messages.WARNING_PARSING_UNKNOWN_ATTRIBUTE, (Object[])new Object[]{attributeName, cheatSheetNode.getNodeName()});
                        this.logMessage(2, false, message, null, null);
                    }
                }
                ++x;
            }
        }
        if (!title) {
            String message = NLS.bind((String)Messages.ERROR_PARSING_NO_TITLE, (Object[])new Object[]{cheatSheetNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
    }

    private void handleConditionalSubItem(Item item, Node conditionalSubItemNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)item);
        Assert.isNotNull((Object)conditionalSubItemNode);
        Assert.isTrue((boolean)conditionalSubItemNode.getNodeName().equals("conditional-subitem"));
        ConditionalSubItem conditionalSubItem = new ConditionalSubItem();
        boolean condition = false;
        NamedNodeMap attributes = conditionalSubItemNode.getAttributes();
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("condition")) {
                        condition = true;
                        conditionalSubItem.setCondition(attribute.getNodeValue());
                    } else {
                        String message = NLS.bind((String)Messages.WARNING_PARSING_UNKNOWN_ATTRIBUTE, (Object[])new Object[]{attributeName, conditionalSubItemNode.getNodeName()});
                        this.logMessage(2, false, message, null, null);
                    }
                }
                ++x;
            }
        }
        if (!condition) {
            String message = NLS.bind((String)Messages.ERROR_PARSING_NO_CONDITION, (Object[])new Object[]{conditionalSubItemNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        boolean subitem = false;
        NodeList nodes = conditionalSubItemNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("subitem")) {
                subitem = true;
                this.handleSubItem(conditionalSubItem, node);
            } else if (node.getNodeType() != 3 && node.getNodeType() != 8) {
                String message = NLS.bind((String)Messages.WARNING_PARSING_UNKNOWN_ELEMENT, (Object[])new Object[]{node.getNodeName(), conditionalSubItemNode.getNodeName()});
                this.logMessage(2, false, message, null, null);
            }
            ++i;
        }
        if (!subitem) {
            String message = NLS.bind((String)Messages.ERROR_PARSING_NO_SUBITEM, (Object[])new Object[]{conditionalSubItemNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        item.addSubItem(conditionalSubItem);
    }

    private void handleDescription(Item item, Node startNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)item);
        Assert.isNotNull((Object)startNode);
        Node descriptionNode = this.findNode(startNode, "description");
        if (descriptionNode == null) {
            Node parentNode = startNode;
            if (startNode.getNodeName().equals("description")) {
                parentNode = startNode.getParentNode();
            }
            String message = NLS.bind((String)Messages.ERROR_PARSING_NO_DESCRIPTION, (Object[])new Object[]{parentNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        String text = this.handleMarkedUpText(descriptionNode, startNode, "description");
        item.setDescription(text);
    }

    private String handleMarkedUpText(Node nodeContainingText, Node startNode, String nodeName) {
        NodeList nodes = nodeContainingText.getChildNodes();
        StringBuffer text = new StringBuffer();
        boolean containsMarkup = false;
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 3) {
                text.append(node.getNodeValue());
            } else if (node.getNodeType() == 1) {
                if (node.getNodeName().equals("b")) {
                    containsMarkup = true;
                    text.append("<b>");
                    text.append(node.getFirstChild().getNodeValue());
                    text.append("</b>");
                } else if (node.getNodeName().equals("br")) {
                    containsMarkup = true;
                    text.append("<br/>");
                } else {
                    this.warnUnknownMarkupElement(startNode, nodeName, node);
                }
            }
            ++i;
        }
        if (containsMarkup) {
            text = this.escapeXMLCharacters(text);
            text.insert(0, "<form><p>");
            text.append("</p></form>");
        }
        return text.toString().trim();
    }

    private void warnUnknownMarkupElement(Node startNode, String nodeName, Node node) {
        Node parentNode = startNode;
        if (startNode.getNodeName().equals(nodeName)) {
            parentNode = startNode.getParentNode();
        }
        String message = nodeName == "description" ? NLS.bind((String)Messages.WARNING_PARSING_DESCRIPTION_UNKNOWN_ELEMENT, (Object[])new Object[]{parentNode.getNodeName(), node.getNodeName()}) : NLS.bind((String)Messages.WARNING_PARSING_ON_COMPLETION_UNKNOWN_ELEMENT, (Object[])new Object[]{parentNode.getNodeName(), node.getNodeName()});
        this.logMessage(2, false, message, null, null);
    }

    private void handleOnCompletion(Item item, Node onCompletionNode) {
        String text = this.handleMarkedUpText(onCompletionNode, onCompletionNode, "onCompletion");
        item.setCompletionMessage(text);
    }

    private void handleIntro(CheatSheet cheatSheet, Document document) throws CheatSheetParserException {
        Assert.isNotNull((Object)cheatSheet);
        Assert.isNotNull((Object)document);
        NodeList introList = document.getElementsByTagName("intro");
        Node introNode = introList.item(0);
        if (introNode == null) {
            throw new CheatSheetParserException(Messages.ERROR_PARSING_NO_INTRO);
        }
        if (introList.getLength() > 1) {
            throw new CheatSheetParserException(Messages.ERROR_PARSING_MORE_THAN_ONE_INTRO);
        }
        Item introItem = new Item();
        introItem.setTitle(Messages.CHEAT_SHEET_INTRO_TITLE);
        this.handleIntroAttributes(introItem, introNode);
        this.handleDescription(introItem, introNode);
        cheatSheet.setIntroItem(introItem);
    }

    private void handleIntroAttributes(Item item, Node introNode) {
        Assert.isNotNull((Object)item);
        Assert.isNotNull((Object)introNode);
        NamedNodeMap attributes = introNode.getAttributes();
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("contextId")) {
                        item.setContextId(attribute.getNodeValue());
                    } else if (attributeName.equals("href")) {
                        item.setHref(attribute.getNodeValue());
                    } else {
                        String message = NLS.bind((String)Messages.WARNING_PARSING_UNKNOWN_ATTRIBUTE, (Object[])new Object[]{attributeName, introNode.getNodeName()});
                        this.logMessage(2, false, message, null, null);
                    }
                }
                ++x;
            }
        }
    }

    private Item handleItem(Node itemNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)itemNode);
        Assert.isTrue((boolean)itemNode.getNodeName().equals("item"));
        Item item = new Item();
        this.handleItemAttributes(item, itemNode);
        boolean description = false;
        NodeList nodes = itemNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("action")) {
                this.handleExecutable(item, node, new Action());
            } else if (node.getNodeName().equals("command")) {
                this.handleExecutable(item, node, new CheatSheetCommand());
            } else if (node.getNodeName().equals("description")) {
                description = true;
                this.handleDescription(item, node);
            } else if (node.getNodeName().equals("onCompletion")) {
                this.handleOnCompletion(item, node);
            } else if (node.getNodeName().equals("subitem")) {
                this.handleSubItem(item, node);
            } else if (node.getNodeName().equals("conditional-subitem")) {
                this.handleConditionalSubItem(item, node);
            } else if (node.getNodeName().equals("repeated-subitem")) {
                this.handleRepeatedSubItem(item, node);
            } else if (node.getNodeName().equals("perform-when")) {
                this.handlePerformWhen(item, node);
            } else if (node.getNodeType() != 3 && node.getNodeType() != 8) {
                String message = NLS.bind((String)Messages.WARNING_PARSING_UNKNOWN_ELEMENT, (Object[])new Object[]{node.getNodeName(), itemNode.getNodeName()});
                this.logMessage(2, false, message, null, null);
            }
            ++i;
        }
        if (!description) {
            String message = NLS.bind((String)Messages.ERROR_PARSING_NO_DESCRIPTION, (Object[])new Object[]{itemNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        return item;
    }

    private void handleItemAttributes(Item item, Node itemNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)item);
        Assert.isNotNull((Object)itemNode);
        ArrayList<AbstractItemExtensionElement[]> itemExtensionElements = new ArrayList<AbstractItemExtensionElement[]>();
        boolean title = false;
        NamedNodeMap attributes = itemNode.getAttributes();
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("title")) {
                        title = true;
                        item.setTitle(attribute.getNodeValue());
                    } else if (attributeName.equals("contextId")) {
                        item.setContextId(attribute.getNodeValue());
                    } else if (attributeName.equals("href")) {
                        item.setHref(attribute.getNodeValue());
                    } else if (attributeName.equals("skip")) {
                        item.setSkip(attribute.getNodeValue().equals(TRUE_STRING));
                    } else if (attributeName.equals("dialog")) {
                        item.setDialog(attribute.getNodeValue().equals(TRUE_STRING));
                    } else {
                        AbstractItemExtensionElement[] ie = this.handleUnknownItemAttribute(attribute, itemNode);
                        if (ie != null) {
                            itemExtensionElements.add(ie);
                        }
                    }
                }
                ++x;
            }
        }
        if (!title) {
            String message = NLS.bind((String)Messages.ERROR_PARSING_NO_TITLE, (Object[])new Object[]{itemNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        if (itemExtensionElements != null) {
            item.setItemExtensions(itemExtensionElements);
        }
    }

    private void handleItems(CheatSheet cheatSheet, Document document) throws CheatSheetParserException {
        NodeList itemList = document.getElementsByTagName("item");
        if (itemList == null || itemList.getLength() == 0) {
            throw new CheatSheetParserException(Messages.ERROR_PARSING_NO_ITEM);
        }
        ArrayList items = this.handleItems(itemList);
        if (items == null || items.size() == 0) {
            throw new CheatSheetParserException(Messages.ERROR_PARSING_NO_ITEM);
        }
        cheatSheet.addItems(items);
    }

    private ArrayList handleItems(NodeList itemList) throws CheatSheetParserException {
        CheatSheetRegistryReader reader = CheatSheetRegistryReader.getInstance();
        this.itemExtensionContainerList = reader.readItemExtensions();
        ArrayList<Item> localList = new ArrayList<Item>();
        int i = 0;
        while (i < itemList.getLength()) {
            Node itemNode = itemList.item(i);
            Item item = this.handleItem(itemNode);
            localList.add(item);
            ++i;
        }
        return localList;
    }

    private void handlePerformWhen(IPerformWhenItem item, Node performWhenNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)item);
        Assert.isNotNull((Object)performWhenNode);
        Assert.isTrue((boolean)performWhenNode.getNodeName().equals("perform-when"));
        PerformWhen performWhen = new PerformWhen();
        boolean condition = false;
        NamedNodeMap attributes = performWhenNode.getAttributes();
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("condition")) {
                        condition = true;
                        performWhen.setCondition(attribute.getNodeValue());
                    } else {
                        String message = NLS.bind((String)Messages.WARNING_PARSING_UNKNOWN_ATTRIBUTE, (Object[])new Object[]{attributeName, performWhenNode.getNodeName()});
                        this.logMessage(2, false, message, null, null);
                    }
                }
                ++x;
            }
        }
        if (!condition) {
            String message = NLS.bind((String)Messages.ERROR_PARSING_NO_CONDITION, (Object[])new Object[]{performWhenNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        boolean exeutable = false;
        NodeList nodes = performWhenNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("action")) {
                exeutable = true;
                this.handleExecutable(performWhen, node, new Action());
            } else if (node.getNodeName().equals("command")) {
                exeutable = true;
                this.handleExecutable(performWhen, node, new CheatSheetCommand());
            } else if (node.getNodeType() != 3 && node.getNodeType() != 8) {
                String message = NLS.bind((String)Messages.WARNING_PARSING_UNKNOWN_ELEMENT, (Object[])new Object[]{node.getNodeName(), performWhenNode.getNodeName()});
                this.logMessage(2, false, message, null, null);
            }
            ++i;
        }
        if (!exeutable) {
            String message = NLS.bind((String)Messages.ERROR_PARSING_NO_ACTION, (Object[])new Object[]{performWhenNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        item.setPerformWhen(performWhen);
    }

    private void handleRepeatedSubItem(Item item, Node repeatedSubItemNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)item);
        Assert.isNotNull((Object)repeatedSubItemNode);
        Assert.isTrue((boolean)repeatedSubItemNode.getNodeName().equals("repeated-subitem"));
        RepeatedSubItem repeatedSubItem = new RepeatedSubItem();
        boolean values = false;
        NamedNodeMap attributes = repeatedSubItemNode.getAttributes();
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("values")) {
                        values = true;
                        repeatedSubItem.setValues(attribute.getNodeValue());
                    } else {
                        String message = NLS.bind((String)Messages.WARNING_PARSING_UNKNOWN_ATTRIBUTE, (Object[])new Object[]{attributeName, repeatedSubItemNode.getNodeName()});
                        this.logMessage(2, false, message, null, null);
                    }
                }
                ++x;
            }
        }
        if (!values) {
            String message = NLS.bind((String)Messages.ERROR_PARSING_NO_VALUES, (Object[])new Object[]{repeatedSubItemNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        boolean subitem = false;
        NodeList nodes = repeatedSubItemNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("subitem")) {
                subitem = true;
                this.handleSubItem(repeatedSubItem, node);
            } else if (node.getNodeType() != 3 && node.getNodeType() != 8) {
                String message = NLS.bind((String)Messages.WARNING_PARSING_UNKNOWN_ELEMENT, (Object[])new Object[]{node.getNodeName(), repeatedSubItemNode.getNodeName()});
                this.logMessage(2, false, message, null, null);
            }
            ++i;
        }
        if (!subitem) {
            String message = NLS.bind((String)Messages.ERROR_PARSING_NO_SUBITEM, (Object[])new Object[]{repeatedSubItemNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
        item.addSubItem(repeatedSubItem);
    }

    private void handleSubItem(ISubItemItem item, Node subItemNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)item);
        Assert.isNotNull((Object)subItemNode);
        Assert.isTrue((boolean)subItemNode.getNodeName().equals("subitem"));
        SubItem subItem = new SubItem();
        this.handleSubItemAttributes(subItem, subItemNode);
        NodeList nodes = subItemNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("action")) {
                this.handleExecutable(subItem, node, new Action());
            } else if (node.getNodeName().equals("command")) {
                this.handleExecutable(subItem, node, new CheatSheetCommand());
            } else if (node.getNodeName().equals("perform-when")) {
                this.handlePerformWhen(subItem, node);
            } else if (node.getNodeType() != 3 && node.getNodeType() != 8) {
                String message = NLS.bind((String)Messages.WARNING_PARSING_UNKNOWN_ELEMENT, (Object[])new Object[]{node.getNodeName(), subItemNode.getNodeName()});
                this.logMessage(2, false, message, null, null);
            }
            ++i;
        }
        item.addSubItem(subItem);
    }

    private void handleSubItemAttributes(SubItem subItem, Node subItemNode) throws CheatSheetParserException {
        Assert.isNotNull((Object)subItem);
        Assert.isNotNull((Object)subItemNode);
        boolean label = false;
        NamedNodeMap attributes = subItemNode.getAttributes();
        if (attributes != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                Node attribute = attributes.item(x);
                String attributeName = attribute.getNodeName();
                if (attribute != null && attributeName != null) {
                    if (attributeName.equals("label")) {
                        label = true;
                        subItem.setLabel(attribute.getNodeValue());
                    } else if (attributeName.equals("skip")) {
                        subItem.setSkip(attribute.getNodeValue().equals(TRUE_STRING));
                    } else if (attributeName.equals("when")) {
                        subItem.setWhen(attribute.getNodeValue());
                    } else {
                        String message = NLS.bind((String)Messages.WARNING_PARSING_UNKNOWN_ATTRIBUTE, (Object[])new Object[]{attributeName, subItemNode.getNodeName()});
                        this.logMessage(2, false, message, null, null);
                    }
                }
                ++x;
            }
        }
        if (!label) {
            String message = NLS.bind((String)Messages.ERROR_PARSING_NO_LABEL, (Object[])new Object[]{subItemNode.getNodeName()});
            throw new CheatSheetParserException(message);
        }
    }

    private AbstractItemExtensionElement[] handleUnknownItemAttribute(Node item, Node node) {
        ArrayList<AbstractItemExtensionElement> al = new ArrayList<AbstractItemExtensionElement>();
        if (this.itemExtensionContainerList == null) {
            return null;
        }
        int i = 0;
        while (i < this.itemExtensionContainerList.size()) {
            AbstractItemExtensionElement itemElement;
            CheatSheetItemExtensionElement itemExtensionElement = (CheatSheetItemExtensionElement)((Object)this.itemExtensionContainerList.get(i));
            if (itemExtensionElement.getItemAttribute().equals(item.getNodeName()) && (itemElement = itemExtensionElement.createInstance()) != null) {
                itemElement.handleAttribute(item.getNodeValue());
                al.add(itemElement);
            }
            ++i;
        }
        if (al.size() == 0) {
            String message = NLS.bind((String)Messages.WARNING_PARSING_UNKNOWN_ATTRIBUTE, (Object[])new Object[]{item.getNodeName(), node.getNodeName()});
            this.logMessage(2, false, message, null, null);
        }
        return al.toArray(new AbstractItemExtensionElement[al.size()]);
    }

    private void logMessage(int severity, boolean informUser, String message, String title, Throwable exception) {
        Status status = new Status(severity, "org.eclipse.ui.cheatsheets", 0, message, exception);
        this.logMessage(informUser, title, (IStatus)status);
    }

    private void logMessage(boolean informUser, String title, IStatus status) {
        CheatSheetPlugin.getPlugin().getLog().log(status);
        if (informUser) {
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, null, (IStatus)status);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICheatSheet parse(URL url) {
        Document document;
        InputStream is;
        block23: {
            ICheatSheet iCheatSheet;
            block22: {
                if (url == null) {
                    return null;
                }
                is = null;
                InputSource inputSource = null;
                try {
                    is = url.openStream();
                    if (is != null) {
                        inputSource = new InputSource(is);
                    }
                }
                catch (Exception e) {
                    String message = NLS.bind((String)Messages.ERROR_OPENING_FILE, (Object[])new Object[]{url.getFile()});
                    this.logMessage(4, true, message, Messages.ERROR_TITLE, e);
                    return null;
                }
                try {
                    try {
                        if (this.documentBuilder == null) {
                            this.logMessage(4, false, Messages.ERROR_DOCUMENT_BUILDER_NOT_INIT, null, null);
                            iCheatSheet = null;
                            Object var7_16 = null;
                            break block22;
                        }
                        document = this.documentBuilder.parse(inputSource);
                        break block23;
                    }
                    catch (IOException e) {
                        String message = NLS.bind((String)Messages.ERROR_OPENING_FILE_IN_PARSER, (Object[])new Object[]{url.getFile()});
                        this.logMessage(4, false, message, null, e);
                        ICheatSheet iCheatSheet2 = null;
                        Object var7_17 = null;
                        try {
                            is.close();
                            return iCheatSheet2;
                        }
                        catch (Exception exception) {}
                        return iCheatSheet2;
                    }
                    catch (SAXParseException spe) {
                        String message = NLS.bind((String)Messages.ERROR_SAX_PARSING_WITH_LOCATION, (Object[])new Object[]{url.getFile(), new Integer(spe.getLineNumber()), new Integer(spe.getColumnNumber())});
                        this.logMessage(4, false, message, null, spe);
                        ICheatSheet iCheatSheet3 = null;
                        Object var7_18 = null;
                        try {}
                        catch (Exception exception) {}
                        is.close();
                        return iCheatSheet3;
                    }
                    catch (SAXException se) {
                        String message = NLS.bind((String)Messages.ERROR_SAX_PARSING, (Object[])new Object[]{url.getFile()});
                        this.logMessage(4, false, message, null, se);
                        ICheatSheet iCheatSheet4 = null;
                        Object var7_19 = null;
                        try {}
                        catch (Exception exception) {}
                        is.close();
                        return iCheatSheet4;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_20 = null;
                    try {}
                    catch (Exception exception) {}
                    is.close();
                    throw throwable;
                    throw throwable;
                }
            }
            try {}
            catch (Exception exception) {}
            is.close();
            return iCheatSheet;
        }
        Object var7_21 = null;
        try {}
        catch (Exception exception) {}
        is.close();
        if (this.isComposite(document)) {
            CompositeCheatSheetParser compositeParser = new CompositeCheatSheetParser();
            CompositeCheatSheetModel result = compositeParser.parseCompositeCheatSheet(document, url);
            if (compositeParser.getStatus().isOK()) return result;
            this.logMessage(true, Messages.ERROR_TITLE, compositeParser.getStatus());
            return result;
        }
        try {
            return this.parseCheatSheet(document);
        }
        catch (CheatSheetParserException e) {
            this.logMessage(4, true, e.getMessage(), Messages.ERROR_TITLE, e);
            return null;
        }
    }

    private boolean isComposite(Document document) {
        if (document != null) {
            Element rootnode = document.getDocumentElement();
            return rootnode.getNodeName().equals("compositeCheatsheet");
        }
        return false;
    }

    private CheatSheet parseCheatSheet(Document document) throws CheatSheetParserException {
        if (document != null) {
            Element rootnode = document.getDocumentElement();
            if (!rootnode.getNodeName().equals("cheatsheet")) {
                throw new CheatSheetParserException(Messages.ERROR_PARSING_CHEATSHEET_ELEMENT);
            }
            CheatSheet cheatSheet = new CheatSheet();
            this.handleCheatSheet(cheatSheet, rootnode);
            this.handleIntro(cheatSheet, document);
            this.handleItems(cheatSheet, document);
            return cheatSheet;
        }
        throw new CheatSheetParserException(Messages.ERROR_PARSING_CHEATSHEET_CONTENTS);
    }
}

