/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.data;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetManager;
import org.eclipse.ui.internal.cheatsheets.views.CoreItem;
import org.eclipse.ui.internal.cheatsheets.views.SubItemCompositeHolder;
import org.eclipse.ui.internal.cheatsheets.views.ViewItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class CheatSheetSaveHelper {
    protected IPath savePath;
    protected Vector stateVector = new Vector();

    public CheatSheetSaveHelper() {
        this.savePath = Platform.getPluginStateLocation((Plugin)CheatSheetPlugin.getPlugin());
    }

    private Properties createProperties(int currentItemNum, ArrayList items, boolean buttonIsDown, ArrayList expandRestoreStates, String csID) {
        Properties props = new Properties();
        Hashtable<String, String> subcompletedTable = new Hashtable<String, String>(10);
        Hashtable<String, String> subskippedTable = new Hashtable<String, String>(10);
        int buttonState = 0;
        if (buttonIsDown) {
            buttonState = 1;
        }
        props.put("id", csID);
        props.put("current", Integer.toString(currentItemNum));
        ArrayList<String> completedList = new ArrayList<String>();
        ArrayList<String> expandedList = new ArrayList<String>();
        if (expandRestoreStates == null) {
            expandRestoreStates = new ArrayList();
        }
        int i = 0;
        while (i < items.size()) {
            CoreItem withsubs;
            ArrayList compList;
            ViewItem item = (ViewItem)items.get(i);
            if (item.isCompleted()) {
                completedList.add(Integer.toString(i));
            }
            if (item.isExpanded()) {
                expandedList.add(Integer.toString(i));
            }
            if (item instanceof CoreItem && (compList = (withsubs = (CoreItem)item).getListOfSubItemCompositeHolders()) != null) {
                StringBuffer skippedsubItems = new StringBuffer();
                StringBuffer completedsubItems = new StringBuffer();
                int j = 0;
                while (j < compList.size()) {
                    SubItemCompositeHolder sch = (SubItemCompositeHolder)compList.get(j);
                    if (sch.isCompleted()) {
                        completedsubItems.append(String.valueOf(Integer.toString(j)) + ",");
                    }
                    if (sch.isSkipped()) {
                        skippedsubItems.append(String.valueOf(Integer.toString(j)) + ",");
                    }
                    ++j;
                }
                if (completedsubItems.toString().length() > 0) {
                    String csi = completedsubItems.toString();
                    if (csi.endsWith(",")) {
                        csi = csi.substring(0, csi.length() - 1);
                    }
                    subcompletedTable.put(Integer.toString(i), csi);
                }
                if (skippedsubItems.toString().length() > 0) {
                    String csi = skippedsubItems.toString();
                    if (csi.endsWith(",")) {
                        csi = csi.substring(0, csi.length() - 1);
                    }
                    subskippedTable.put(Integer.toString(i), csi);
                }
            }
            ++i;
        }
        props.put("completed", completedList);
        props.put("expanded", expandedList);
        props.put("expandRestore", expandRestoreStates);
        props.put("button", Integer.toString(buttonState));
        if (subcompletedTable != null) {
            props.put("subitemcompleted", subcompletedTable);
        }
        if (subskippedTable != null) {
            props.put("subitemskipped", subskippedTable);
        }
        return props;
    }

    protected String getAttributeWithName(NamedNodeMap map, String name) {
        try {
            return map.getNamedItem(name).getNodeValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ArrayList getMultipleAttributesWithSameName(NodeList nl, String name) {
        ArrayList<String> returnList = new ArrayList<String>();
        int i = 0;
        while (i < nl.getLength()) {
            String value = nl.item(i).getAttributes().getNamedItem(name).getNodeValue();
            if (value != null) {
                returnList.add(value);
            }
            ++i;
        }
        return returnList;
    }

    public Path getStateFile(String csID) {
        return this.getStateFile(csID, this.savePath);
    }

    protected Path getStateFile(String csID, IPath rootPath) {
        return new Path(rootPath.append(String.valueOf(csID) + ".xml").toOSString());
    }

    public Properties loadState(String csID, IPath savePath) {
        this.savePath = savePath != null ? savePath : Platform.getPluginStateLocation((Plugin)CheatSheetPlugin.getPlugin());
        Properties returnProps = null;
        Hashtable<String, String> subskipped = null;
        Hashtable<String, String> subcompleted = null;
        Path filePath = this.getStateFile(csID);
        Document doc = null;
        URL readURL = null;
        try {
            readURL = filePath.toFile().toURL();
            doc = this.readXMLFile(readURL);
        }
        catch (MalformedURLException mue) {
            String message = NLS.bind((String)Messages.ERROR_CREATING_STATEFILE_URL, (Object[])new Object[]{readURL});
            Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)mue);
            CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
            return null;
        }
        if (doc != null) {
            NodeList csmDatanl;
            NodeList snl;
            Hashtable<String, String> ht = null;
            Element rootnode = doc.getDocumentElement();
            NamedNodeMap rootatts = rootnode.getAttributes();
            if (this.isReference(doc)) {
                String path = this.getAttributeWithName(rootatts, "path");
                return this.loadState(csID, (IPath)new Path(path));
            }
            String currentID = this.getAttributeWithName(rootatts, "id");
            String number = this.getAttributeWithName(doc.getElementsByTagName("current").item(0).getAttributes(), "item");
            ArrayList completeList = this.getMultipleAttributesWithSameName(doc.getElementsByTagName("completed"), "item");
            ArrayList expandedList = this.getMultipleAttributesWithSameName(doc.getElementsByTagName("expanded"), "item");
            ArrayList expandRestoreList = this.getMultipleAttributesWithSameName(doc.getElementsByTagName("expandRestore"), "item");
            String buttonState = this.getAttributeWithName(doc.getElementsByTagName("button").item(0).getAttributes(), "buttonstate");
            NodeList nl = doc.getElementsByTagName("subitemcompleted");
            if (nl != null) {
                subcompleted = new Hashtable<String, String>(10);
                int i = 0;
                while (i < nl.getLength()) {
                    String item = this.getAttributeWithName(nl.item(i).getAttributes(), "item");
                    String subItems = this.getAttributeWithName(nl.item(i).getAttributes(), "subitem");
                    subcompleted.put(item, subItems);
                    ++i;
                }
            }
            if ((snl = doc.getElementsByTagName("subitemskipped")) != null) {
                subskipped = new Hashtable<String, String>(10);
                int i = 0;
                while (i < snl.getLength()) {
                    String item = this.getAttributeWithName(snl.item(i).getAttributes(), "item");
                    String subItems = this.getAttributeWithName(snl.item(i).getAttributes(), "subitem");
                    subskipped.put(item, subItems);
                    ++i;
                }
            }
            if ((csmDatanl = doc.getElementsByTagName("CSMData")) != null) {
                ht = new Hashtable<String, String>(30);
                int i = 0;
                while (i < csmDatanl.getLength()) {
                    String key = null;
                    try {
                        key = this.getAttributeWithName(csmDatanl.item(i).getAttributes(), "key");
                        String data = csmDatanl.item(i).getFirstChild().getNodeValue();
                        ht.put(key, data);
                    }
                    catch (Exception e) {
                        String message = NLS.bind((String)Messages.ERROR_READING_MANAGERDATA_FROM_STATEFILE, (Object[])new Object[]{key, currentID});
                        Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
                        CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                    }
                    ++i;
                }
            }
            returnProps = new Properties();
            returnProps.put("id", currentID);
            returnProps.put("current", number);
            returnProps.put("completed", completeList);
            returnProps.put("expanded", expandedList);
            returnProps.put("expandRestore", expandRestoreList);
            returnProps.put("button", buttonState);
            returnProps.put("subitemcompleted", subcompleted);
            returnProps.put("subitemskipped", subskipped);
            returnProps.put("CSMData", ht);
        }
        return returnProps;
    }

    protected boolean isReference(Document doc) {
        Element rootnode = doc.getDocumentElement();
        return "CHEATSHEET_STATE_REFERENCE".equals(rootnode.getNodeName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Document readXMLFile(URL url) {
        InputStream is;
        block14: {
            Document document;
            is = null;
            InputSource source = null;
            try {
                is = url.openStream();
                if (is != null) {
                    source = new InputSource(is);
                }
            }
            catch (Exception exception) {
                return null;
            }
            if (source == null) {
                return null;
            }
            try {
                try {
                    DocumentBuilder documentBuilder = CheatSheetPlugin.getPlugin().getDocumentBuilder();
                    document = documentBuilder.parse(source);
                    Object var5_6 = null;
                }
                catch (Exception exception) {
                    break block14;
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            if (is == null) return document;
            is.close();
            return document;
        }
        Object var5_8 = null;
        try {}
        catch (IOException iOException) {
            return null;
        }
        if (is == null) return null;
        is.close();
        return null;
    }

    private void saveState(Properties saveProperties, String contentPath, CheatSheetManager csm) {
        String csID = null;
        try {
            Element eRel;
            String subItemNum;
            String itemNum;
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = documentBuilder.newDocument();
            Properties properties = saveProperties;
            csID = (String)properties.get("id");
            String number = (String)properties.get("current");
            Path filePath = this.getStateFile(csID);
            ArrayList completedList = (ArrayList)properties.get("completed");
            ArrayList expandedList = (ArrayList)properties.get("expanded");
            ArrayList expandRestoreList = (ArrayList)properties.get("expandRestore");
            Hashtable subcompletedTable = (Hashtable)properties.get("subitemcompleted");
            Hashtable subskippedTable = (Hashtable)properties.get("subitemskipped");
            Element root = doc.createElement("cheatsheet");
            root.setAttribute("id", csID);
            if (contentPath != null) {
                root.setAttribute("contentURL", contentPath);
            }
            doc.appendChild(root);
            Element cEl = doc.createElement("current");
            cEl.setAttribute("item", number);
            root.appendChild(cEl);
            int j = 0;
            while (j < completedList.size()) {
                Element compEl = doc.createElement("completed");
                compEl.setAttribute("item", (String)completedList.get(j));
                root.appendChild(compEl);
                ++j;
            }
            j = 0;
            while (j < expandedList.size()) {
                Element expandEl = doc.createElement("expanded");
                expandEl.setAttribute("item", (String)expandedList.get(j));
                root.appendChild(expandEl);
                ++j;
            }
            j = 0;
            while (j < expandRestoreList.size()) {
                Element eRel2 = doc.createElement("expandRestore");
                eRel2.setAttribute("item", (String)expandRestoreList.get(j));
                root.appendChild(eRel2);
                ++j;
            }
            if (subcompletedTable != null) {
                Enumeration enumeration = subcompletedTable.keys();
                while (enumeration.hasMoreElements()) {
                    itemNum = (String)enumeration.nextElement();
                    subItemNum = (String)subcompletedTable.get(itemNum);
                    if (itemNum == null || subItemNum == null) continue;
                    eRel = doc.createElement("subitemcompleted");
                    eRel.setAttribute("item", itemNum);
                    eRel.setAttribute("subitem", subItemNum);
                    root.appendChild(eRel);
                }
            }
            if (subskippedTable != null) {
                Enumeration enumeration = subskippedTable.keys();
                while (enumeration.hasMoreElements()) {
                    itemNum = (String)enumeration.nextElement();
                    subItemNum = (String)subskippedTable.get(itemNum);
                    if (itemNum == null || subItemNum == null) continue;
                    eRel = doc.createElement("subitemskipped");
                    eRel.setAttribute("item", itemNum);
                    eRel.setAttribute("subitem", subItemNum);
                    root.appendChild(eRel);
                }
            }
            Element bel = doc.createElement("button");
            bel.setAttribute("buttonstate", (String)properties.get("button"));
            root.appendChild(bel);
            Hashtable managerData = (Hashtable)csm.getData();
            if (managerData != null) {
                Enumeration e = managerData.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String data = (String)managerData.get(key);
                    Element csmDataTag = doc.createElement("CSMData");
                    csmDataTag.setAttribute("key", key);
                    Text t = doc.createTextNode(data);
                    csmDataTag.appendChild(t);
                    root.appendChild(csmDataTag);
                }
            }
            StreamResult streamResult = new StreamResult(filePath.toFile());
            DOMSource domSource = new DOMSource(doc);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.transform(domSource, streamResult);
        }
        catch (Exception e) {
            String message = NLS.bind((String)Messages.ERROR_SAVING_STATEFILE_URL, (Object[])new Object[]{csID});
            Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
            CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
        }
    }

    public void saveState(int currentItemNum, ArrayList items, boolean buttonIsDown, ArrayList expandRestoreStates, String csID, String contentPath, CheatSheetManager csm) {
        Properties properties = this.createProperties(currentItemNum, items, buttonIsDown, expandRestoreStates, csID);
        this.saveState(properties, contentPath, csm);
    }

    public IStatus setSavePath(IPath path, String csID, boolean saveReference) {
        IStatus status = Status.OK_STATUS;
        this.savePath = path;
        if (saveReference) {
            try {
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = documentBuilder.newDocument();
                Path filePath = this.getStateFile(csID, Platform.getPluginStateLocation((Plugin)CheatSheetPlugin.getPlugin()));
                Element root = doc.createElement("CHEATSHEET_STATE_REFERENCE");
                root.setAttribute("path", path.toOSString());
                doc.appendChild(root);
                StreamResult streamResult = new StreamResult(filePath.toFile());
                DOMSource domSource = new DOMSource(doc);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.transform(domSource, streamResult);
            }
            catch (ParserConfigurationException e) {
                status = this.saveErrorStatus(e);
            }
            catch (FactoryConfigurationError e) {
                status = this.saveErrorStatus(e);
            }
            catch (TransformerConfigurationException e) {
                status = this.saveErrorStatus(e);
            }
            catch (TransformerFactoryConfigurationError e) {
                status = this.saveErrorStatus(e);
            }
            catch (TransformerException e) {
                status = this.saveErrorStatus(e);
            }
        }
        return status;
    }

    private IStatus saveErrorStatus(Throwable e) {
        return new Status(4, "org.eclipse.ui.cheatsheets", 0, Messages.ERROR_SAVING_STATE_REFERENCE, e);
    }

    public RestoreInfo getIdFromStateFile(URL url) {
        Document doc = null;
        doc = this.readXMLFile(url);
        if (doc != null) {
            RestoreInfo result = new RestoreInfo();
            Element rootnode = doc.getDocumentElement();
            NamedNodeMap rootatts = rootnode.getAttributes();
            result.id = this.getAttributeWithName(rootatts, "id");
            if (result.id == null) {
                Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, Messages.ERROR_READING_ID_FROM_STATEFILE, null);
                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
            }
            result.contentURL = this.getAttributeWithName(rootatts, "contentURL");
            return result;
        }
        return null;
    }

    public IPath getSavePath() {
        return this.savePath;
    }

    public class RestoreInfo {
        public String id;
        public String contentURL;
    }
}

