/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.views;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.CheatSheetStopWatch;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.actions.CheatSheetMenu;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetRegistryReader;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetExpandRestoreAction;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetViewer;
import org.eclipse.ui.part.ViewPart;

public class CheatSheetView
extends ViewPart {
    private boolean actionBarContributed = false;
    private CheatSheetExpandRestoreAction expandRestoreAction;
    private Action copyAction;
    private CheatSheetViewer viewer;
    private IMemento memento;

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        IMenuManager menuManager = bars.getMenuManager();
        IToolBarManager tbmanager = bars.getToolBarManager();
        IPath path = CheatSheetPlugin.ICONS_PATH.append("elcl16/").append("collapse_expand_all.gif");
        ImageDescriptor collapseExpandImage = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        this.expandRestoreAction = new CheatSheetExpandRestoreAction(Messages.COLLAPSE_ALL_BUT_CURRENT_TOOLTIP, false, this.viewer);
        this.expandRestoreAction.setToolTipText(Messages.COLLAPSE_ALL_BUT_CURRENT_TOOLTIP);
        this.expandRestoreAction.setImageDescriptor(collapseExpandImage);
        this.copyAction = new Action("copy"){

            public void run() {
                CheatSheetView.this.viewer.copy();
            }
        };
        this.copyAction.setEnabled(false);
        tbmanager.add((IAction)this.expandRestoreAction);
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        this.viewer.setExpandRestoreAction(this.expandRestoreAction);
        this.viewer.setCopyAction(this.copyAction);
        CheatSheetMenu cheatsheetMenuMenuItem = new CheatSheetMenu();
        menuManager.add((IContributionItem)cheatsheetMenuMenuItem);
    }

    public void createPartControl(Composite parent) {
        CheatSheetStopWatch.startStopWatch("CheatSheetView.createPartControl");
        this.viewer = new CheatSheetViewer(false);
        this.viewer.createPartControl(parent);
        if (!this.actionBarContributed) {
            this.contributeToActionBars();
            this.actionBarContributed = true;
        }
        CheatSheetStopWatch.printLapTime("CheatSheetView.createPartControl", "Time in CheatSheetView.createPartControl() before restoreState: ");
        if (this.memento != null) {
            this.restoreState(this.memento);
        }
        CheatSheetStopWatch.printTotalTime("CheatSheetView.createPartControl", "Time in CheatSheetView.createPartControl(): ");
    }

    public void dispose() {
        super.dispose();
    }

    public CheatSheetElement getContent() {
        if (this.viewer != null) {
            return this.viewer.getContent();
        }
        return null;
    }

    public String getCheatSheetID() {
        if (this.viewer != null) {
            return this.viewer.getCheatSheetID();
        }
        return null;
    }

    public CheatSheetViewer getCheatSheetViewer() {
        return this.viewer;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.init(site);
        this.memento = memento;
    }

    private void restoreState(IMemento memento) {
        IMemento contentMemento = memento.getChild("cheatSheetMemento");
        if (contentMemento != null) {
            String id = contentMemento.getString("id");
            String name = contentMemento.getString("name");
            if (name != null) {
                try {
                    URL fileURL = new URL(contentMemento.getString("url"));
                    this.setInput(id, name, fileURL);
                }
                catch (MalformedURLException malformedURLException) {}
            } else if (id != null) {
                this.setInput(id);
            }
        }
    }

    public void saveState(IMemento memento) {
        if (this.viewer != null) {
            CheatSheetElement element = this.viewer.getContent();
            if (element == null) {
                return;
            }
            IMemento contentMemento = memento.createChild("cheatSheetMemento");
            CheatSheetElement tempElement = CheatSheetRegistryReader.getInstance().findCheatSheet(element.getID());
            if (tempElement != null) {
                contentMemento.putString("id", element.getID());
            } else {
                contentMemento.putString("id", element.getID());
                contentMemento.putString("name", element.getLabel(null));
                contentMemento.putString("url", element.getContentFile());
            }
            this.viewer.saveCurrentSheet();
        }
    }

    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.setFocus();
        }
    }

    public void setInput(String id) {
        CheatSheetStopWatch.startStopWatch("CheatSheetView.setInput");
        if (this.viewer != null) {
            this.viewer.setInput(id);
        }
        CheatSheetStopWatch.printTotalTime("CheatSheetView.setInput", "Time in CheatSheetView.setInput(String id): ");
    }

    public void setInput(String id, String name, URL url) {
        if (this.viewer != null) {
            this.viewer.setInput(id, name, url);
        }
    }
}

