/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.Hashtable;
import org.eclipse.core.internal.boot.PlatformURLBaseConnection;
import org.eclipse.core.internal.boot.PlatformURLHandler;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.internal.runtime.PlatformURLConfigConnection;
import org.eclipse.core.internal.runtime.PlatformURLFragmentConnection;
import org.eclipse.core.internal.runtime.PlatformURLMetaConnection;
import org.eclipse.core.internal.runtime.PlatformURLPluginConnection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.service.runnable.ParameterizedRunnable;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class PlatformActivator
extends Plugin
implements BundleActivator {
    private static final String PROP_ECLIPSE_EXITCODE = "eclipse.exitcode";
    private static final String PROP_ECLIPSE_APPLICATION = "eclipse.application";
    private static BundleContext context;
    private ServiceRegistration entryLocatorRegistration;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext runtimeContext) throws Exception {
        context = runtimeContext;
        InternalPlatform.getDefault().start(runtimeContext);
        this.installPlatformURLSupport();
        this.registerApplicationService();
        InternalPlatform.getDefault().setRuntimeInstance(this);
        super.start(runtimeContext);
    }

    private void installPlatformURLSupport() {
        PlatformURLPluginConnection.startup();
        PlatformURLFragmentConnection.startup();
        PlatformURLMetaConnection.startup();
        PlatformURLConfigConnection.startup();
        PlatformURLBaseConnection.startup(InternalPlatform.getDefault().getInstallURL());
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>(1);
        properties.put("url.handler.protocol", new String[]{"platform"});
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.url.URLStreamHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.registerService(clazz.getName(), (Object)new PlatformURLHandler(), properties);
    }

    public void stop(BundleContext runtimeContext) {
        this.unregisterEntryLocator();
        InternalPlatform.getDefault().stop(runtimeContext);
        InternalPlatform.getDefault().setRuntimeInstance(null);
    }

    private void registerApplicationService() {
        ParameterizedRunnable work = new ParameterizedRunnable(){

            public Object run(Object arg) throws Exception {
                Object result;
                IProduct product;
                IPlatformRunnable application = null;
                String applicationId = System.getProperty(PlatformActivator.PROP_ECLIPSE_APPLICATION);
                if (applicationId == null && (product = InternalPlatform.getDefault().getProduct()) != null && (applicationId = product.getApplication()) != null) {
                    System.getProperties().setProperty(PlatformActivator.PROP_ECLIPSE_APPLICATION, applicationId);
                }
                if (applicationId == null) {
                    throw new RuntimeException(Messages.application_noIdFound);
                }
                IExtensionRegistry registry = InternalPlatform.getDefault().getRegistry();
                IExtension applicationExtension = registry.getExtension("org.eclipse.core.runtime", "applications", applicationId);
                if (applicationExtension == null) {
                    IExtension[] availableApps = registry.getExtensionPoint("org.eclipse.core.runtime.applications").getExtensions();
                    String availableAppsString = "<NONE>";
                    if (availableApps.length != 0) {
                        availableAppsString = availableApps[0].getUniqueIdentifier();
                        int i = 1;
                        while (i < availableApps.length) {
                            availableAppsString = String.valueOf(availableAppsString) + ", " + availableApps[i].getUniqueIdentifier();
                            ++i;
                        }
                    }
                    throw new RuntimeException(NLS.bind((String)Messages.application_notFound, (Object)applicationId, (Object)availableAppsString));
                }
                IConfigurationElement[] configs = applicationExtension.getConfigurationElements();
                if (configs.length == 0) {
                    throw new RuntimeException(NLS.bind((String)Messages.application_invalidExtension, (Object)applicationId));
                }
                IConfigurationElement config = configs[0];
                application = (IPlatformRunnable)config.createExecutableExtension("run");
                if (arg == null) {
                    arg = InternalPlatform.getDefault().getApplicationArgs();
                }
                int exitCode = (result = application.run(arg)) instanceof Integer ? (Integer)result : 0;
                System.getProperties().setProperty(PlatformActivator.PROP_ECLIPSE_EXITCODE, Integer.toString(exitCode));
                if (InternalPlatform.DEBUG) {
                    System.out.println(NLS.bind((String)Messages.application_returned, (Object[])new String[]{applicationId, result == null ? "null" : result.toString()}));
                }
                return result;
            }
        };
        Hashtable<String, String> properties = new Hashtable<String, String>(1);
        properties.put(PROP_ECLIPSE_APPLICATION, "default");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.osgi.service.runnable.ParameterizedRunnable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.registerService(clazz.getName(), (Object)work, properties);
    }

    private void unregisterEntryLocator() {
        if (this.entryLocatorRegistration != null) {
            this.entryLocatorRegistration.unregister();
            this.entryLocatorRegistration = null;
        }
    }
}

