/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.mapping;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.internal.core.mapping.AbstractResourceMappingScope;
import org.eclipse.team.internal.core.mapping.CompoundResourceTraversal;
import org.eclipse.team.internal.core.mapping.ResourceMappingInputScope;

public class ResourceMappingScope
extends AbstractResourceMappingScope {
    private ResourceMapping[] inputMappings;
    private final Map mappingsToTraversals = new HashMap();
    private boolean hasAdditionalMappings;
    private boolean hasAdditionalResources;
    private final CompoundResourceTraversal compoundTraversal = new CompoundResourceTraversal();

    public ResourceMappingScope(ResourceMapping[] selectedMappings) {
        this.inputMappings = selectedMappings;
    }

    public ResourceTraversal[] addMapping(ResourceMapping mapping, ResourceTraversal[] traversals) {
        ResourceTraversal[] newTraversals = this.compoundTraversal.getUncoveredTraversals(traversals);
        this.mappingsToTraversals.put(mapping, traversals);
        this.compoundTraversal.addTraversals(traversals);
        return newTraversals;
    }

    public ResourceMapping[] getInputMappings() {
        return this.inputMappings;
    }

    public ResourceMapping[] getMappings() {
        if (this.mappingsToTraversals.isEmpty()) {
            return this.inputMappings;
        }
        return this.mappingsToTraversals.keySet().toArray(new ResourceMapping[this.mappingsToTraversals.size()]);
    }

    public ResourceTraversal[] getTraversals() {
        return this.compoundTraversal.asTraversals();
    }

    public ResourceTraversal[] getTraversals(ResourceMapping mapping) {
        return (ResourceTraversal[])this.mappingsToTraversals.get(mapping);
    }

    public boolean hasAdditionalMappings() {
        return this.hasAdditionalMappings;
    }

    public void setHasAdditionalMappings(boolean hasAdditionalMappings) {
        this.hasAdditionalMappings = hasAdditionalMappings;
    }

    public void setHasAdditionalResources(boolean hasAdditionalResources) {
        this.hasAdditionalResources = hasAdditionalResources;
    }

    public boolean hasAdditonalResources() {
        return this.hasAdditionalResources;
    }

    public CompoundResourceTraversal getCompoundTraversal() {
        return this.compoundTraversal;
    }

    public ISynchronizationScope asInputScope() {
        return new ResourceMappingInputScope(this);
    }
}

