/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.team.internal.ui.history.GenericHistoryView;
import org.eclipse.ui.part.PluginDropAdapter;
import org.eclipse.ui.part.ResourceTransfer;

public class GenericHistoryDropAdapter
extends PluginDropAdapter {
    private GenericHistoryView view;

    public GenericHistoryDropAdapter(GenericHistoryView view) {
        super(null);
        this.view = view;
    }

    public void dragOver(DropTargetEvent event) {
        if ((event.operations & 4) == 4) {
            event.detail = 4;
        }
        super.dragOver(event);
    }

    public void drop(DropTargetEvent event) {
        super.drop(event);
        event.detail = 4;
    }

    public boolean performDrop(Object data) {
        if (data == null) {
            return false;
        }
        if (data instanceof IResource[]) {
            IResource[] sources = (IResource[])data;
            if (sources.length == 0) {
                return false;
            }
            IResource resource = sources[0];
            if (!(resource instanceof IFile)) {
                return false;
            }
            this.view.itemDropped(resource);
            return true;
        }
        return false;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        if (transferType != null && ResourceTransfer.getInstance().isSupportedType(transferType)) {
            return true;
        }
        return super.validateDrop(target, operation, transferType);
    }

    protected Object getCurrentTarget() {
        return this.view;
    }
}

