/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.diff.IDiffChangeListener;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.CommonViewerAdvisor;
import org.eclipse.team.internal.ui.mapping.IEmptyTreeListener;
import org.eclipse.team.internal.ui.mapping.ShowModelProviderAction;
import org.eclipse.team.internal.ui.synchronize.AbstractSynchronizePage;
import org.eclipse.team.internal.ui.synchronize.ForwardingChangesSection;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.ui.mapping.ISynchronizationCompareAdapter;
import org.eclipse.team.ui.mapping.ModelOperation;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class DiffTreeChangesSection
extends ForwardingChangesSection
implements IDiffChangeListener,
IPropertyChangeListener,
IEmptyTreeListener {
    private ISynchronizationContext context;

    public DiffTreeChangesSection(Composite parent, AbstractSynchronizePage page, ISynchronizePageConfiguration configuration) {
        super(parent, page, configuration);
        this.context = (ISynchronizationContext)configuration.getProperty("org.eclipse.team.ui.synchronizationContext");
        this.context.getDiffTree().addDiffChangeListener((IDiffChangeListener)this);
        this.getConfiguration().addPropertyChangeListener(this);
    }

    public void dispose() {
        this.context.getDiffTree().removeDiffChangeListener((IDiffChangeListener)this);
        this.getConfiguration().removePropertyChangeListener(this);
        super.dispose();
    }

    protected int getChangesCount() {
        return this.context.getDiffTree().size();
    }

    protected long getChangesInMode(int candidateMode) {
        long numChanges;
        long numConflicts = this.context.getDiffTree().countFor(768, 768);
        switch (candidateMode) {
            case 8: {
                numChanges = numConflicts;
                break;
            }
            case 2: {
                numChanges = numConflicts + this.context.getDiffTree().countFor(256, 768);
                break;
            }
            case 1: {
                numChanges = numConflicts + this.context.getDiffTree().countFor(512, 768);
                break;
            }
            case 4: {
                numChanges = numConflicts + this.context.getDiffTree().countFor(512, 768) + this.context.getDiffTree().countFor(256, 768);
                break;
            }
            default: {
                numChanges = 0L;
            }
        }
        return numChanges;
    }

    protected long getChangesInMode(ISynchronizationCompareAdapter adapter, int candidateMode) {
        long numChanges;
        long numConflicts = adapter.countFor(this.context, 768, 768);
        switch (candidateMode) {
            case 8: {
                numChanges = numConflicts;
                break;
            }
            case 2: {
                numChanges = numConflicts + adapter.countFor(this.context, 256, 768);
                break;
            }
            case 1: {
                numChanges = numConflicts + adapter.countFor(this.context, 512, 768);
                break;
            }
            case 4: {
                numChanges = numConflicts + adapter.countFor(this.context, 512, 768) + adapter.countFor(this.context, 256, 768);
                break;
            }
            default: {
                numChanges = 0L;
            }
        }
        return numChanges;
    }

    protected long getVisibleChangesCount() {
        int currentMode = this.getConfiguration().getMode();
        ISynchronizePageConfiguration configuration = this.getConfiguration();
        String id = (String)configuration.getProperty("org.eclipse.team.ui.activeModelProvider");
        if (id != null && !id.equals("org.eclipse.team.ui.activeModelProvider")) {
            try {
                IModelProviderDescriptor desc = ModelProvider.getModelProviderDescriptor((String)id);
                ISynchronizationCompareAdapter adapter = Utils.getCompareAdapter(desc.getModelProvider());
                if (adapter != null) {
                    return this.getChangesInMode(adapter, this.getConfiguration().getMode());
                }
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
        }
        return this.getChangesInMode(currentMode);
    }

    protected int getCandidateMode() {
        long incomingChanges;
        SynchronizePageConfiguration configuration = (SynchronizePageConfiguration)this.getConfiguration();
        long outgoingChanges = this.context.getDiffTree().countFor(256, 768);
        if (outgoingChanges > 0L) {
            if (configuration.isModeSupported(2)) {
                return 2;
            }
            if (configuration.isModeSupported(4)) {
                return 4;
            }
        }
        if ((incomingChanges = this.context.getDiffTree().countFor(512, 768)) > 0L) {
            if (configuration.isModeSupported(1)) {
                return 1;
            }
            if (configuration.isModeSupported(4)) {
                return 4;
            }
        }
        return configuration.getMode();
    }

    public void diffChanged(IDiffChangeEvent event, IProgressMonitor monitor) {
        this.calculateDescription();
    }

    public void propertyChanged(int property, IPath[] paths) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.team.ui.P_SYNCVIEWPAGE_MODE") || event.getProperty().equals("org.eclipse.team.ui.activeModelProvider")) {
            this.calculateDescription();
        }
    }

    protected Composite getEmptyChangesComposite(Composite parent) {
        ISynchronizePageConfiguration configuration = this.getConfiguration();
        String id = (String)configuration.getProperty("org.eclipse.team.ui.activeModelProvider");
        if (id != null && !id.equals("org.eclipse.team.ui.activeModelProvider")) {
            ModelProvider[] providers = this.context.getScope().getModelProviders();
            providers = ModelOperation.sortByExtension(providers);
            int i = 0;
            while (i < providers.length) {
                long count;
                ModelProvider provider = providers[i];
                ISynchronizationCompareAdapter adapter = Utils.getCompareAdapter(provider);
                if (adapter != null && (count = this.getChangesInMode(adapter, this.getConfiguration().getMode())) > 0L && !provider.getDescriptor().getId().equals(id)) {
                    return this.getPointerToModel(parent, provider, count, id);
                }
                ++i;
            }
        }
        return super.getEmptyChangesComposite(parent);
    }

    private Composite getPointerToModel(Composite parent, final ModelProvider provider, long count, String oldId) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.getBackgroundColor());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data);
        IModelProviderDescriptor oldDesc = ModelProvider.getModelProviderDescriptor((String)oldId);
        String modeToString = Utils.modeToString(this.getConfiguration().getMode());
        String message = count > 1L ? NLS.bind((String)"However {0} has {1} changes in {2} mode.", (Object[])new String[]{provider.getDescriptor().getLabel(), Long.toString(count), modeToString}) : NLS.bind((String)"However {0} has {1} change in {2} mode.", (Object[])new String[]{provider.getDescriptor().getLabel(), Long.toString(count), modeToString});
        message = NLS.bind((String)"There are no more {0} changes for {1}. {2}", (Object[])new String[]{modeToString, oldDesc.getLabel(), message});
        Label warning = new Label(composite, 0);
        warning.setImage(TeamUIPlugin.getPlugin().getImage("ovr/warning_co.gif"));
        Hyperlink link = this.getForms().createHyperlink(composite, NLS.bind((String)"Change to {0}.", (Object[])new String[]{provider.getDescriptor().getLabel()}), 64);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                new ShowModelProviderAction(DiffTreeChangesSection.this.getConfiguration(), provider).run();
            }
        });
        this.getForms().getHyperlinkGroup().add(link);
        this.createDescriptionLabel(composite, message);
        return composite;
    }

    public void treeEmpty(TreeViewer viewer) {
        this.handleEmptyViewer();
    }

    private void handleEmptyViewer() {
        TeamUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                if (!DiffTreeChangesSection.this.getContainer().isDisposed()) {
                    DiffTreeChangesSection.this.updatePage(DiffTreeChangesSection.this.getEmptyChangesComposite((Composite)DiffTreeChangesSection.this.getContainer()));
                }
            }
        });
    }

    protected void calculateDescription() {
        if (this.isViewerEmpty()) {
            this.handleEmptyViewer();
        } else {
            super.calculateDescription();
        }
    }

    private boolean isViewerEmpty() {
        Viewer v = this.getPage().getViewer();
        if (v instanceof CommonViewerAdvisor.NavigableCommonViewer) {
            CommonViewerAdvisor.NavigableCommonViewer cv = (CommonViewerAdvisor.NavigableCommonViewer)v;
            return cv.isEmpty();
        }
        return false;
    }

    public void notEmpty(TreeViewer viewer) {
        this.calculateDescription();
    }
}

