/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.io.InputStream;
import org.eclipse.compare.BufferedContent;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.history.IFileRevision;

public class FileStateTypedElement
extends BufferedContent
implements ITypedElement,
IEditableContent,
IEncodedStreamContentAccessor {
    IFileRevision state;
    private IStorage bufferedContents;

    public FileStateTypedElement(IFileRevision state) {
        this.state = state;
    }

    protected InputStream createStream() throws CoreException {
        if (this.bufferedContents == null) {
            this.cacheContents((IProgressMonitor)new NullProgressMonitor());
        }
        if (this.bufferedContents != null) {
            return this.bufferedContents.getContents();
        }
        return null;
    }

    public String getName() {
        return this.state.getName();
    }

    public Image getImage() {
        return CompareUI.getImage((String)this.getType());
    }

    public String getType() {
        String name = this.getName();
        if (name != null) {
            int index = name.lastIndexOf(46);
            if (index == -1) {
                return "";
            }
            if (index == name.length() - 1) {
                return "";
            }
            return name.substring(index + 1);
        }
        return "FOLDER";
    }

    public boolean isEditable() {
        return false;
    }

    public ITypedElement replace(ITypedElement dest, ITypedElement src) {
        return null;
    }

    public String getCharset() throws CoreException {
        if (this.bufferedContents == null) {
            this.cacheContents((IProgressMonitor)new NullProgressMonitor());
        }
        if (this.bufferedContents instanceof IEncodedStorage) {
            return ((IEncodedStorage)this.bufferedContents).getCharset();
        }
        return null;
    }

    public void cacheContents(IProgressMonitor monitor) throws CoreException {
        this.bufferedContents = this.state.getStorage(monitor);
    }
}

