/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.registry;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.registry.RegistryReader;
import org.eclipse.team.ui.mapping.ITeamContentProviderDescriptor;

public class TeamContentProviderDescriptor
implements ITeamContentProviderDescriptor {
    private static final String TAG_TEAM_CONTENT_PROVIDER = "teamContentProvider";
    private static final String ATT_MODEL_PROVIDER_ID = "modelProviderId";
    private static final String ATT_CONTENT_EXTENSION_ID = "contentExtensionId";
    private static final String ATT_ICON = "icon";
    private static final String ATT_PREFERENCE_PAGE = "preferencePage";
    private String modelProviderId;
    private String contentExtensionId;
    private ImageDescriptor imageDescriptor;
    private IConfigurationElement configElement;

    public TeamContentProviderDescriptor(IExtension extension) throws CoreException {
        this.readExtension(extension);
    }

    protected void readExtension(IExtension extension) throws CoreException {
        String id = extension.getUniqueIdentifier();
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int count = elements.length;
        int i = 0;
        if (i < count) {
            IConfigurationElement element;
            this.configElement = element = elements[i];
            String name = element.getName();
            if (name.equalsIgnoreCase(TAG_TEAM_CONTENT_PROVIDER)) {
                this.modelProviderId = element.getAttribute(ATT_MODEL_PROVIDER_ID);
                this.contentExtensionId = element.getAttribute(ATT_CONTENT_EXTENSION_ID);
            }
        }
        if (this.modelProviderId == null) {
            this.fail(NLS.bind((String)TeamUIMessages.TeamContentProviderDescriptor_1, (Object[])new String[]{ATT_MODEL_PROVIDER_ID, TAG_TEAM_CONTENT_PROVIDER, id == null ? "" : id}));
        }
        if (this.contentExtensionId == null) {
            this.fail(NLS.bind((String)TeamUIMessages.TeamContentProviderDescriptor_1, (Object[])new String[]{ATT_CONTENT_EXTENSION_ID, TAG_TEAM_CONTENT_PROVIDER, id == null ? "" : id}));
        }
    }

    protected void fail(String reason) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.team.ui", 0, reason, null));
    }

    public String getContentExtensionId() {
        return this.contentExtensionId;
    }

    public String getModelProviderId() {
        return this.modelProviderId;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor != null) {
            return this.imageDescriptor;
        }
        String iconName = this.configElement.getAttribute(ATT_ICON);
        if (iconName == null) {
            return null;
        }
        this.imageDescriptor = TeamUIPlugin.getImageDescriptorFromExtension(this.configElement.getDeclaringExtension(), iconName);
        return this.imageDescriptor;
    }

    public IPreferencePage createPreferencePage() throws CoreException {
        Object obj = RegistryReader.createExtension(this.configElement, ATT_PREFERENCE_PAGE);
        return (IPreferencePage)obj;
    }
}

