/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantReference;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.ui.ISaveableModel;
import org.eclipse.ui.ISaveableModelSource;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.WorkbenchPartLabelProvider;

public class RemoveSynchronizeParticipantAction
extends Action {
    private final ISynchronizeView view;
    private boolean removeAll;

    public RemoveSynchronizeParticipantAction(ISynchronizeView view, boolean removeAll) {
        this.view = view;
        this.removeAll = removeAll;
        if (removeAll) {
            Utils.initAction((IAction)this, "action.removeAllPage.");
        } else {
            Utils.initAction((IAction)this, "action.removePage.");
        }
    }

    public void run() {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (RemoveSynchronizeParticipantAction.this.removeAll) {
                        RemoveSynchronizeParticipantAction.this.removeAll();
                    } else {
                        RemoveSynchronizeParticipantAction.this.removeCurrent();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Utils.handle(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void removeCurrent() {
        ISynchronizeParticipant participant = this.view.getParticipant();
        if (participant != null) {
            final List dirtyModels = this.getDirtyModels(participant);
            if (participant.isPinned() || !dirtyModels.isEmpty()) {
                final boolean[] keepGoing = new boolean[1];
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        keepGoing[0] = !dirtyModels.isEmpty() ? RemoveSynchronizeParticipantAction.this.promptToSave(dirtyModels) : MessageDialog.openQuestion((Shell)RemoveSynchronizeParticipantAction.this.view.getSite().getShell(), (String)TeamUIMessages.RemoveSynchronizeParticipantAction_0, (String)TeamUIMessages.RemoveSynchronizeParticipantAction_1);
                    }
                });
                if (!keepGoing[0]) {
                    return;
                }
            }
            TeamUI.getSynchronizeManager().removeSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
        }
    }

    private void removeAll() {
        ISynchronizeManager manager = TeamUI.getSynchronizeManager();
        ISynchronizeParticipantReference[] refs = manager.getSynchronizeParticipants();
        ArrayList<ISynchronizeParticipant> removals = new ArrayList<ISynchronizeParticipant>();
        int i = 0;
        while (i < refs.length) {
            ISynchronizeParticipantReference reference = refs[i];
            try {
                ISynchronizeParticipant p = reference.getParticipant();
                if (!p.isPinned()) {
                    removals.add(p);
                }
            }
            catch (TeamException teamException) {}
            ++i;
        }
        ISynchronizeParticipant[] toRemove = removals.toArray(new ISynchronizeParticipant[removals.size()]);
        final List dirtyModels = this.getDirtyModels(toRemove);
        if (!dirtyModels.isEmpty()) {
            final boolean[] keepGoing = new boolean[1];
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (!dirtyModels.isEmpty()) {
                        keepGoing[0] = RemoveSynchronizeParticipantAction.this.promptToSave(dirtyModels);
                    }
                }
            });
            if (!keepGoing[0]) {
                return;
            }
        }
        manager.removeSynchronizeParticipants(toRemove);
    }

    private boolean promptToSave(List dirtyModels) {
        block11: {
            block10: {
                if (dirtyModels.size() != 1) break block10;
                ISaveableModel model = (ISaveableModel)dirtyModels.get(0);
                String message = NLS.bind((String)"{0} contains unsaved changes. Would you like to save them?", (Object)model.getName());
                String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                MessageDialog d = new MessageDialog(this.view.getSite().getShell(), "Save Changes", null, message, 3, buttons, 0);
                int choice = d.open();
                switch (choice) {
                    case 0: {
                        break block11;
                    }
                    case 1: {
                        return true;
                    }
                    default: {
                        return false;
                    }
                }
            }
            ListSelectionDialog dlg = new ListSelectionDialog(this.view.getSite().getShell(), (Object)dirtyModels, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new WorkbenchPartLabelProvider(), "There are unsaved changes.");
            dlg.setInitialSelections(dirtyModels.toArray());
            dlg.setTitle("Save Changes");
            int result = dlg.open();
            if (result == 1) {
                return false;
            }
            dirtyModels = Arrays.asList(dlg.getResult());
        }
        if (dirtyModels.isEmpty()) {
            return true;
        }
        final List<Object> finalModels = dirtyModels;
        IRunnableWithProgress progressOp = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(null, finalModels.size());
                Iterator i = finalModels.iterator();
                while (i.hasNext()) {
                    ISaveableModel model = (ISaveableModel)i.next();
                    if (model.isDirty()) {
                        model.doSave((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    if (monitor.isCanceled()) break;
                }
                monitor.done();
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, progressOp);
        }
        catch (InvocationTargetException e) {
            Utils.handleError(this.view.getSite().getShell(), e, null, null);
            return false;
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    private List getDirtyModels(ISynchronizeParticipant participant) {
        ISaveableModelSource source = this.getSaveableModelSource(participant);
        ArrayList<ISaveableModel> dirtyModels = new ArrayList<ISaveableModel>();
        if (source != null) {
            ISaveableModel[] models = source.getModels();
            int i = 0;
            while (i < models.length) {
                ISaveableModel model = models[i];
                if (model.isDirty()) {
                    dirtyModels.add(model);
                }
                ++i;
            }
        }
        return dirtyModels;
    }

    private List getDirtyModels(ISynchronizeParticipant[] participants) {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < participants.length) {
            ISynchronizeParticipant participant = participants[i];
            result.addAll(this.getDirtyModels(participant));
            ++i;
        }
        return result;
    }

    private ISaveableModelSource getSaveableModelSource(ISynchronizeParticipant participant) {
        if (participant instanceof ISaveableModelSource) {
            return (ISaveableModelSource)participant;
        }
        return null;
    }
}

