/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.history;

import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.core.LocalFileRevision;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;
import org.eclipse.team.internal.ui.history.TypedBufferedContent;
import org.eclipse.team.ui.PageSaveablePart;
import org.eclipse.team.ui.history.IHistoryCompareAdapter;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryPageSite;
import org.eclipse.ui.part.Page;

public class HistoryPageSaveablePart
extends PageSaveablePart {
    IHistoryPage historyPage;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public HistoryPageSaveablePart(Shell shell, CompareConfiguration cc, IHistoryPage pageSource) {
        super(shell, cc);
        this.historyPage = pageSource;
    }

    public String getTitle() {
        return this.historyPage.getName();
    }

    public Image getTitleImage() {
        return null;
    }

    public void contentChanged(IContentChangeNotifier source) {
    }

    public void createPartControl(Composite parent2) {
        super.createPartControl(parent2);
        IHistoryPageSite pageSite = this.historyPage.getHistoryPageSite();
        pageSite.setToolBarManager(CompareViewerPane.getToolBarManager((Composite)this.getEditionPane()));
        this.setShowContentPanes(false);
        ((Page)this.historyPage).createControl((Composite)this.getEditionPane());
        this.getEditionPane().setContent(((Page)this.historyPage).getControl());
        this.historyPage.getHistoryPageSite().getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IHistoryCompareAdapter compareAdapter;
                IHistoryPage iHistoryPage = HistoryPageSaveablePart.this.historyPage;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.team.ui.history.IHistoryCompareAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((compareAdapter = (IHistoryCompareAdapter)Utils.getAdapter(iHistoryPage, clazz)) != null) {
                    ICompareInput input = compareAdapter.getCompareInput(event.getSelection());
                    HistoryPageSaveablePart.this.prepareCompareInput(input);
                    HistoryPageSaveablePart.this.setInput(input);
                }
            }
        });
        this.historyPage.refresh();
    }

    protected void prepareInput(ICompareInput input, CompareConfiguration configuration, IProgressMonitor monitor) throws InvocationTargetException {
        this.initLabels(input);
        this.hookContentChangeListener(input);
    }

    private void initLabels(ICompareInput input) {
        CompareConfiguration cc = this.getCompareConfiguration();
        cc.setLeftEditable(false);
        cc.setRightEditable(false);
        String leftLabel = this.getFileRevisionLabel(input.getLeft());
        cc.setLeftLabel(leftLabel);
        String rightLabel = this.getFileRevisionLabel(input.getRight());
        cc.setRightLabel(rightLabel);
    }

    private String getFileRevisionLabel(ITypedElement element) {
        String label = null;
        if (element instanceof TypedBufferedContent) {
            Date dateFromLong = new Date(((TypedBufferedContent)element).getModificationDate());
            label = NLS.bind((String)TeamUIMessages.CompareFileRevisionEditorInput_workspace, (Object[])new Object[]{element.getName(), DateFormat.getDateTimeInstance().format(dateFromLong)});
            this.getCompareConfiguration().setLeftEditable(true);
            return label;
        }
        if (element instanceof FileRevisionTypedElement) {
            Object fileObject = ((FileRevisionTypedElement)element).getFileRevision();
            if (fileObject instanceof LocalFileRevision) {
                try {
                    IStorage storage = ((LocalFileRevision)fileObject).getStorage((IProgressMonitor)new NullProgressMonitor());
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.core.resources.IFileState");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (Utils.getAdapter(storage, clazz) != null) {
                        label = NLS.bind((String)TeamUIMessages.CompareFileRevisionEditorInput_localRevision, (Object[])new Object[]{element.getName(), ((FileRevisionTypedElement)element).getTimestamp()});
                    }
                }
                catch (CoreException coreException) {}
            } else {
                label = NLS.bind((String)TeamUIMessages.CompareFileRevisionEditorInput_repository, (Object[])new Object[]{element.getName(), ((FileRevisionTypedElement)element).getContentIdentifier()});
            }
        }
        return label;
    }

    public void doSave(IProgressMonitor monitor) {
        ArrayList viewers = this.getDirtyViewers();
        Iterator iter = viewers.iterator();
        int i = 0;
        while (i < viewers.size()) {
            Object element = iter.next();
            if (element instanceof ContentMergeViewer) {
                try {
                    ((ContentMergeViewer)element).save(monitor);
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
    }
}

