/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.mapping;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.TeamOperation;
import org.eclipse.team.ui.mapping.ISaveableCompareModel;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.ui.IWorkbenchPart;

public abstract class SynchronizationOperation
extends TeamOperation {
    private final ISynchronizePageConfiguration configuration;
    private final Object[] elements;

    private static IWorkbenchPart getPart(ISynchronizePageConfiguration configuration) {
        ISynchronizePageSite site;
        if (configuration != null && (site = configuration.getSite()) != null) {
            return site.getPart();
        }
        return null;
    }

    protected SynchronizationOperation(ISynchronizePageConfiguration configuration, Object[] elements) {
        super(SynchronizationOperation.getPart(configuration));
        this.configuration = configuration;
        this.elements = elements;
    }

    public ISynchronizePageConfiguration getConfiguration() {
        return this.configuration;
    }

    protected ISynchronizationContext getContext() {
        return (ISynchronizationContext)this.getConfiguration().getProperty("org.eclipse.team.ui.synchronizationContext");
    }

    public Object[] getElements() {
        return this.elements;
    }

    public boolean shouldRun() {
        return super.shouldRun();
    }

    public ISaveableCompareModel getTargetBuffer() {
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            this.setContextBusy(monitor);
            this.execute(monitor);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.clearContextBusy(monitor);
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.clearContextBusy(monitor);
            return;
        }
    }

    private void clearContextBusy(IProgressMonitor monitor) {
        final IJobManager jobManager = Platform.getJobManager();
        JobChangeAdapter listener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Job[] jobs = jobManager.find((Object)SynchronizationOperation.this.getContext());
                if (jobs.length == 0) {
                    IResourceDiffTree diffTree = SynchronizationOperation.this.getContext().getDiffTree();
                    diffTree.clearBusy(null);
                    jobManager.removeJobChangeListener((IJobChangeListener)this);
                }
            }
        };
        jobManager.addJobChangeListener((IJobChangeListener)listener);
    }

    private void setContextBusy(IProgressMonitor monitor) {
        try {
            ResourceTraversal[] traversals = Utils.getTraversals(this.getElements());
            IResourceDiffTree diffTree = this.getContext().getDiffTree();
            IDiff[] diffs = diffTree.getDiffs(traversals);
            diffTree.setBusy(diffs, monitor);
        }
        catch (CoreException e) {
            TeamUIPlugin.log(e);
        }
    }

    protected abstract void execute(IProgressMonitor var1) throws InvocationTargetException, InterruptedException;
}

