/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.mapping;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.registry.TeamDecoratorDescription;
import org.eclipse.team.internal.ui.registry.TeamDecoratorManager;
import org.eclipse.ui.PlatformUI;

public class SynchronizationStateTester {
    public static final String PROP_TESTER = "org.eclipse.team.ui.syncStateTester";
    private Subscriber subscriber;

    public SynchronizationStateTester() {
        this(Team.getWorkspaceSubscriber());
    }

    public SynchronizationStateTester(Subscriber subscriber) {
        this.subscriber = subscriber;
    }

    public final boolean isDecorationEnabled(Object element) {
        ResourceMapping mapping = Utils.getResourceMapping(element);
        if (mapping != null) {
            IProject[] projects = mapping.getProjects();
            return this.internalIsDecorationEnabled(projects);
        }
        return false;
    }

    public final int getDecoratedStateMask(Object element) {
        ResourceMapping mapping = Utils.getResourceMapping(element);
        if (mapping != null) {
            IProject[] projects = mapping.getProjects();
            return this.internalGetDecoratedStateMask(projects);
        }
        return 0;
    }

    public boolean isStateDecorationEnabled() {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public int getState(Object element, int stateMask, IProgressMonitor monitor) throws CoreException {
        mapping = Utils.getResourceMapping(element);
        if (mapping != null) {
            try {
                return this.subscriber.getState(mapping, stateMask, monitor);
            }
            catch (CoreException e) {
                projects = mapping.getProjects();
                i = 0;
                ** while (i < projects.length)
            }
lbl-1000:
            // 1 sources

            {
                project = projects[i];
                if (project.isAccessible()) {
                    throw e;
                }
                ++i;
                continue;
            }
        }
lbl14:
        // 3 sources

        return 0;
    }

    public final boolean isSupervised(Object element) throws CoreException {
        ResourceMapping mapping = Utils.getResourceMapping(element);
        if (mapping != null) {
            ResourceTraversal[] traversals = mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, null);
            int i = 0;
            while (i < traversals.length) {
                ResourceTraversal traversal = traversals[i];
                IResource[] resources = traversal.getResources();
                int j = 0;
                while (j < resources.length) {
                    IResource resource = resources[j];
                    if (this.subscriber.isSupervised(resource)) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return false;
    }

    public Subscriber getSubscriber() {
        return this.subscriber;
    }

    private boolean internalIsDecorationEnabled(IProject[] projects) {
        String[] providerIds = this.getProviderIds(projects);
        int i = 0;
        while (i < providerIds.length) {
            String providerId = providerIds[i];
            if (this.internalIsDecorationEnabled(providerId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String[] getProviderIds(IProject[] projects) {
        HashSet<String> providerIds = new HashSet<String>();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            String id = this.getProviderId(project);
            if (id != null) {
                providerIds.add(id);
            }
            ++i;
        }
        return providerIds.toArray(new String[providerIds.size()]);
    }

    private int internalGetDecoratedStateMask(IProject[] projects) {
        int stateMask = 0;
        String[] providerIds = this.getProviderIds(projects);
        int i = 0;
        while (i < providerIds.length) {
            String providerId = providerIds[i];
            stateMask |= this.internalGetDecoratedStateMask(providerId);
            ++i;
        }
        return stateMask;
    }

    private String getProviderId(IProject project) {
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
        if (provider != null) {
            return provider.getID();
        }
        return null;
    }

    private boolean internalIsDecorationEnabled(String providerId) {
        String decoratorId = this.getDecoratorId(providerId);
        if (decoratorId != null) {
            return PlatformUI.getWorkbench().getDecoratorManager().getEnabled(decoratorId);
        }
        return false;
    }

    private int internalGetDecoratedStateMask(String providerId) {
        TeamDecoratorDescription decoratorDescription = TeamDecoratorManager.getInstance().getDecoratorDescription(providerId);
        if (decoratorDescription != null) {
            return decoratorDescription.getDecoratedDirectionFlags();
        }
        return 0;
    }

    private String getDecoratorId(String providerId) {
        TeamDecoratorDescription decoratorDescription = TeamDecoratorManager.getInstance().getDecoratorDescription(providerId);
        if (decoratorDescription != null) {
            return decoratorDescription.getDecoratorId();
        }
        return null;
    }
}

