/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroContainer;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroAnchor;
import org.eclipse.ui.internal.intro.impl.model.IntroExtensionContent;
import org.eclipse.ui.internal.intro.impl.model.IntroGroup;
import org.eclipse.ui.internal.intro.impl.model.IntroHomePage;
import org.eclipse.ui.internal.intro.impl.model.IntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroPartPresentation;
import org.eclipse.ui.internal.intro.impl.model.loader.IntroContentParser;
import org.eclipse.ui.internal.intro.impl.model.loader.ModelLoaderUtil;
import org.eclipse.ui.internal.intro.impl.model.util.BundleUtil;
import org.eclipse.ui.internal.intro.impl.model.util.ModelUtil;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.eclipse.ui.intro.config.IntroConfigurer;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IntroModelRoot
extends AbstractIntroContainer {
    public static final int CURRENT_PAGE_PROPERTY_ID = 1;
    private static final String ATT_CONTENT = "content";
    private static final String ATT_CONFIGURER = "configurer";
    private boolean hasValidConfig = true;
    private boolean isdynamicIntro;
    private IntroConfigurer configurer;
    private IntroPartPresentation introPartPresentation;
    private IntroHomePage homePage;
    private String currentPageId;
    private IntroHomePage standbyPage;
    private IConfigurationElement[] configExtensionElements;
    public ListenerList propChangeListeners = new ListenerList();
    private Hashtable unresolvedConfigExt = new Hashtable();

    public IntroModelRoot(IConfigurationElement configElement, IConfigurationElement[] configExtensionElements) {
        super(configElement);
        this.configExtensionElements = configExtensionElements;
    }

    public void loadModel() {
        this.getChildren();
    }

    protected void loadChildren() {
        IConfigurationElement presentationElement;
        this.children = new Vector();
        if (Log.logInfo) {
            Log.info("Creating Intro plugin model....");
        }
        if ((presentationElement = this.loadPresentation()) == null) {
            this.setModelState(true, false, false);
            Log.warning("Could not find presentation element in intro config.");
            return;
        }
        this.loadConfigurer();
        this.introPartPresentation = new IntroPartPresentation(presentationElement);
        this.children.add(this.introPartPresentation);
        this.introPartPresentation.setParent(this);
        Document document = this.loadDOM(this.getCfgElement());
        if (document == null) {
            this.setModelState(true, false, false);
            return;
        }
        this.base = this.getBase(this.getCfgElement());
        this.loadPages(document, this.getBundle());
        this.loadSharedGroups(document, this.getBundle());
        this.setModelState(true, true, this.getHomePage().isDynamic());
    }

    public void setPresentation(IntroPartPresentation presentation) {
        this.introPartPresentation = presentation;
        presentation.setParent(this);
        this.children.set(0, presentation);
    }

    protected void resolveChildren() {
        this.resolveConfigExtensions();
        this.resolved = true;
    }

    private IConfigurationElement loadPresentation() {
        IConfigurationElement[] presentationElements = this.getCfgElement().getChildren("presentation");
        IConfigurationElement presentationElement = ModelLoaderUtil.validateSingleContribution(presentationElements, "home-page-id");
        return presentationElement;
    }

    private void loadConfigurer() {
        String cname = this.getCfgElement().getAttribute(ATT_CONFIGURER);
        if (cname != null) {
            try {
                Object obj = this.getCfgElement().createExecutableExtension(ATT_CONFIGURER);
                if (obj instanceof IntroConfigurer) {
                    this.configurer = (IntroConfigurer)obj;
                }
            }
            catch (CoreException e) {
                Log.error("Error loading intro configurer", e);
            }
        }
    }

    private void loadPages(Document dom, Bundle bundle) {
        String homePageId = this.getPresentation().getHomePageId();
        String standbyPageId = this.getPresentation().getStandbyPageId();
        Element[] pages = ModelUtil.getElementsByTagName(dom, "page");
        int i = 0;
        while (i < pages.length) {
            Element pageElement = pages[i];
            if (pageElement.getAttribute("id").equals(homePageId)) {
                this.homePage = new IntroHomePage(pageElement, bundle, this.base);
                this.homePage.setParent(this);
                this.currentPageId = this.homePage.getId();
                this.children.add(this.homePage);
            } else if (pageElement.getAttribute("id").equals(standbyPageId)) {
                this.standbyPage = new IntroHomePage(pageElement, bundle, this.base);
                this.standbyPage.setParent(this);
                this.standbyPage.setStandbyPage(true);
                this.children.add(this.standbyPage);
            } else {
                IntroPage page = new IntroPage(pageElement, bundle, this.base);
                page.setParent(this);
                this.children.add(page);
            }
            ++i;
        }
    }

    private void loadSharedGroups(Document dom, Bundle bundle) {
        Element[] groups = ModelUtil.getElementsByTagName(dom, "group");
        int i = 0;
        while (i < groups.length) {
            IntroGroup group = new IntroGroup(groups[i], bundle, this.base);
            group.setParent(this);
            this.children.add(group);
            ++i;
        }
    }

    private void resolveConfigExtensions() {
        int i = 0;
        while (i < this.configExtensionElements.length) {
            this.resolveConfigExtension(this.configExtensionElements[i]);
            ++i;
        }
        Enumeration keys = this.unresolvedConfigExt.keys();
        while (keys.hasMoreElements()) {
            Element configExtensionElement = (Element)keys.nextElement();
            IConfigurationElement configExtConfigurationElement = (IConfigurationElement)this.unresolvedConfigExt.get(configExtensionElement);
            Bundle bundle = BundleUtil.getBundleFromConfigurationElement(configExtConfigurationElement);
            String base = this.getBase(configExtConfigurationElement);
            this.children.add(new IntroExtensionContent(configExtensionElement, bundle, base));
            Log.warning("Could not resolve the following configExtension: " + ModelLoaderUtil.getLogString(bundle, configExtensionElement, "path"));
        }
    }

    private void resolveConfigExtension(IConfigurationElement configExtElement) {
        Document dom = this.loadDOM(configExtElement);
        if (dom == null) {
            return;
        }
        this.resolveConfigExtension(dom, configExtElement);
    }

    private void resolveConfigExtension(Document dom, IConfigurationElement configExtElement) {
        String base = this.getBase(configExtElement);
        Element extensionContentElement = this.loadExtensionContent(dom, configExtElement, base);
        if (extensionContentElement == null) {
            return;
        }
        if (extensionContentElement.hasAttribute("failed")) {
            if (!this.unresolvedConfigExt.containsKey(extensionContentElement)) {
                this.unresolvedConfigExt.put(extensionContentElement, configExtElement);
            }
            return;
        }
        Bundle bundle = BundleUtil.getBundleFromConfigurationElement(configExtElement);
        Element[] pages = ModelUtil.getElementsByTagName(dom, "page");
        int j = 0;
        while (j < pages.length) {
            IntroPage page = new IntroPage(pages[j], bundle, base);
            page.setParent(this);
            this.children.add(page);
            ++j;
        }
        this.loadSharedGroups(dom, bundle);
        this.unresolvedConfigExt.remove(extensionContentElement);
        this.tryResolvingExtensions();
    }

    private void tryResolvingExtensions() {
        Enumeration keys = this.unresolvedConfigExt.keys();
        while (keys.hasMoreElements()) {
            Element extensionContentElement = (Element)keys.nextElement();
            this.resolveConfigExtension(extensionContentElement.getOwnerDocument(), (IConfigurationElement)this.unresolvedConfigExt.get(extensionContentElement));
        }
    }

    private Element loadExtensionContent(Document dom, IConfigurationElement configExtElement, String base) {
        Element[] extensionContents;
        Bundle bundle = BundleUtil.getBundleFromConfigurationElement(configExtElement);
        Element extensionContentElement = ModelLoaderUtil.validateSingleContribution(bundle, extensionContents = ModelUtil.getElementsByTagName(dom, "extensionContent"), "path");
        if (extensionContentElement == null) {
            return null;
        }
        IntroExtensionContent extensionContent = new IntroExtensionContent(extensionContentElement, bundle, base);
        boolean success = false;
        success = extensionContent.isXHTMLContent() ? this.loadXHTMLExtensionContent(extensionContent) : this.load3_0ExtensionContent(extensionContent);
        if (success) {
            if (extensionContentElement.hasAttribute("failed")) {
                extensionContentElement.removeAttribute("failed");
            }
        } else {
            extensionContentElement.setAttribute("failed", "true");
        }
        return extensionContentElement;
    }

    private boolean loadXHTMLExtensionContent(IntroExtensionContent extensionContent) {
        String path = extensionContent.getPath();
        String[] pathSegments = path.split("/");
        if (pathSegments.length != 2) {
            return false;
        }
        AbstractIntroPage targetPage = (AbstractIntroPage)this.findChild(pathSegments[0], 12);
        if (targetPage == null) {
            return false;
        }
        Document pageDom = targetPage.getDocument();
        Element targetAnchor = targetPage.findDomChild(pathSegments[1], "anchor");
        if (targetAnchor == null) {
            return false;
        }
        Document extensionDom = extensionContent.getDocument();
        if (extensionDom == null) {
            return false;
        }
        Element extensionBody = ModelUtil.getBodyElement(extensionDom);
        Element[] children = ModelUtil.getElementsByTagName(extensionBody, "*");
        int i = 0;
        while (i < children.length) {
            Node targetNode = pageDom.importNode(children[i], true);
            ModelUtil.updateResourceAttributes((Element)targetNode, extensionContent);
            targetAnchor.getParentNode().insertBefore(targetNode, targetAnchor);
            ++i;
        }
        String[] styles = extensionContent.getStyles();
        if (styles != null) {
            int i2 = 0;
            while (i2 < styles.length) {
                ModelUtil.insertStyle(pageDom, styles[i2]);
                ++i2;
            }
        }
        return true;
    }

    private boolean load3_0ExtensionContent(IntroExtensionContent extensionContent) {
        String path = extensionContent.getPath();
        AbstractIntroElement target = this.findTarget(this, path);
        if (target == null || !target.isOfType(8192)) {
            return false;
        }
        IntroAnchor targetAnchor = (IntroAnchor)target;
        this.insertAnchorChildren(targetAnchor, extensionContent, extensionContent.getBundle(), extensionContent.getBase());
        this.handleExtensionStyleInheritence(targetAnchor, extensionContent);
        return true;
    }

    private void insertAnchorChildren(IntroAnchor anchor, IntroExtensionContent extensionContent, Bundle bundle, String base) {
        AbstractIntroContainer anchorParent = (AbstractIntroContainer)anchor.getParent();
        anchorParent.insertElementsBefore(extensionContent.getChildren(), bundle, base, anchor);
    }

    private void handleExtensionStyleInheritence(IntroAnchor anchor, IntroExtensionContent extension) {
        Hashtable altStyles;
        AbstractIntroContainer targetContainer = (AbstractIntroContainer)anchor.getParent();
        if (targetContainer.getType() == 16 && targetContainer.getParent().getType() == 1) {
            return;
        }
        String[] styles = extension.getStyles();
        if (styles != null) {
            targetContainer.getParentPage().addStyles(styles);
        }
        if ((altStyles = extension.getAltStyles()) != null) {
            targetContainer.getParentPage().addAltStyles(altStyles);
        }
    }

    private void setModelState(boolean loaded, boolean hasValidConfig, boolean isdynamicIntro) {
        this.loaded = loaded;
        this.hasValidConfig = hasValidConfig;
        this.isdynamicIntro = isdynamicIntro;
    }

    public boolean hasValidConfig() {
        return this.hasValidConfig;
    }

    public IntroPartPresentation getPresentation() {
        return this.introPartPresentation;
    }

    public IntroConfigurer getConfigurer() {
        return this.configurer;
    }

    public IntroHomePage getHomePage() {
        return this.homePage;
    }

    public IntroHomePage getStandbyPage() {
        return this.standbyPage;
    }

    public IntroPage[] getPages() {
        return (IntroPage[])this.getChildrenOfType(8);
    }

    public boolean isDynamic() {
        return this.isdynamicIntro;
    }

    public String getCurrentPageId() {
        return this.currentPageId;
    }

    public boolean setCurrentPageId(String pageId, boolean fireEvent) {
        if (pageId.equals(this.currentPageId)) {
            return true;
        }
        AbstractIntroPage page = (AbstractIntroPage)this.findChild(pageId, 12);
        if (page == null && !pageId.equals(this.homePage.getId())) {
            Log.warning("Could not set current page to Intro page with id: " + pageId);
            return false;
        }
        this.currentPageId = pageId;
        if (fireEvent) {
            this.firePropertyChange(1);
        }
        return true;
    }

    public boolean setCurrentPageId(String pageId) {
        return this.setCurrentPageId(pageId, true);
    }

    public void addPropertyListener(IPropertyListener l) {
        this.propChangeListeners.add((Object)l);
    }

    public void firePropertyChange(final int propertyId) {
        Object[] array = this.propChangeListeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final IPropertyListener l = (IPropertyListener)array[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.propertyChanged((Object)this, propertyId);
                }

                public void handleException(Throwable e) {
                    super.handleException(e);
                    IntroModelRoot.this.propChangeListeners.remove((Object)l);
                }
            });
            ++i;
        }
    }

    public void removePropertyListener(IPropertyListener l) {
        this.propChangeListeners.remove((Object)l);
    }

    public AbstractIntroPage getCurrentPage() {
        if (!this.isdynamicIntro) {
            return null;
        }
        AbstractIntroPage page = (AbstractIntroPage)this.findChild(this.currentPageId, 12);
        if (page != null) {
            return page;
        }
        if (this.currentPageId.equals(this.homePage.getId())) {
            return this.homePage;
        }
        return null;
    }

    public int getType() {
        return 1;
    }

    protected Document loadDOM(IConfigurationElement cfgElement) {
        String content = cfgElement.getAttribute(ATT_CONTENT);
        Bundle domBundle = BundleUtil.getBundleFromConfigurationElement(cfgElement);
        ModelUtil.extractParentFolder(domBundle, content);
        content = BundleUtil.getResourceLocation(content, cfgElement);
        Document document = new IntroContentParser(content).getDocument();
        return document;
    }

    private String getBase(IConfigurationElement configElement) {
        String content = configElement.getAttribute(ATT_CONTENT);
        return ModelUtil.getParentFolderToString(content);
    }

    public String resolveVariables(String text) {
        if (this.configurer == null) {
            return text;
        }
        if (text.indexOf(36) == -1) {
            return text;
        }
        boolean inVariable = false;
        StringBuffer buf = new StringBuffer();
        int vindex = 0;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '$') {
                if (!inVariable) {
                    inVariable = true;
                    vindex = i + 1;
                } else {
                    inVariable = false;
                    String variable = text.substring(vindex, i);
                    String value = this.configurer.getVariable(variable);
                    if (value == null) {
                        value = "$" + variable + "$";
                    }
                    buf.append(value);
                }
            } else if (!inVariable) {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }
}

