/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.shared;

import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.eclipse.ui.internal.intro.shared.PageData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IntroData {
    private String productId;
    private Hashtable pages;
    private boolean active;

    public IntroData(String productId, String dataFile, boolean active) {
        this.productId = productId;
        this.active = active;
        this.initialize(dataFile);
    }

    public String getProductId() {
        return this.productId;
    }

    public boolean isActive() {
        return this.active;
    }

    private void initialize(String dataFile) {
        Document doc = this.parse(dataFile);
        if (doc == null) {
            return;
        }
        Element root = doc.getDocumentElement();
        NodeList pages = root.getChildNodes();
        int i = 0;
        while (i < pages.getLength()) {
            Node node = pages.item(i);
            if (node.getNodeType() == 1 && node.getNodeName().equals("page")) {
                this.loadPage((Element)node);
            }
            ++i;
        }
    }

    private void loadPage(Element page) {
        PageData pd = new PageData(page);
        this.pages.put(pd.getId(), pd);
    }

    private Document parse(String fileURI) {
        Document document = null;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setValidating(false);
            docFactory.setNamespaceAware(true);
            docFactory.setExpandEntityReferences(false);
            DocumentBuilder parser = docFactory.newDocumentBuilder();
            document = parser.parse(fileURI);
            return document;
        }
        catch (SAXParseException spe) {
            StringBuffer buffer = new StringBuffer("IntroData error in line ");
            buffer.append(spe.getLineNumber());
            buffer.append(", uri ");
            buffer.append(spe.getSystemId());
            buffer.append("\n");
            buffer.append(spe.getMessage());
            Exception x = spe;
            if (spe.getException() != null) {
                x = spe.getException();
            }
            Log.error(buffer.toString(), x);
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            Log.error(((Throwable)x).getMessage(), x);
        }
        catch (ParserConfigurationException pce) {
            Log.error(pce.getMessage(), pce);
        }
        catch (IOException ioe) {
            Log.error(ioe.getMessage(), ioe);
        }
        return null;
    }
}

