/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.core.runtime.internal.adaptor.CachedManifest;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.PluginConverterImpl;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.hooks.StorageHook;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.internal.baseadaptor.AdaptorUtil;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.pluginconversion.PluginConversionException;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public final class EclipseStorageHook
implements StorageHook,
HookConfigurator {
    private static final String PROP_CHECK_CONFIG = "osgi.checkConfiguration";
    private static final int STORAGE_VERION = 1;
    public static final String KEY;
    public static final int HASHCODE;
    private long manifestTimeStamp = 0L;
    private byte manifestType = 0;
    private BaseData bundledata;
    private String pluginClass = null;
    private boolean autoStart;
    private String[] autoStartExceptions;
    private String buddyList;
    private String registeredBuddyList;
    private boolean hasPackageInfo;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.runtime.internal.adaptor.EclipseStorageHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        KEY = clazz.getName();
        HASHCODE = KEY.hashCode();
    }

    public int getStorageVersion() {
        return 1;
    }

    public StorageHook create(BaseData bundledata) throws BundleException {
        EclipseStorageHook storageHook = new EclipseStorageHook();
        storageHook.bundledata = bundledata;
        return storageHook;
    }

    public void initialize(Dictionary manifest) throws BundleException {
        ManifestElement generatedFrom;
        String lazyStart = (String)manifest.get("Eclipse-LazyStart");
        if (lazyStart == null) {
            lazyStart = (String)manifest.get("Eclipse-AutoStart");
        }
        this.parseLazyStart(this, lazyStart);
        this.pluginClass = (String)manifest.get("Plugin-Class");
        this.buddyList = (String)manifest.get("Eclipse-BuddyPolicy");
        this.registeredBuddyList = (String)manifest.get("Eclipse-RegisterBuddy");
        this.hasPackageInfo = EclipseStorageHook.hasPackageInfo(this.bundledata.getEntry("META-INF/MANIFEST.MF"));
        String genFrom = (String)manifest.get("Generated-from");
        if (genFrom != null && (generatedFrom = ManifestElement.parseHeader("Generated-from", genFrom)[0]) != null) {
            this.manifestTimeStamp = Long.parseLong(generatedFrom.getValue());
            this.manifestType = Byte.parseByte(generatedFrom.getAttribute("type"));
        }
    }

    public StorageHook load(BaseData target, DataInputStream in) throws IOException {
        EclipseStorageHook storageHook = new EclipseStorageHook();
        storageHook.bundledata = target;
        storageHook.autoStart = in.readBoolean();
        int exceptionsCount = in.readInt();
        storageHook.autoStartExceptions = exceptionsCount > 0 ? new String[exceptionsCount] : null;
        int i = 0;
        while (i < exceptionsCount) {
            storageHook.autoStartExceptions[i] = in.readUTF();
            ++i;
        }
        storageHook.hasPackageInfo = in.readBoolean();
        storageHook.buddyList = AdaptorUtil.readString(in, false);
        storageHook.registeredBuddyList = AdaptorUtil.readString(in, false);
        storageHook.pluginClass = AdaptorUtil.readString(in, false);
        storageHook.manifestTimeStamp = in.readLong();
        storageHook.manifestType = in.readByte();
        return storageHook;
    }

    public void save(DataOutputStream out) throws IOException {
        if (this.bundledata == null) {
            throw new IllegalStateException();
        }
        out.writeBoolean(this.isAutoStart());
        String[] autoStartExceptions = this.getAutoStartExceptions();
        if (autoStartExceptions == null) {
            out.writeInt(0);
        } else {
            out.writeInt(autoStartExceptions.length);
            int i = 0;
            while (i < autoStartExceptions.length) {
                out.writeUTF(autoStartExceptions[i]);
                ++i;
            }
        }
        out.writeBoolean(this.hasPackageInfo());
        AdaptorUtil.writeStringOrNull(out, this.getBuddyList());
        AdaptorUtil.writeStringOrNull(out, this.getRegisteredBuddyList());
        AdaptorUtil.writeStringOrNull(out, this.getPluginClass());
        out.writeLong(this.getManifestTimeStamp());
        out.writeByte(this.getManifestType());
    }

    public int getKeyHashCode() {
        return HASHCODE;
    }

    public boolean compare(KeyedElement other) {
        return other.getKey() == KEY;
    }

    public Object getKey() {
        return KEY;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public String[] getAutoStartExceptions() {
        return this.autoStartExceptions;
    }

    public String getBuddyList() {
        return this.buddyList;
    }

    public boolean hasPackageInfo() {
        return this.hasPackageInfo;
    }

    public String getPluginClass() {
        return this.pluginClass;
    }

    public String getRegisteredBuddyList() {
        return this.registeredBuddyList;
    }

    public long getManifestTimeStamp() {
        return this.manifestTimeStamp;
    }

    public byte getManifestType() {
        return this.manifestType;
    }

    public boolean isAutoStartable() {
        return this.autoStart || this.autoStartExceptions != null && this.autoStartExceptions.length > 0;
    }

    private void parseLazyStart(EclipseStorageHook storageHook, String headerValue) {
        storageHook.autoStart = false;
        storageHook.autoStartExceptions = null;
        ManifestElement[] allElements = null;
        try {
            allElements = ManifestElement.parseHeader("Eclipse-LazyStart", headerValue);
        }
        catch (BundleException e) {
            String message = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CLASSLOADER_CANNOT_GET_HEADERS, storageHook.bundledata.getLocation());
            this.bundledata.getAdaptor().getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, message, 0, e, null));
        }
        if (allElements == null) {
            return;
        }
        storageHook.autoStart = "true".equalsIgnoreCase(allElements[0].getValue());
        String exceptionsValue = allElements[0].getAttribute("exceptions");
        if (exceptionsValue == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(exceptionsValue, ",");
        int numberOfTokens = tokenizer.countTokens();
        storageHook.autoStartExceptions = new String[numberOfTokens];
        int i = 0;
        while (i < numberOfTokens) {
            storageHook.autoStartExceptions[i] = tokenizer.nextToken().trim();
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    private static boolean hasPackageInfo(URL url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [3 : 134->137)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addStorageHook(this);
    }

    private void checkTimeStamp() throws IllegalArgumentException {
        if (!this.checkManifestTimeStamp()) {
            throw new IllegalArgumentException();
        }
    }

    private boolean checkManifestTimeStamp() {
        if (!"true".equalsIgnoreCase(FrameworkProperties.getProperty(PROP_CHECK_CONFIG))) {
            return true;
        }
        if (PluginConverterImpl.getTimeStamp(this.bundledata.getBundleFile().getBaseFile(), this.getManifestType()) == this.getManifestTimeStamp()) {
            if ((this.getManifestType() & 9) != 0) {
                return true;
            }
            String cacheLocation = FrameworkProperties.getProperty("osgi.manifest.cache");
            Location parentConfiguration = LocationManager.getConfigurationLocation().getParentLocation();
            if (parentConfiguration != null) {
                try {
                    return this.checkManifestAndParent(cacheLocation, this.bundledata.getSymbolicName(), this.bundledata.getVersion().toString(), this.getManifestType()) != null;
                }
                catch (BundleException bundleException) {
                    return false;
                }
            }
            File cacheFile = new File(cacheLocation, String.valueOf(this.bundledata.getSymbolicName()) + '_' + this.bundledata.getVersion() + ".MF");
            if (cacheFile.isFile()) {
                return true;
            }
        }
        return false;
    }

    private Headers checkManifestAndParent(String cacheLocation, String symbolicName, String version, byte inputType) throws BundleException {
        Headers result = this.basicCheckManifest(cacheLocation, symbolicName, version, inputType);
        if (result != null) {
            return result;
        }
        Location parentConfiguration = null;
        parentConfiguration = LocationManager.getConfigurationLocation().getParentLocation();
        if (parentConfiguration != null) {
            result = this.basicCheckManifest(new File(parentConfiguration.getURL().getFile(), "org.eclipse.osgi/manifests").toString(), symbolicName, version, inputType);
        }
        return result;
    }

    private Headers basicCheckManifest(String cacheLocation, String symbolicName, String version, byte inputType) throws BundleException {
        File currentFile = new File(cacheLocation, String.valueOf(symbolicName) + '_' + version + ".MF");
        if (PluginConverterImpl.upToDate(currentFile, this.bundledata.getBundleFile().getBaseFile(), inputType)) {
            try {
                return Headers.parseManifest(new FileInputStream(currentFile));
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return null;
    }

    Dictionary createCachedManifest(boolean firstTime) throws BundleException {
        return firstTime ? this.getGeneratedManifest() : new CachedManifest(this);
    }

    public Dictionary getGeneratedManifest() throws BundleException {
        Dictionary builtIn = AdaptorUtil.loadManifestFrom(this.bundledata);
        if (builtIn != null) {
            Dictionary generatedManifest;
            if (!this.isComplete(builtIn) && (generatedManifest = this.generateManifest(builtIn)) != null) {
                return generatedManifest;
            }
            this.manifestType = 1;
            if (this.bundledata.getBundleFile().getBaseFile().isFile()) {
                this.manifestTimeStamp = this.bundledata.getBundleFile().getBaseFile().lastModified();
                this.manifestType = (byte)(this.manifestType | 8);
            } else {
                this.manifestTimeStamp = this.bundledata.getBundleFile().getEntry("META-INF/MANIFEST.MF").getTime();
            }
            return builtIn;
        }
        Dictionary result = this.generateManifest(null);
        if (result == null) {
            throw new BundleException(NLS.bind(EclipseAdaptorMsg.ECLIPSE_DATA_MANIFEST_NOT_FOUND, this.bundledata.getLocation()));
        }
        return result;
    }

    private Dictionary generateManifest(Dictionary builtIn) throws BundleException {
        Dictionary generatedManifest;
        Headers existingHeaders;
        String cacheLocation = FrameworkProperties.getProperty("osgi.manifest.cache");
        if (this.bundledata.getSymbolicName() != null && (existingHeaders = this.checkManifestAndParent(cacheLocation, this.bundledata.getSymbolicName(), this.bundledata.getVersion().toString(), this.manifestType)) != null) {
            return existingHeaders;
        }
        PluginConverterImpl converter = PluginConverterImpl.getDefault();
        if (converter == null) {
            converter = new PluginConverterImpl(this.bundledata.getAdaptor(), this.bundledata.getAdaptor().getContext());
        }
        try {
            generatedManifest = converter.convertManifest(this.bundledata.getBundleFile().getBaseFile(), true, null, true, null);
        }
        catch (PluginConversionException pce) {
            String message = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONVERTER_ERROR_CONVERTING, this.bundledata.getBundleFile().getBaseFile());
            throw new BundleException(message, pce);
        }
        Version version = Version.parseVersion((String)generatedManifest.get("Bundle-Version"));
        String symbolicName = ManifestElement.parseHeader("Bundle-SymbolicName", (String)generatedManifest.get("Bundle-SymbolicName"))[0].getValue();
        ManifestElement generatedFrom = ManifestElement.parseHeader("Generated-from", (String)generatedManifest.get("Generated-from"))[0];
        Headers existingHeaders2 = this.checkManifestAndParent(cacheLocation, symbolicName, version.toString(), Byte.parseByte(generatedFrom.getAttribute("type")));
        this.manifestTimeStamp = Long.parseLong(generatedFrom.getValue());
        this.manifestType = Byte.parseByte(generatedFrom.getAttribute("type"));
        if (this.bundledata.getAdaptor().isReadOnly() || existingHeaders2 != null) {
            return existingHeaders2;
        }
        if (builtIn != null) {
            Enumeration keysEnum = builtIn.keys();
            while (keysEnum.hasMoreElements()) {
                Object key = keysEnum.nextElement();
                generatedManifest.put(key, builtIn.get(key));
            }
        }
        File bundleManifestLocation = new File(cacheLocation, String.valueOf(symbolicName) + '_' + version.toString() + ".MF");
        try {
            converter.writeManifest(bundleManifestLocation, generatedManifest, true);
        }
        catch (Exception exception) {}
        return generatedManifest;
    }

    private boolean isComplete(Dictionary manifest) {
        if (manifest.get("Bundle-SymbolicName") != null) {
            return true;
        }
        return this.bundledata.getEntry("plugin.xml") == null && this.bundledata.getEntry("fragment.xml") == null;
    }

    public BaseData getBaseData() {
        return this.bundledata;
    }

    public void copy(StorageHook storageHook) {
    }

    public void validate() throws IllegalArgumentException {
        this.checkTimeStamp();
    }

    public FrameworkAdaptor getAdaptor() {
        if (this.bundledata != null) {
            return this.bundledata.getAdaptor();
        }
        return null;
    }

    public Dictionary getManifest(boolean firstLoad) throws BundleException {
        return this.createCachedManifest(firstLoad);
    }

    public boolean forgetStatusChange(int status) {
        return this.isAutoStartable();
    }

    public boolean forgetStartLevelChange(int startlevel) {
        return false;
    }

    public boolean matchDNChain(String pattern) {
        return false;
    }
}

