/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.NestedDirBundleFile;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingStatsHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.FragmentClasspath;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.internal.baseadaptor.AdaptorMsg;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;

public class ClasspathManager {
    private static final FragmentClasspath[] emptyFragments = new FragmentClasspath[0];
    private static final int BUF_SIZE = 8192;
    private BaseData data;
    private String[] classpath;
    private ClasspathEntry[] entries;
    private BaseClassLoader classloader;
    private FragmentClasspath[] fragments = emptyFragments;

    public ClasspathManager(BaseData data, String[] classpath, BaseClassLoader classloader) {
        this.data = data;
        this.classpath = classpath;
        this.classloader = classloader;
    }

    public void initialize() {
        this.entries = ClasspathManager.buildClasspath(this.classpath, this, this.data, this.classloader.getDomain());
    }

    public void close() {
        int i;
        if (this.entries != null) {
            i = 0;
            while (i < this.entries.length) {
                if (this.entries[i] != null) {
                    try {
                        this.entries[i].getBundleFile().close();
                    }
                    catch (IOException e) {
                        this.data.getAdaptor().getEventPublisher().publishFrameworkEvent(2, this.data.getBundle(), e);
                    }
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.fragments.length) {
            this.fragments[i].close();
            ++i;
        }
    }

    public void attachFragment(BundleData sourcedata, ProtectionDomain sourcedomain, String[] sourceclasspath) {
        try {
            sourcedata.open();
        }
        catch (IOException e) {
            ((BaseData)sourcedata).getAdaptor().getEventPublisher().publishFrameworkEvent(2, ((BaseData)sourcedata).getBundle(), e);
        }
        ClasspathEntry[] fragEntries = ClasspathManager.buildClasspath(sourceclasspath, this, (BaseData)sourcedata, sourcedomain);
        FragmentClasspath fragClasspath = new FragmentClasspath((BaseData)sourcedata, fragEntries, sourcedomain);
        this.insertFragment(fragClasspath);
    }

    private synchronized void insertFragment(FragmentClasspath fragClasspath) {
        FragmentClasspath[] newFragments = new FragmentClasspath[this.fragments.length + 1];
        long fragID = fragClasspath.getBundleData().getBundleID();
        int insert = 0;
        int i = 0;
        while (i < this.fragments.length) {
            long otherID = this.fragments[i].getBundleData().getBundleID();
            if (insert == 0 && fragID < otherID) {
                newFragments[i] = fragClasspath;
                insert = 1;
            }
            newFragments[i + insert] = this.fragments[i];
            ++i;
        }
        if (insert == 0) {
            newFragments[this.fragments.length] = fragClasspath;
        }
        this.fragments = newFragments;
    }

    private static ClasspathEntry[] buildClasspath(String[] cp, ClasspathManager hostloader, BaseData sourcedata, ProtectionDomain sourcedomain) {
        ArrayList result = new ArrayList(cp.length);
        int i = 0;
        while (i < cp.length) {
            ClasspathManager.findClassPathEntry(result, cp[i], hostloader, sourcedata, sourcedomain);
            ++i;
        }
        return result.toArray(new ClasspathEntry[result.size()]);
    }

    public static void findClassPathEntry(ArrayList result, String cp, ClasspathManager hostloader, BaseData sourcedata, ProtectionDomain sourcedomain) {
        ClassLoadingHook[] loaderHooks = sourcedata.getAdaptor().getHookRegistry().getClassLoadingHooks();
        boolean hookAdded = false;
        int i = 0;
        while (i < loaderHooks.length) {
            hookAdded |= loaderHooks[i].addClassPathEntry(result, cp, hostloader, sourcedata, sourcedomain);
            ++i;
        }
        if (!ClasspathManager.addClassPathEntry(result, cp, hostloader, sourcedata, sourcedomain) && !hookAdded) {
            BundleException be = new BundleException(NLS.bind(AdaptorMsg.BUNDLE_CLASSPATH_ENTRY_NOT_FOUND_EXCEPTION, cp, sourcedata.getLocation()));
            sourcedata.getAdaptor().getEventPublisher().publishFrameworkEvent(32, sourcedata.getBundle(), be);
        }
    }

    public static boolean addClassPathEntry(ArrayList result, String cp, ClasspathManager hostloader, BaseData sourcedata, ProtectionDomain sourcedomain) {
        if (cp.equals(".")) {
            result.add(hostloader.createClassPathEntry(sourcedata.getBundleFile(), sourcedomain));
            return true;
        }
        ClasspathEntry element = hostloader.getClasspath(cp, sourcedata, sourcedomain);
        if (element != null) {
            result.add(element);
            return true;
        }
        if (hostloader.data == sourcedata) {
            int i = 0;
            while (i < hostloader.fragments.length) {
                FragmentClasspath fragCP = hostloader.fragments[i];
                element = hostloader.getClasspath(cp, fragCP.getBundleData(), fragCP.getDomain());
                if (element != null) {
                    result.add(element);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public ClasspathEntry getClasspath(String cp, BaseData sourcedata, ProtectionDomain sourcedomain) {
        BundleFile bundlefile = null;
        File file = sourcedata.getBundleFile().getFile(cp, false);
        if (file != null) {
            bundlefile = ClasspathManager.createBundleFile(file, sourcedata);
        }
        if (bundlefile == null && sourcedata.getBundleFile().containsDir(cp)) {
            bundlefile = new NestedDirBundleFile(sourcedata.getBundleFile(), cp);
        }
        if (bundlefile != null) {
            return this.createClassPathEntry(bundlefile, sourcedomain);
        }
        return null;
    }

    public ClasspathEntry getExternalClassPath(String cp, BaseData sourcedata, ProtectionDomain sourcedomain) {
        File file = new File(cp);
        if (!file.isAbsolute()) {
            return null;
        }
        BundleFile bundlefile = ClasspathManager.createBundleFile(file, sourcedata);
        if (bundlefile != null) {
            return this.createClassPathEntry(bundlefile, sourcedomain);
        }
        return null;
    }

    private static BundleFile createBundleFile(File file, BaseData sourcedata) {
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            return sourcedata.getAdaptor().createBundleFile(file, sourcedata);
        }
        catch (IOException e) {
            sourcedata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, sourcedata.getBundle(), e);
            return null;
        }
    }

    private ClasspathEntry createClassPathEntry(BundleFile bundlefile, ProtectionDomain cpDomain) {
        return this.classloader.createClassPathEntry(bundlefile, cpDomain);
    }

    /*
     * Unable to fully structure code
     */
    public URL findLocalResource(String resource) {
        hooks = this.data.getAdaptor().getHookRegistry().getClassLoadingStatsHooks();
        i = 0;
        while (i < hooks.length) {
            hooks[i].preFindLocalResource(resource, this);
            ++i;
        }
        result = null;
        try {
            var6_5 = result = this.findLocalResourceImpl(resource);
            var4_6 = null;
            i = 0;
            ** while (i < hooks.length)
        }
        catch (Throwable var5_10) {
            var4_7 = null;
            i = 0;
            ** while (i < hooks.length)
        }
lbl-1000:
        // 1 sources

        {
            hooks[i].postFindLocalResource(resource, result, this);
            ++i;
            continue;
        }
lbl17:
        // 1 sources

        return var6_5;
lbl-1000:
        // 1 sources

        {
            hooks[i].postFindLocalResource(resource, result, this);
            ++i;
            continue;
        }
lbl26:
        // 1 sources

        throw var5_10;
    }

    private URL findLocalResourceImpl(String resource) {
        URL result = null;
        int i = 0;
        while (i < this.entries.length) {
            if (this.entries[i] != null && (result = this.findResourceImpl(resource, this.entries[i].getBundleFile())) != null) {
                return result;
            }
            ++i;
        }
        i = 0;
        while (i < this.fragments.length) {
            ClasspathEntry[] fragEntries = this.fragments[i].getEntries();
            int j = 0;
            while (j < fragEntries.length) {
                result = this.findResourceImpl(resource, fragEntries[j].getBundleFile());
                if (result != null) {
                    return result;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public Enumeration findLocalResources(String resource) {
        Vector<URL> resources = new Vector<URL>(6);
        int i = 0;
        while (i < this.entries.length) {
            URL url;
            if (this.entries[i] != null && (url = this.findResourceImpl(resource, this.entries[i].getBundleFile(), resources.size())) != null) {
                resources.addElement(url);
            }
            ++i;
        }
        i = 0;
        while (i < this.fragments.length) {
            ClasspathEntry[] fragEntries = this.fragments[i].getEntries();
            int j = 0;
            while (j < fragEntries.length) {
                URL url = this.findResourceImpl(resource, fragEntries[j].getBundleFile(), resources.size());
                if (url != null) {
                    resources.addElement(url);
                }
                ++j;
            }
            ++i;
        }
        if (resources.size() > 0) {
            return resources.elements();
        }
        return null;
    }

    private URL findResourceImpl(String name, BundleFile bundlefile) {
        return this.findResourceImpl(name, bundlefile, 0);
    }

    private URL findResourceImpl(String name, BundleFile bundlefile, int index) {
        return bundlefile.getResourceURL(name, this.data.getBundleID(), index);
    }

    public BundleEntry findLocalEntry(String path) {
        BundleEntry result = null;
        int i = 0;
        while (i < this.entries.length) {
            if (this.entries[i] != null && (result = this.findEntryImpl(path, this.entries[i].getBundleFile())) != null) {
                return result;
            }
            ++i;
        }
        i = 0;
        while (i < this.fragments.length) {
            ClasspathEntry[] fragEntries = this.fragments[i].getEntries();
            int j = 0;
            while (j < fragEntries.length) {
                result = this.findEntryImpl(path, fragEntries[j].getBundleFile());
                if (result != null) {
                    return result;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public Enumeration findLocalEntries(String path) {
        Vector<BundleEntry> objects = new Vector<BundleEntry>(6);
        int i = 0;
        while (i < this.entries.length) {
            BundleEntry result;
            if (this.entries[i] != null && (result = this.findEntryImpl(path, this.entries[i].getBundleFile())) != null) {
                objects.addElement(result);
            }
            ++i;
        }
        i = 0;
        while (i < this.fragments.length) {
            ClasspathEntry[] fragEntries = this.fragments[i].getEntries();
            int j = 0;
            while (j < fragEntries.length) {
                BundleEntry result = this.findEntryImpl(path, fragEntries[j].getBundleFile());
                if (result != null) {
                    objects.addElement(result);
                }
                ++j;
            }
            ++i;
        }
        if (objects.size() > 0) {
            return objects.elements();
        }
        return null;
    }

    private BundleEntry findEntryImpl(String path, BundleFile bundleFile) {
        return bundleFile.getEntry(path);
    }

    /*
     * Unable to fully structure code
     */
    public Class findLocalClass(String classname) throws ClassNotFoundException {
        result = null;
        hooks = this.data.getAdaptor().getHookRegistry().getClassLoadingStatsHooks();
        try {
            i = 0;
            while (i < hooks.length) {
                hooks[i].preFindLocalClass(classname, this);
                ++i;
            }
            var7_5 = result = this.findLocalClassImpl(classname, hooks);
            var5_6 = null;
            i = 0;
            ** while (i < hooks.length)
        }
        catch (Throwable var6_10) {
            var5_7 = null;
            i = 0;
            ** while (i < hooks.length)
        }
lbl-1000:
        // 1 sources

        {
            hooks[i].postFindLocalClass(classname, result, this);
            ++i;
            continue;
        }
lbl17:
        // 1 sources

        return var7_5;
lbl-1000:
        // 1 sources

        {
            hooks[i].postFindLocalClass(classname, result, this);
            ++i;
            continue;
        }
lbl26:
        // 1 sources

        throw var6_10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class findLocalClassImpl(String classname, ClassLoadingStatsHook[] hooks) throws ClassNotFoundException {
        BaseClassLoader baseClassLoader = this.classloader;
        synchronized (baseClassLoader) {
            Class result = this.classloader.publicFindLoaded(classname);
            if (result != null) {
                return result;
            }
            int i = 0;
            while (i < this.entries.length) {
                if (this.entries[i] != null && (result = this.findClassImpl(classname, this.entries[i], hooks)) != null) {
                    return result;
                }
                ++i;
            }
            i = 0;
            while (i < this.fragments.length) {
                ClasspathEntry[] fragEntries = this.fragments[i].getEntries();
                int j = 0;
                while (j < fragEntries.length) {
                    result = this.findClassImpl(classname, fragEntries[j], hooks);
                    if (result != null) {
                        return result;
                    }
                    ++j;
                }
                ++i;
            }
        }
        throw new ClassNotFoundException(classname);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class findClassImpl(String name, ClasspathEntry classpathEntry, ClassLoadingStatsHook[] hooks) {
        byte[] classbytes;
        InputStream in;
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleClassLoader[" + this.data + "].findClass(" + name + ")");
        }
        String filename = name.replace('.', '/').concat(".class");
        BundleEntry entry = classpathEntry.getBundleFile().getEntry(filename);
        if (entry == null) {
            return null;
        }
        try {
            in = entry.getInputStream();
        }
        catch (IOException iOException) {
            return null;
        }
        int length = (int)entry.getSize();
        int bytesread = 0;
        if (Debug.DEBUG_LOADER) {
            Debug.println("  about to read " + length + " bytes from " + filename);
        }
        try {
            try {
                byte[] oldbytes;
                int readcount;
                if (length > 0) {
                    classbytes = new byte[length];
                    while (bytesread < length && (readcount = in.read(classbytes, bytesread, length - bytesread)) > 0) {
                        bytesread += readcount;
                    }
                } else {
                    length = 8192;
                    classbytes = new byte[length];
                    while (true) {
                        if (bytesread >= length) {
                            oldbytes = classbytes;
                            classbytes = new byte[length += 8192];
                            System.arraycopy(oldbytes, 0, classbytes, 0, bytesread);
                            continue;
                        }
                        readcount = in.read(classbytes, bytesread, length - bytesread);
                        if (readcount <= 0) break;
                        bytesread += readcount;
                    }
                }
                if (classbytes.length > bytesread) {
                    oldbytes = classbytes;
                    classbytes = new byte[bytesread];
                    System.arraycopy(oldbytes, 0, classbytes, 0, bytesread);
                }
            }
            catch (IOException iOException) {
                if (Debug.DEBUG_LOADER) {
                    Debug.println("  IOException reading " + filename + " from " + this.data);
                }
                Class clazz = null;
                Object var12_14 = null;
                try {
                    in.close();
                    return clazz;
                }
                catch (IOException iOException2) {}
                return clazz;
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            try {}
            catch (IOException iOException) {}
            in.close();
            throw throwable;
            throw throwable;
        }
        {
            Object var12_16 = null;
        }
        try {}
        catch (IOException iOException) {}
        in.close();
        if (Debug.DEBUG_LOADER) {
            Debug.println("  read " + bytesread + " bytes from " + filename);
            Debug.println("  defining class " + name);
        }
        try {
            Class result = this.defineClass(name, classbytes, classpathEntry, entry);
            int i = 0;
            while (true) {
                if (i >= hooks.length) {
                    return result;
                }
                hooks[i].recordClassDefine(name, result, classbytes, classpathEntry, entry, this);
                ++i;
            }
        }
        catch (Error e) {
            if (!Debug.DEBUG_LOADER) throw e;
            Debug.println("  error defining class " + name);
            throw e;
        }
    }

    private Class defineClass(String name, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry) {
        ClassLoadingHook[] hooks = this.data.getAdaptor().getHookRegistry().getClassLoadingHooks();
        byte[] modifiedBytes = classbytes;
        int i = 0;
        while (i < hooks.length) {
            modifiedBytes = hooks[i].processClass(name, classbytes, classpathEntry, entry, this);
            if (modifiedBytes != null) {
                classbytes = modifiedBytes;
            }
            ++i;
        }
        return this.classloader.defineClass(name, classbytes, classpathEntry, entry);
    }

    public BaseData getBaseData() {
        return this.data;
    }

    public FragmentClasspath[] getFragmentClasspaths() {
        return this.fragments;
    }

    public ClasspathEntry[] getHostClasspathEntries() {
        return this.entries;
    }

    public BaseClassLoader getBaseClassLoader() {
        return this.classloader;
    }
}

