/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor;

import java.io.File;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.internal.baseadaptor.BaseStorageHook;

public class BaseClassLoadingHook
implements ClassLoadingHook {
    public String findLibrary(BaseData data, String libName) {
        String mappedName = System.mapLibraryName(libName);
        String path = null;
        if (Debug.DEBUG_LOADER) {
            Debug.println("  mapped library name: " + mappedName);
        }
        if ((path = this.findNativePath(data, mappedName)) == null) {
            if (Debug.DEBUG_LOADER) {
                Debug.println("  library does not exist: " + mappedName);
            }
            path = this.findNativePath(data, libName);
        }
        if (Debug.DEBUG_LOADER) {
            Debug.println("  returning library: " + path);
        }
        return path;
    }

    private String findNativePath(BaseData bundledata, String libname) {
        String[] nativepaths;
        int slash = libname.lastIndexOf(47);
        if (slash >= 0) {
            libname = libname.substring(slash + 1);
        }
        if ((nativepaths = this.getNativePaths(bundledata)) == null) {
            return null;
        }
        int i = 0;
        while (i < nativepaths.length) {
            File nativeFile;
            String path;
            slash = nativepaths[i].lastIndexOf(47);
            String string = path = slash < 0 ? nativepaths[i] : nativepaths[i].substring(slash + 1);
            if (path.equals(libname) && (nativeFile = bundledata.getBundleFile().getFile(nativepaths[i], true)) != null) {
                return nativeFile.getAbsolutePath();
            }
            ++i;
        }
        return null;
    }

    private String[] getNativePaths(BaseData bundledata) {
        BaseStorageHook storageHook = (BaseStorageHook)bundledata.getStorageHook(BaseStorageHook.KEY);
        return storageHook != null ? storageHook.getNativePaths() : null;
    }

    public boolean addClassPathEntry(ArrayList cpEntries, String cp, ClasspathManager hostmanager, BaseData sourcedata, ProtectionDomain sourcedomain) {
        return false;
    }

    public ClassLoader getBundleClassLoaderParent() {
        return null;
    }

    public byte[] processClass(String name, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        return null;
    }

    public BaseClassLoader createClassLoader(ClassLoader parent, ClassLoaderDelegate delegate, BundleProtectionDomain domain, BaseData data, String[] bundleclasspath) {
        return null;
    }

    public void initializedClassLoader(BaseClassLoader baseClassLoader, BaseData data) {
    }
}

