/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding;

import java.util.HashMap;
import org.eclipse.jface.databinding.BindingException;
import org.eclipse.jface.internal.databinding.beans.PropertyHelper;

public class TreeModelDescription {
    private HashMap childrenProperties = new HashMap();
    private Class[] types = new Class[0];
    private Object root;

    public TreeModelDescription(Object root) {
        this.root = root;
    }

    public void addChildrenProperty(Class instanceType, String childrenProperty) {
        PropertyHelper prop = new PropertyHelper(childrenProperty, instanceType);
        if (prop.getGetter() == null) {
            throw new BindingException("Invalid children property: " + childrenProperty);
        }
        this.addType(instanceType);
        this.childrenProperties.put(instanceType, this.addProperty(childrenProperty, (String[])this.childrenProperties.get(instanceType)));
    }

    private String[] addProperty(String property, String[] list) {
        if (list == null) {
            return new String[]{property};
        }
        int i = 0;
        while (i < list.length) {
            if (list[i].equals(property)) {
                return list;
            }
            ++i;
        }
        String[] newList = new String[list.length + 1];
        System.arraycopy(list, 0, newList, 0, list.length);
        newList[list.length] = property;
        return newList;
    }

    private String[] addProperties(String[] properties, String[] list) {
        String[] result = list;
        int i = 0;
        while (i < properties.length) {
            result = this.addProperty(properties[i], result);
            ++i;
        }
        return result;
    }

    private void addType(Class instanceType) {
        int i = 0;
        while (i < this.types.length) {
            if (this.types[i] == instanceType) {
                return;
            }
            ++i;
        }
        Class[] newTypes = new Class[this.types.length + 1];
        System.arraycopy(this.types, 0, newTypes, 0, this.types.length);
        newTypes[this.types.length] = instanceType;
        this.types = newTypes;
    }

    public String[] getChildrenProperties(Class instanceType) {
        String[] properties = null;
        int i = 0;
        while (i < this.types.length) {
            if (this.types[i].isAssignableFrom(instanceType)) {
                String[] props = (String[])this.childrenProperties.get(this.types[i]);
                properties = this.addProperties(props, properties);
            }
            ++i;
        }
        return properties;
    }

    public Class[] getTypes() {
        return this.types;
    }

    public Object getRoot() {
        return this.root;
    }
}

