/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.databinding.BindingEvent;
import org.eclipse.jface.databinding.ChangeEvent;
import org.eclipse.jface.databinding.IBinding;
import org.eclipse.jface.databinding.IBindingListener;
import org.eclipse.jface.internal.databinding.DataBindingContext;

public abstract class Binding
implements IBinding {
    protected final DataBindingContext context;
    private List bindingEventListeners = new ArrayList();

    public Binding(DataBindingContext context) {
        this.context = context;
    }

    public abstract void updateTargetFromModel(ChangeEvent var1);

    public void addBindingEventListener(IBindingListener listener) {
        this.bindingEventListeners.add(listener);
    }

    public void removeBindingEventListener(IBindingListener listener) {
        this.bindingEventListeners.remove(listener);
    }

    protected String fireBindingEvent(BindingEvent event) {
        String result = null;
        Iterator bindingEventIter = this.bindingEventListeners.iterator();
        while (bindingEventIter.hasNext()) {
            IBindingListener listener = (IBindingListener)bindingEventIter.next();
            result = listener.bindingEvent(event);
            if (result != null) break;
        }
        if (result == null) {
            result = this.context.fireBindingEvent(event);
        }
        return result;
    }
}

