/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding;

import org.eclipse.jface.databinding.ChangeEvent;
import org.eclipse.jface.databinding.IChangeListener;
import org.eclipse.jface.databinding.IDataBindingContext;
import org.eclipse.jface.databinding.IUpdatableCollection;
import org.eclipse.jface.databinding.IUpdatableValue;
import org.eclipse.jface.databinding.Property;
import org.eclipse.jface.databinding.UpdatableCollection;
import org.eclipse.jface.util.Assert;

public class NestedUpdatableCollection
extends UpdatableCollection {
    private boolean updating = false;
    private IChangeListener innerChangeListener = new IChangeListener(){

        public void handleChange(ChangeEvent changeEvent) {
            ChangeEvent nestedEvent;
            if (!NestedUpdatableCollection.this.updating && (nestedEvent = NestedUpdatableCollection.this.fireChangeEvent(changeEvent.getChangeType(), changeEvent.getOldValue(), changeEvent.getNewValue(), changeEvent.getParent(), changeEvent.getPosition())).getVeto()) {
                changeEvent.setVeto(true);
            }
        }
    };
    private Object currentOuterValue;
    private Object feature;
    private IUpdatableCollection innerUpdatableCollection;
    private IDataBindingContext databindingContext;
    private Class elementType;

    public NestedUpdatableCollection(IDataBindingContext databindingContext, final IUpdatableValue outerUpdatableValue, Object feature, Class elementType) {
        this.databindingContext = databindingContext;
        this.feature = feature;
        this.elementType = elementType;
        this.updateInnerUpdatableValue(outerUpdatableValue);
        IChangeListener outerChangeListener = new IChangeListener(){

            public void handleChange(ChangeEvent changeEvent) {
                if ((changeEvent.getChangeType() & 0x307) != 0) {
                    NestedUpdatableCollection.this.updateInnerUpdatableValue(outerUpdatableValue);
                    NestedUpdatableCollection.this.fireChangeEvent(1, null, null);
                }
            }
        };
        outerUpdatableValue.addChangeListener(outerChangeListener);
    }

    private void updateInnerUpdatableValue(IUpdatableValue outerUpdatableValue) {
        this.currentOuterValue = outerUpdatableValue.getValue();
        if (this.innerUpdatableCollection != null) {
            this.innerUpdatableCollection.removeChangeListener(this.innerChangeListener);
            this.innerUpdatableCollection.dispose();
        }
        if (this.currentOuterValue == null) {
            this.innerUpdatableCollection = null;
        } else {
            this.innerUpdatableCollection = (IUpdatableCollection)this.databindingContext.createUpdatable(new Property(this.currentOuterValue, this.feature, this.elementType, Boolean.TRUE));
            Class innerElementType = this.innerUpdatableCollection.getElementType();
            if (this.elementType == null) {
                this.elementType = innerElementType;
            } else {
                Assert.isTrue((boolean)this.elementType.equals(innerElementType), (String)"Cannot change element type in a nested updatable collection");
            }
            this.innerUpdatableCollection.addChangeListener(this.innerChangeListener);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.innerUpdatableCollection != null) {
            this.innerUpdatableCollection.dispose();
        }
        this.currentOuterValue = null;
        this.databindingContext = null;
        this.feature = null;
        this.innerUpdatableCollection = null;
        this.innerChangeListener = null;
    }

    public int computeSize() {
        return this.innerUpdatableCollection == null ? 0 : this.innerUpdatableCollection.getSize();
    }

    public int addElement(Object value, int index) {
        return this.innerUpdatableCollection.addElement(value, index);
    }

    public void removeElement(int index) {
        this.innerUpdatableCollection.removeElement(index);
    }

    public void setElement(int index, Object value) {
        this.innerUpdatableCollection.setElement(index, value);
    }

    public Object computeElement(int index) {
        return this.innerUpdatableCollection.getElement(index);
    }

    public Class getElementType() {
        return this.elementType;
    }
}

