/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding;

import org.eclipse.jface.databinding.BindingEvent;
import org.eclipse.jface.databinding.BindingException;
import org.eclipse.jface.databinding.ChangeEvent;
import org.eclipse.jface.databinding.IBindSpec;
import org.eclipse.jface.databinding.IChangeListener;
import org.eclipse.jface.databinding.IUpdatableValue;
import org.eclipse.jface.databinding.converter.IConverter;
import org.eclipse.jface.databinding.validator.IValidator;
import org.eclipse.jface.internal.databinding.Binding;
import org.eclipse.jface.internal.databinding.BindingMessages;
import org.eclipse.jface.internal.databinding.DataBindingContext;

public class ValueBinding
extends Binding {
    private final IUpdatableValue target;
    private final IUpdatableValue model;
    private IValidator validator;
    private IConverter converter;
    private boolean updating = false;
    private final IChangeListener targetChangeListener = new IChangeListener(){

        public void handleChange(ChangeEvent changeEvent) {
            if (ValueBinding.this.updating) {
                return;
            }
            if (changeEvent.getChangeType() == 8) {
                Object value = changeEvent.getNewValue();
                String partialValidationError = ValueBinding.this.validator.isPartiallyValid(value);
                ValueBinding.this.context.updatePartialValidationError(this, partialValidationError);
                if (partialValidationError != null) {
                    changeEvent.setVeto(true);
                }
            } else if (changeEvent.getChangeType() == 1) {
                ValueBinding.this.updateModelFromTarget(changeEvent);
            }
        }
    };
    private IChangeListener modelChangeListener = new IChangeListener(){

        public void handleChange(ChangeEvent changeEvent) {
            if (ValueBinding.this.updating) {
                return;
            }
            if (changeEvent.getChangeType() != 8 && changeEvent.getChangeType() == 1) {
                ValueBinding.this.updateTargetFromModel(changeEvent);
            }
        }
    };

    public ValueBinding(DataBindingContext context, IUpdatableValue target, IUpdatableValue model, IBindSpec bindSpec) {
        super(context);
        this.target = target;
        this.model = model;
        this.converter = bindSpec.getConverter();
        if (this.converter == null) {
            throw new BindingException("Missing converter from " + target.getValueType() + " to " + model.getValueType());
        }
        if (!this.converter.getModelType().isAssignableFrom(model.getValueType())) {
            throw new BindingException("Converter does not apply to model type. Expected: " + model.getValueType() + ", actual: " + this.converter.getModelType());
        }
        if (!this.converter.getTargetType().isAssignableFrom(target.getValueType())) {
            throw new BindingException("Converter does not apply to target type. Expected: " + target.getValueType() + ", actual: " + this.converter.getTargetType());
        }
        this.validator = bindSpec.getValidator();
        if (this.validator == null) {
            throw new BindingException("Missing validator");
        }
        target.addChangeListener(this.targetChangeListener);
        model.addChangeListener(this.modelChangeListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateModelFromTarget(ChangeEvent changeEvent) {
        block11: {
            block10: {
                BindingEvent e = new BindingEvent(changeEvent, 1, 0);
                e.originalValue = this.target.getValue();
                if (this.failure(this.errMsg(this.fireBindingEvent(e)))) {
                    return;
                }
                String validationError = this.doValidate(e.originalValue);
                if (validationError != null) {
                    this.context.updatePartialValidationError(this.targetChangeListener, validationError);
                    return;
                }
                e.pipelinePosition = 1;
                if (this.failure(this.errMsg(this.fireBindingEvent(e)))) {
                    return;
                }
                try {
                    try {
                        this.updating = true;
                        e.convertedValue = this.converter.convertTargetToModel(e.originalValue);
                        e.pipelinePosition = 2;
                        if (this.failure(this.errMsg(this.fireBindingEvent(e)))) {
                            Object var4_4 = null;
                            this.updating = false;
                            return;
                        }
                        e.pipelinePosition = 3;
                        if (this.failure(this.errMsg(this.fireBindingEvent(e)))) {
                            break block10;
                        }
                        this.model.setValue(e.convertedValue);
                        e.pipelinePosition = 4;
                        this.fireBindingEvent(e);
                    }
                    catch (Exception exception) {
                        this.context.updateValidationError(this.targetChangeListener, BindingMessages.getString("ValueBinding_ErrorWhileSettingValue"));
                    }
                    break block11;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    this.updating = false;
                    throw throwable;
                }
            }
            Object var4_5 = null;
            this.updating = false;
            return;
        }
        Object var4_7 = null;
        this.updating = false;
    }

    private String doValidate(Object value) {
        String validationError = this.validator.isValid(value);
        return this.errMsg(validationError);
    }

    private String errMsg(String validationError) {
        this.context.updatePartialValidationError(this.targetChangeListener, null);
        this.context.updateValidationError(this.targetChangeListener, validationError);
        return validationError;
    }

    private boolean failure(String errorMessage) {
        return errorMessage != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateTargetFromModel(ChangeEvent changeEvent) {
        block8: {
            block7: {
                block6: {
                    try {
                        this.updating = true;
                        BindingEvent e = new BindingEvent(changeEvent, 0, 0);
                        e.originalValue = this.model.getValue();
                        if (this.failure(this.errMsg(this.fireBindingEvent(e)))) {
                            Object var3_3 = null;
                            this.updating = false;
                            return;
                        }
                        e.convertedValue = this.converter.convertModelToTarget(e.originalValue);
                        e.pipelinePosition = 2;
                        if (this.failure(this.errMsg(this.fireBindingEvent(e)))) {
                            break block6;
                        }
                        this.target.setValue(e.convertedValue);
                        e.pipelinePosition = 4;
                        if (this.failure(this.errMsg(this.fireBindingEvent(e)))) {
                            break block7;
                        }
                        this.doValidate(this.target.getValue());
                        e.pipelinePosition = 1;
                        this.fireBindingEvent(e);
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var3_6 = null;
                        this.updating = false;
                        throw throwable;
                    }
                }
                Object var3_4 = null;
                this.updating = false;
                return;
            }
            Object var3_5 = null;
            this.updating = false;
            return;
        }
        Object var3_7 = null;
        this.updating = false;
    }
}

