/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.jface.databinding.BindingException;
import org.eclipse.jface.databinding.UpdatableValue;

public class JavaBeanUpdatableValue
extends UpdatableValue {
    private final Object object;
    private PropertyChangeListener listener;
    private boolean updating = false;
    private final PropertyDescriptor propertyDescriptor;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public JavaBeanUpdatableValue(Object object, PropertyDescriptor descriptor) {
        this.object = object;
        this.propertyDescriptor = descriptor;
        this.hookListener(descriptor.getName());
    }

    private void hookListener(String propertyName) {
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (!JavaBeanUpdatableValue.this.updating) {
                    JavaBeanUpdatableValue.this.fireChangeEvent(1, event.getOldValue(), event.getNewValue());
                }
            }
        };
        Method addPropertyChangeListenerMethod = null;
        try {
            Class<?> clazz = this.object.getClass();
            Class[] classArray = new Class[2];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.beans.PropertyChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz3;
            addPropertyChangeListenerMethod = clazz.getMethod("addPropertyChangeListener", classArray);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (addPropertyChangeListenerMethod != null) {
            try {
                addPropertyChangeListenerMethod.invoke(this.object, propertyName, this.listener);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        this.listener = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setValue(Object value) {
        this.updating = true;
        try {
            try {
                Object oldValue = this.computeValue();
                Method writeMethod = this.propertyDescriptor.getWriteMethod();
                if (!writeMethod.isAccessible()) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(this.object, value);
                this.fireChangeEvent(1, oldValue, this.computeValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.updating = false;
            throw throwable;
        }
        {
            Object var4_7 = null;
            this.updating = false;
            return;
        }
    }

    public Object computeValue() {
        try {
            Method readMethod = this.propertyDescriptor.getReadMethod();
            if (readMethod == null) {
                throw new BindingException(String.valueOf(this.propertyDescriptor.getName()) + " property does not have a read method.");
            }
            if (!readMethod.isAccessible()) {
                readMethod.setAccessible(true);
            }
            return readMethod.invoke(this.object, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            Method removePropertyChangeListenerMethod = null;
            try {
                Class<?> clazz = this.object.getClass();
                Class[] classArray = new Class[2];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$1 = Class.forName("java.beans.PropertyChangeListener");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz3;
                removePropertyChangeListenerMethod = clazz.getMethod("removePropertyChangeListener", classArray);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            if (removePropertyChangeListenerMethod != null) {
                try {
                    removePropertyChangeListenerMethod.invoke(this.object, this.propertyDescriptor.getName(), this.listener);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            this.listener = null;
        }
    }

    public Class getValueType() {
        return this.propertyDescriptor.getPropertyType();
    }
}

