/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.databinding.AbstractUpdatableSet;
import org.eclipse.jface.databinding.IReadableSet;
import org.eclipse.jface.internal.databinding.beans.ListenerSupport;
import org.eclipse.jface.util.Assert;

public class JavaBeansReadableSet
extends AbstractUpdatableSet
implements IReadableSet {
    private final Object object;
    private Set elements;
    private PropertyChangeListener collectionListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (!JavaBeansReadableSet.this.updating && JavaBeansReadableSet.this.descriptor.getName().equals(event.getPropertyName())) {
                HashSet<Object> newElements = new HashSet<Object>(Arrays.asList(JavaBeansReadableSet.this.getValues()));
                HashSet<Object> addedElements = new HashSet<Object>(newElements);
                HashSet removedElements = new HashSet(JavaBeansReadableSet.this.elements);
                removedElements.removeAll(newElements);
                addedElements.removeAll(JavaBeansReadableSet.this.elements);
                JavaBeansReadableSet.this.elements.addAll(addedElements);
                JavaBeansReadableSet.this.fireAdded(addedElements);
                JavaBeansReadableSet.this.elements = newElements;
                JavaBeansReadableSet.this.fireRemoved(removedElements);
            }
        }
    };
    private boolean updating = false;
    private PropertyDescriptor descriptor;
    private Class elementType = null;
    private ListenerSupport collectionListenSupport = new ListenerSupport(this.collectionListener);

    protected Collection computeElements() {
        return Collections.unmodifiableSet(this.elements);
    }

    public JavaBeansReadableSet(Object object, PropertyDescriptor descriptor, Class elementType) {
        this.object = object;
        this.descriptor = descriptor;
        this.elementType = elementType;
        this.collectionListenSupport.hookListener(this.object);
        this.elements = new HashSet<Object>(Arrays.asList(this.getValues()));
    }

    public void dispose() {
        super.dispose();
        this.collectionListenSupport.dispose();
    }

    private Object primGetValues() {
        try {
            Method readMethod = this.descriptor.getReadMethod();
            if (!readMethod.isAccessible()) {
                readMethod.setAccessible(true);
            }
            return readMethod.invoke(this.object, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        Assert.isTrue((boolean)false, (String)"Could not read collection values");
        return null;
    }

    private Object[] getValues() {
        Collection list;
        Object[] values = null;
        Object result = this.primGetValues();
        values = this.descriptor.getPropertyType().isArray() ? (Object[])result : ((list = (Collection)result) != null ? list.toArray() : new Object[]{});
        return values;
    }
}

