/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.swt;

import org.eclipse.jface.databinding.BindingException;
import org.eclipse.jface.databinding.SelectionAwareUpdatableCollection;
import org.eclipse.jface.internal.databinding.swt.SyncRunnable;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;

public class ComboUpdatableCollection
extends SelectionAwareUpdatableCollection {
    private final Combo combo;
    private final String attribute;
    private boolean updating = false;
    static /* synthetic */ Class class$0;

    public ComboUpdatableCollection(Combo combo, String attribute) {
        this.combo = combo;
        this.attribute = attribute.equals("content") ? "items" : attribute;
        if (!this.attribute.equals("items")) {
            throw new IllegalArgumentException();
        }
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ComboUpdatableCollection.this.updating) {
                    ComboUpdatableCollection.this.fireChangeEvent(1, null, null);
                }
            }
        });
    }

    public int computeSize() {
        return this.combo.getItemCount();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addElement(Object value, int index) {
        this.updating = true;
        try {
            if (index < 0 || index > this.computeSize()) {
                index = this.computeSize();
            }
            String[] newItems = new String[this.computeSize() + 1];
            System.arraycopy(this.combo.getItems(), 0, newItems, 0, index);
            newItems[index] = (String)value;
            System.arraycopy(this.combo.getItems(), index, newItems, index + 1, this.computeSize() - index);
            this.combo.setItems(newItems);
            this.fireChangeEvent(2, null, value, index);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.updating = false;
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.updating = false;
            return index;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeElement(int index) {
        this.updating = true;
        try {
            if (index < 0) throw new BindingException("Request to remove an element out of the collection bounds");
            if (index > this.computeSize() - 1) {
                throw new BindingException("Request to remove an element out of the collection bounds");
            }
            String[] newItems = new String[this.computeSize() - 1];
            String old = this.combo.getItem(index);
            System.arraycopy(this.combo.getItems(), 0, newItems, 0, index);
            if (newItems.length > 0) {
                System.arraycopy(this.combo.getItems(), 0, newItems, 0, index);
                if (this.computeSize() - 1 > index) {
                    System.arraycopy(this.combo.getItems(), index + 1, newItems, index, this.computeSize() - index - 1);
                }
            }
            this.combo.setItems(newItems);
            this.fireChangeEvent(4, old, null, index);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.updating = false;
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.updating = false;
            return;
        }
    }

    public void setElement(int index, Object value) {
        String old = this.combo.getItem(index);
        this.combo.setItem(index, (String)value);
        this.fireChangeEvent(1, old, value, index);
    }

    public Object computeElement(int index) {
        return this.combo.getItem(index);
    }

    public Class getElementType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Object getSelectedObject() {
        SyncRunnable runnable = new SyncRunnable(){

            public Object run() {
                int index = ComboUpdatableCollection.this.combo.getSelectionIndex();
                if (index > -1) {
                    return ComboUpdatableCollection.this.combo.getItem(index);
                }
                return null;
            }
        };
        return runnable.runOn(this.combo.getDisplay());
    }

    public void setSelectedObject(final Object object) {
        SyncRunnable runnable = new SyncRunnable(){

            public Object run() {
                if (object == null) {
                    ComboUpdatableCollection.this.combo.deselectAll();
                } else {
                    int index = ComboUpdatableCollection.this.combo.indexOf((String)object);
                    if (index != -1) {
                        ComboUpdatableCollection.this.combo.select(index);
                    }
                }
                return null;
            }
        };
        runnable.runOn(this.combo.getDisplay());
    }
}

