/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import org.eclipse.jface.databinding.UpdatableValue;
import org.eclipse.jface.internal.databinding.swt.AsyncRunnable;
import org.eclipse.jface.internal.databinding.swt.SyncRunnable;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;

public class StructuredViewerUpdatableValue
extends UpdatableValue {
    private final StructuredViewer viewer;
    private final String attribute;
    private boolean updating = false;
    static /* synthetic */ Class class$0;

    public StructuredViewerUpdatableValue(StructuredViewer viewer, String attribute) {
        this.viewer = viewer;
        this.attribute = attribute;
        if (!attribute.equals("single_selection")) {
            throw new IllegalArgumentException("Attribute name not valid: " + attribute);
        }
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!StructuredViewerUpdatableValue.this.updating) {
                    StructuredViewerUpdatableValue.this.fireChangeEvent(1, null, StructuredViewerUpdatableValue.this.computeValue());
                }
            }
        });
    }

    public void setValue(final Object value) {
        AsyncRunnable runnable = new AsyncRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    StructuredViewerUpdatableValue.this.updating = true;
                    if (StructuredViewerUpdatableValue.this.attribute.equals("single_selection")) {
                        Object oldValue = StructuredViewerUpdatableValue.this.computeValue();
                        StructuredViewerUpdatableValue.this.viewer.setSelection((ISelection)(value == null ? StructuredSelection.EMPTY : new StructuredSelection(value)));
                        StructuredViewerUpdatableValue.this.fireChangeEvent(1, oldValue, StructuredViewerUpdatableValue.this.computeValue());
                    }
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    StructuredViewerUpdatableValue.this.updating = false;
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                }
                StructuredViewerUpdatableValue.this.updating = false;
            }
        };
        runnable.runOn(this.viewer.getControl().getDisplay());
    }

    public Object computeValue() {
        SyncRunnable runnable = new SyncRunnable(){

            public Object run() {
                ISelection selection;
                if (StructuredViewerUpdatableValue.this.attribute.equals("single_selection") && (selection = StructuredViewerUpdatableValue.this.viewer.getSelection()) instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)selection;
                    return sel.getFirstElement();
                }
                return null;
            }
        };
        return runnable.runOn(this.viewer.getControl().getDisplay());
    }

    public Class getValueType() {
        Assert.isTrue((boolean)this.attribute.equals("single_selection"), (String)("unexpected attribute: " + this.attribute));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

